﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/medialive/MediaLiveRequest.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/EventBridgeRuleTemplateEventType.h>
#include <aws/medialive/model/EventBridgeRuleTemplateTarget.h>

#include <utility>

namespace Aws {
namespace MediaLive {
namespace Model {

/**
 * Placeholder documentation for CreateEventBridgeRuleTemplateRequest<p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateRequest">AWS
 * API Reference</a></p>
 */
class CreateEventBridgeRuleTemplateRequest : public MediaLiveRequest {
 public:
  AWS_MEDIALIVE_API CreateEventBridgeRuleTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateEventBridgeRuleTemplate"; }

  AWS_MEDIALIVE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * A resource's optional description.
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateEventBridgeRuleTemplateRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<EventBridgeRuleTemplateTarget>& GetEventTargets() const { return m_eventTargets; }
  inline bool EventTargetsHasBeenSet() const { return m_eventTargetsHasBeenSet; }
  template <typename EventTargetsT = Aws::Vector<EventBridgeRuleTemplateTarget>>
  void SetEventTargets(EventTargetsT&& value) {
    m_eventTargetsHasBeenSet = true;
    m_eventTargets = std::forward<EventTargetsT>(value);
  }
  template <typename EventTargetsT = Aws::Vector<EventBridgeRuleTemplateTarget>>
  CreateEventBridgeRuleTemplateRequest& WithEventTargets(EventTargetsT&& value) {
    SetEventTargets(std::forward<EventTargetsT>(value));
    return *this;
  }
  template <typename EventTargetsT = EventBridgeRuleTemplateTarget>
  CreateEventBridgeRuleTemplateRequest& AddEventTargets(EventTargetsT&& value) {
    m_eventTargetsHasBeenSet = true;
    m_eventTargets.emplace_back(std::forward<EventTargetsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline EventBridgeRuleTemplateEventType GetEventType() const { return m_eventType; }
  inline bool EventTypeHasBeenSet() const { return m_eventTypeHasBeenSet; }
  inline void SetEventType(EventBridgeRuleTemplateEventType value) {
    m_eventTypeHasBeenSet = true;
    m_eventType = value;
  }
  inline CreateEventBridgeRuleTemplateRequest& WithEventType(EventBridgeRuleTemplateEventType value) {
    SetEventType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * An eventbridge rule template group's identifier. Can be either be its id or
   * current name.
   */
  inline const Aws::String& GetGroupIdentifier() const { return m_groupIdentifier; }
  inline bool GroupIdentifierHasBeenSet() const { return m_groupIdentifierHasBeenSet; }
  template <typename GroupIdentifierT = Aws::String>
  void SetGroupIdentifier(GroupIdentifierT&& value) {
    m_groupIdentifierHasBeenSet = true;
    m_groupIdentifier = std::forward<GroupIdentifierT>(value);
  }
  template <typename GroupIdentifierT = Aws::String>
  CreateEventBridgeRuleTemplateRequest& WithGroupIdentifier(GroupIdentifierT&& value) {
    SetGroupIdentifier(std::forward<GroupIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A resource's name. Names must be unique within the scope of a resource type in a
   * specific region.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateEventBridgeRuleTemplateRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  CreateEventBridgeRuleTemplateRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  CreateEventBridgeRuleTemplateRequest& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * An ID that you assign to a create request. This ID ensures idempotency when
   * creating resources.
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateEventBridgeRuleTemplateRequest& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  Aws::Vector<EventBridgeRuleTemplateTarget> m_eventTargets;

  EventBridgeRuleTemplateEventType m_eventType{EventBridgeRuleTemplateEventType::NOT_SET};

  Aws::String m_groupIdentifier;

  Aws::String m_name;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_requestId{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_descriptionHasBeenSet = false;
  bool m_eventTargetsHasBeenSet = false;
  bool m_eventTypeHasBeenSet = false;
  bool m_groupIdentifierHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_requestIdHasBeenSet = true;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
