/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jungrapht.visualization.RenderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RenderContextStateChange {

    public static interface Listener<V, E> {
        public void renderContextStateChanged(Event<V, E> var1);
    }

    public static class Event<V, E> {
        public final RenderContext<V, E> renderContext;
        public final boolean active;

        public Event(RenderContext<V, E> renderContext, boolean active) {
            this.renderContext = renderContext;
            this.active = active;
        }

        public String toString() {
            return "RenderContextStateChange.Event{renderContext=" + this.renderContext + ", active=" + this.active + "}";
        }
    }

    public static class SupportImpl<V, E>
    implements Support<V, E> {
        private static final Logger log = LoggerFactory.getLogger(SupportImpl.class);
        protected boolean fireEvents = true;
        protected List<Listener> changeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            this.fireEvents = fireEvents;
        }

        @Override
        public void addRenderContextStateChangeListener(Listener l) {
            this.changeListeners.add(l);
        }

        @Override
        public void removeRenderContextStateChangeListener(Listener l) {
            this.changeListeners.remove(l);
        }

        @Override
        public List<Listener> getRenderContextStateChangeListeners() {
            return this.changeListeners;
        }

        @Override
        public void fireRenderContextStateChanged(RenderContext<V, E> renderContext, boolean state) {
            if (this.fireEvents && this.changeListeners.size() > 0) {
                Event<V, E> evt = new Event<V, E>(renderContext, state);
                for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                    this.changeListeners.get(i).renderContextStateChanged(evt);
                }
            }
        }
    }

    public static interface Support<V, E> {
        public static Support create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addRenderContextStateChangeListener(Listener var1);

        public void removeRenderContextStateChangeListener(Listener var1);

        public List<Listener> getRenderContextStateChangeListeners();

        public void fireRenderContextStateChanged(RenderContext<V, E> var1, boolean var2);
    }

    public static interface Producer {
        public Support getRenderContextStateChangeSupport();
    }
}

