/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public abstract class SectionContribution {
    protected int isect;
    protected int offset;
    protected int length;
    protected int imod;
    protected long characteristics;
    protected long dataCrc;
    protected long relocationCrc;
    protected long unknownSectionContributionField;

    public int getSection() {
        return this.isect;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getModule() {
        return this.imod;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "Issue in " + this.getClass().getSimpleName() + " toString(): " + e.getMessage();
        }
    }

    abstract void deserialize(PdbByteReader var1) throws PdbException;

    abstract void dumpInternals(Writer var1) throws IOException;

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        this.dumpInternals(writer);
        PdbReaderUtils.dumpTail(writer, this);
    }
}

