/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractPrecompiledTypeMsType
extends AbstractMsType {
    protected RecordNumber startRecordNumber;
    protected long count;
    protected long signature;
    protected String name;

    public AbstractPrecompiledTypeMsType(AbstractPdb pdb, PdbByteReader reader, int intSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.startRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, intSize);
        this.count = reader.parseVarSizedUInt(intSize);
        this.signature = reader.parseUnsignedIntVal();
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("Precompiled: signature=0X%08X, name=%s, start=%s, count=%d", this.signature, this.name, this.pdb.getTypeRecord(this.startRecordNumber).toString(), this.count));
    }
}

