/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.fs.BaseHFSAllocationFileView;
import org.catacombae.hfsexplorer.fs.ImplHFSPlusFileSystemView;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;
import org.catacombae.io.ReadableRandomAccessStream;

public class ImplHFSPlusAllocationFileView
extends BaseHFSAllocationFileView {
    private ImplHFSPlusFileSystemView hfsPlusParentView;
    private ReadableRandomAccessStream allocationFile;

    public ImplHFSPlusAllocationFileView(ImplHFSPlusFileSystemView parentView, ReadableRandomAccessStream allocationFile) {
        super(parentView, allocationFile);
        this.hfsPlusParentView = parentView;
        this.allocationFile = allocationFile;
    }

    public boolean isAllocationBlockUsed(long blockNumber) throws IllegalArgumentException {
        if (blockNumber < 0L || blockNumber > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Block number (" + blockNumber + ") out of range for UInt32!");
        }
        return super.isAllocationBlockUsed(blockNumber);
    }

    public CommonHFSExtentDescriptor createExtentDescriptor(long startBlock, long blockCount) {
        if (startBlock < 0L || startBlock > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("startBlock(" + startBlock + ") out of range for UInt32!");
        }
        if (blockCount < 0L || blockCount > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("blockCount(" + blockCount + ") out of range for UInt32!");
        }
        HFSPlusExtentDescriptor hped = new HFSPlusExtentDescriptor((int)startBlock, (int)blockCount);
        return CommonHFSExtentDescriptor.create(hped);
    }
}

