/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Color;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColumnConstraintEditor<T>
implements ColumnConstraintEditor<T> {
    protected ColumnConstraint<T> currentConstraint;
    private WeakSet<ChangeListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private Component inlineEditorComponent = null;
    private Component detailEditorComponent = null;
    private boolean validEditorValue = false;
    protected static final Color VALID_INPUT_COLOR = GThemeDefaults.Colors.BACKGROUND;
    protected static final Color INVALID_INPUT_COLOR = new GColor("color.palette.mistyrose");

    protected AbstractColumnConstraintEditor(ColumnConstraint<T> constraint) {
        this.currentConstraint = constraint;
    }

    protected abstract ColumnConstraint<T> getValueFromComponent();

    protected abstract Component buildInlineEditorComponent();

    protected abstract void updateEditorComponent();

    protected Component buildDetailEditorComponent() {
        return null;
    }

    @Override
    public final ColumnConstraint<T> getValue() {
        if (this.hasEditorComponents() && this.hasValidValue()) {
            this.currentConstraint = this.getValueFromComponent();
        }
        return this.currentConstraint;
    }

    @Override
    public final void setValue(ColumnConstraint<T> value) {
        this.currentConstraint = value;
        if (this.hasEditorComponents()) {
            this.updateEditorComponent();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (l != null) {
            this.listeners.add((Object)l);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove((Object)l);
    }

    protected void valueChanged() {
        if (!this.hasEditorComponents()) {
            return;
        }
        this.validEditorValue = this.checkEditorValueValidity();
        this.updateInfoMessage(this.validEditorValue);
        this.notifyConstraintChanged();
    }

    protected abstract void updateInfoMessage(boolean var1);

    protected abstract boolean checkEditorValueValidity();

    @Override
    public final boolean hasValidValue() {
        if (!this.hasEditorComponents()) {
            return true;
        }
        return this.validEditorValue;
    }

    protected void notifyConstraintChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public final Component getInlineComponent() {
        if (!this.hasEditorComponents()) {
            this.inlineEditorComponent = this.buildInlineEditorComponent();
            this.detailEditorComponent = this.buildDetailEditorComponent();
            this.updateEditorComponent();
            this.validEditorValue = this.checkEditorValueValidity();
            this.updateInfoMessage(this.validEditorValue);
        }
        return this.inlineEditorComponent;
    }

    @Override
    public final Component getDetailComponent() {
        if (!this.hasEditorComponents()) {
            this.inlineEditorComponent = this.buildInlineEditorComponent();
            this.detailEditorComponent = this.buildDetailEditorComponent();
            this.updateEditorComponent();
            this.validEditorValue = this.checkEditorValueValidity();
        }
        return this.detailEditorComponent;
    }

    protected final boolean hasEditorComponents() {
        return this.inlineEditorComponent != null || this.detailEditorComponent != null;
    }

    protected static final String formatStatus(String message, boolean error) {
        GColor color = error ? GThemeDefaults.Colors.Messages.ERROR : GThemeDefaults.Colors.FOREGROUND;
        String messageWithFont = HTMLUtilities.setFont((String)message, (Color)color, (int)12);
        String html = HTMLUtilities.wrapAsHTML((String)messageWithFont);
        return html;
    }
}

