/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import java.util.NoSuchElementException;

public class ShutdownPriority {
    public static final ShutdownPriority FIRST = new ShutdownPriority(Integer.MIN_VALUE);
    public static final ShutdownPriority DISPOSE_DATABASES = new ShutdownPriority(0x3FFFFFFF);
    public static final ShutdownPriority DISPOSE_FILE_HANDLES = new ShutdownPriority(0x3FFFFFFF);
    public static final ShutdownPriority SHUTDOWN_LOGGING = new ShutdownPriority(0x3FFFFFFF);
    public static final ShutdownPriority LAST = new ShutdownPriority(Integer.MAX_VALUE);
    private int priority;

    ShutdownPriority(int priority) {
        this.priority = priority;
    }

    public ShutdownPriority before() {
        if (this.priority == Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return new ShutdownPriority(this.priority - 1);
    }

    public ShutdownPriority after() {
        if (this.priority == Integer.MAX_VALUE) {
            throw new NoSuchElementException();
        }
        return new ShutdownPriority(this.priority + 1);
    }

    int getPriority() {
        return this.priority;
    }
}

