/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.ObjectStorage;
import ghidra.util.PrivateSaveable;
import java.awt.Point;

public class SaveablePoint
extends PrivateSaveable {
    private Point point;
    private Class<?>[] fields = new Class[]{Double.class, Double.class};

    public SaveablePoint() {
    }

    public SaveablePoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    @Override
    public void restore(ObjectStorage objStorage) {
        int x = objStorage.getInt();
        int y = objStorage.getInt();
        this.point = new Point(x, y);
    }

    @Override
    public void save(ObjectStorage objStorage) {
        objStorage.putInt((int)this.point.getX());
        objStorage.putInt((int)this.point.getY());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.point.equals(((SaveablePoint)obj).point);
    }

    public int hashCode() {
        return this.point.hashCode();
    }

    public String toString() {
        return this.point.toString();
    }

    @Override
    public Class<?>[] getObjectStorageFields() {
        return this.fields;
    }

    @Override
    public int getSchemaVersion() {
        return 0;
    }

    @Override
    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    @Override
    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }
}

