/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryOperations;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LockHold;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public interface InternalTraceMemoryOperations
extends TraceMemoryOperations {
    public static TraceMemoryState requireOne(Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> states, Register register) {
        if (states.isEmpty()) {
            return TraceMemoryState.UNKNOWN;
        }
        if (states.size() != 1) {
            throw new IllegalStateException("More than one state is present in " + String.valueOf(register));
        }
        return states.iterator().next().getValue();
    }

    public AddressSpace getSpace();

    public ReadWriteLock getLock();

    @Override
    default public void setState(TracePlatform platform, long snap, Register register, TraceMemoryState state) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        this.setState(snap, range, state);
    }

    @Override
    default public TraceMemoryState getState(TracePlatform platform, long snap, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        return InternalTraceMemoryOperations.requireOne(this.getStates(snap, range), register);
    }

    @Override
    default public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStates(TracePlatform platform, long snap, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        return this.getStates(snap, range);
    }

    @Override
    default public int putBytes(TracePlatform platform, long snap, Register register, ByteBuffer buf) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        int byteLength = (int)range.getLength();
        int limit = buf.limit();
        buf.limit(Math.min(limit, buf.position() + byteLength));
        int result = this.putBytes(snap, range.getMinAddress(), buf);
        buf.limit(limit);
        return result;
    }

    @Override
    default public int setValue(TracePlatform platform, long snap, RegisterValue value) {
        if (!value.hasAnyValue()) {
            return 0;
        }
        try (LockHold hold = LockHold.lock((Lock)this.getLock().writeLock());){
            Register register = value.getRegister();
            AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
            if (!value.hasValue() || !TraceRegisterUtils.isByteBound(register)) {
                RegisterValue old = this.getValue(platform, snap, register.getBaseRegister());
                value = old.combineValues(value);
            }
            ByteBuffer buf = TraceRegisterUtils.bufferForValue(register, value);
            int n = this.putBytes(snap, range.getMinAddress(), buf);
            return n;
        }
    }

    @Override
    default public RegisterValue getValue(TracePlatform platform, long snap, Register register) {
        ByteBuffer buf = TraceRegisterUtils.prepareBuffer(register);
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        this.getBytes(snap, range.getMinAddress(), buf);
        return TraceRegisterUtils.finishBuffer(buf, register);
    }

    @Override
    default public RegisterValue getViewValue(TracePlatform platform, long snap, Register register) {
        ByteBuffer buf = TraceRegisterUtils.prepareBuffer(register);
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        this.getViewBytes(snap, range.getMinAddress(), buf);
        return TraceRegisterUtils.finishBuffer(buf, register);
    }

    @Override
    default public int getBytes(TracePlatform platform, long snap, Register register, ByteBuffer buf) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        int byteLength = (int)range.getLength();
        int limit = buf.limit();
        buf.limit(Math.min(limit, buf.position() + byteLength));
        int result = this.getBytes(snap, range.getMinAddress(), buf);
        buf.limit(limit);
        return result;
    }

    @Override
    default public void removeValue(TracePlatform platform, long snap, Register register) {
        AddressRange range = platform.getConventionalRegisterRange(this.getSpace(), register);
        this.removeBytes(snap, range.getMinAddress(), (int)range.getLength());
    }
}

