/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.actions.associate.SyncAction;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HelpLocation;
import java.util.List;

public class RevertAction
extends SyncAction {
    public static final String MENU_NAME = "Revert Data Types From";

    public RevertAction(DataTypeManagerPlugin plugin, DataTypeManagerHandler dataTypeManagerHandler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive, boolean isEnabled) {
        super("Revert Data Type Changes", plugin, dataTypeManagerHandler, dtm, archiveNode, sourceArchive, isEnabled);
        this.setPopupMenuData(new MenuData(new String[]{MENU_NAME, sourceArchive.getName()}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getHelpTopic()));
    }

    @Override
    protected int getMenuOrder() {
        return 3;
    }

    @Override
    protected String getHelpTopic() {
        return "Revert_Data_Types";
    }

    @Override
    protected boolean isAppropriateForAction(DataTypeSyncInfo info) {
        switch (info.getSyncState()) {
            case COMMIT: 
            case CONFLICT: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPreselectedForAction(DataTypeSyncInfo info) {
        return false;
    }

    @Override
    protected String getOperationName() {
        return "Revert";
    }

    @Override
    protected void applyOperation(DataTypeSyncInfo info) {
        info.revert();
    }

    @Override
    protected String getConfirmationMessage(List<DataTypeSyncInfo> selectedInfos) {
        return "This will permanently discard the changes to these datatypes in this program or archive.\n\nAre you sure you want to REVERT " + selectedInfos.size() + " datatype(s)?";
    }

    @Override
    protected boolean requiresArchiveOpenForEditing() {
        return false;
    }

    @Override
    protected String getTitle(String sourceName, String clientName) {
        return "Revert Datatype Changes In \"" + clientName + "\" From Archive \"" + sourceName + "\"";
    }
}

