/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class LinkEditDataCommand
extends LoadCommand {
    protected long dataoff;
    protected long datasize;
    protected BinaryReader dataReader;

    LinkEditDataCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader);
        this.dataoff = loadCommandReader.readNextUnsignedInt();
        this.datasize = loadCommandReader.readNextUnsignedInt();
        this.dataReader = dataReader;
        this.dataReader.setPointerIndex(this.dataoff);
    }

    @Override
    public long getLinkerDataOffset() {
        return this.dataoff;
    }

    @Override
    public long getLinkerDataSize() {
        return this.datasize;
    }

    @Override
    public String getCommandName() {
        return "linkedit_data_command";
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupPlateComment(program, this.fileOffsetToAddress(program, header, this.dataoff, this.datasize), source, null);
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            if (this.datasize > 0L) {
                Address start = baseAddress.getNewAddress(this.dataoff);
                api.createFragment(parentModule, LoadCommandTypes.getLoadCommandName(this.getCommandType()), start, this.datasize);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "dataoff", null);
        struct.add(DWORD, "datasize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

