/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.features.base.memsearch.combiner.Combiner;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class SearchGuiModel {
    private SearchSettings settings;
    private List<Consumer<SearchSettings>> changeCallbacks = new ArrayList<Consumer<SearchSettings>>();
    private boolean hasSelection;
    private List<SearchRegion> regionChoices;
    private boolean autoResrictSelection = false;
    private boolean isSearchSelectionOnly;
    private Combiner combiner;

    public SearchGuiModel(SearchSettings settings, List<SearchRegion> regionChoices) {
        this.regionChoices = regionChoices;
        SearchSettings searchSettings = this.settings = settings != null ? settings : new SearchSettings();
        if (!this.isValidRegionSettings() || this.settings.getSelectedMemoryRegions().isEmpty()) {
            this.installDefaultRegions();
        }
    }

    private void installDefaultRegions() {
        HashSet<SearchRegion> defaultRegions = new HashSet<SearchRegion>();
        for (SearchRegion region : this.regionChoices) {
            if (!region.isDefault()) continue;
            defaultRegions.add(region);
        }
        this.settings = this.settings.withSelectedRegions(defaultRegions);
    }

    private boolean isValidRegionSettings() {
        for (SearchRegion region : this.settings.getSelectedMemoryRegions()) {
            if (this.regionChoices.contains(region)) continue;
            return false;
        }
        return true;
    }

    public void setAutoRestrictSelection() {
        this.autoResrictSelection = true;
    }

    public void addChangeCallback(Consumer<SearchSettings> changeCallback) {
        this.changeCallbacks.add(changeCallback);
    }

    private void notifySettingsChanged(SearchSettings oldSettings) {
        for (Consumer<SearchSettings> callback : this.changeCallbacks) {
            callback.accept(oldSettings);
        }
    }

    public boolean isSearchSelectionOnly() {
        return this.isSearchSelectionOnly;
    }

    public boolean hasSelection() {
        return this.hasSelection;
    }

    public void setHasSelection(boolean b) {
        if (this.hasSelection == b) {
            return;
        }
        this.hasSelection = b;
        if (b) {
            if (this.autoResrictSelection) {
                this.isSearchSelectionOnly = true;
            }
        } else {
            this.isSearchSelectionOnly = false;
        }
        this.notifySettingsChanged(this.settings);
    }

    public void setSearchSelectionOnly(boolean b) {
        if (this.isSearchSelectionOnly == b) {
            return;
        }
        this.isSearchSelectionOnly = b && this.hasSelection;
        this.notifySettingsChanged(this.settings);
    }

    public SearchFormat getSearchFormat() {
        return this.settings.getSearchFormat();
    }

    public SearchSettings getSettings() {
        return this.settings;
    }

    public void setSearchFormat(SearchFormat searchFormat) {
        if (searchFormat == this.settings.getSearchFormat()) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withSearchFormat(searchFormat);
        this.notifySettingsChanged(oldSettings);
    }

    public ByteMatcher parse(String proposedText) {
        return this.settings.getSearchFormat().parse(proposedText, this.settings);
    }

    public int getAlignment() {
        return this.settings.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.settings = this.settings.withAlignment(alignment);
    }

    public Set<SearchRegion> getSelectedMemoryRegions() {
        return this.settings.getSelectedMemoryRegions();
    }

    public boolean includeInstructions() {
        return this.settings.includeInstructions();
    }

    public boolean includeDefinedData() {
        return this.settings.includeDefinedData();
    }

    public boolean includeUndefinedData() {
        return this.settings.includeUndefinedData();
    }

    public void setIncludeInstructions(boolean selected) {
        this.settings = this.settings.withIncludeInstructions(selected);
    }

    public void setIncludeDefinedData(boolean selected) {
        this.settings = this.settings.withIncludeDefinedData(selected);
    }

    public void setIncludeUndefinedData(boolean selected) {
        this.settings = this.settings.withIncludeUndefinedData(selected);
    }

    public boolean isBigEndian() {
        return this.settings.isBigEndian();
    }

    public void setBigEndian(boolean b) {
        if (this.settings.isBigEndian() == b) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withBigEndian(b);
        this.notifySettingsChanged(oldSettings);
    }

    public boolean isCaseSensitive() {
        return this.settings.isCaseSensitive();
    }

    public void setCaseSensitive(boolean selected) {
        if (this.settings.isCaseSensitive() == selected) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withCaseSensitive(selected);
        this.notifySettingsChanged(oldSettings);
    }

    public boolean useEscapeSequences() {
        return this.settings.useEscapeSequences();
    }

    public void setUseEscapeSequences(boolean selected) {
        if (this.settings.useEscapeSequences() == selected) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withUseEscapeSequence(selected);
        this.notifySettingsChanged(oldSettings);
    }

    public void setDecimalUnsigned(boolean selected) {
        if (this.settings.isDecimalUnsigned() == selected) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withDecimalUnsigned(selected);
        this.notifySettingsChanged(oldSettings);
    }

    public boolean isDecimalUnsigned() {
        return this.settings.isDecimalUnsigned();
    }

    public void setDecimalByteSize(int byteSize) {
        if (this.settings.getDecimalByteSize() == byteSize) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withDecimalByteSize(byteSize);
        this.notifySettingsChanged(oldSettings);
    }

    public int getDecimalByteSize() {
        return this.settings.getDecimalByteSize();
    }

    public void setStringCharset(Charset charset) {
        if (this.settings.getStringCharset() == charset) {
            return;
        }
        SearchSettings oldSettings = this.settings;
        this.settings = this.settings.withStringCharset(charset);
        this.notifySettingsChanged(oldSettings);
    }

    public Charset getStringCharset() {
        return this.settings.getStringCharset();
    }

    public List<SearchRegion> getMemoryRegionChoices() {
        return this.regionChoices;
    }

    public void setMatchCombiner(Combiner combiner) {
        this.combiner = combiner;
    }

    public Combiner getMatchCombiner() {
        return this.combiner;
    }

    public void setAutoRestrictSelection(boolean autoRestrictSelection) {
        this.autoResrictSelection = autoRestrictSelection;
    }

    public void selectRegion(SearchRegion region, boolean selected) {
        this.settings = this.settings.withSelectedRegion(region, selected);
    }

    public boolean isSelectedRegion(SearchRegion region) {
        return this.settings.isSelectedRegion(region);
    }

    public void setSettings(SearchSettings newSettings) {
        SearchSettings oldSettings = this.settings;
        this.settings = newSettings;
        if (!this.isValidRegionSettings() || this.settings.getSelectedMemoryRegions().isEmpty()) {
            this.installDefaultRegions();
        }
        this.notifySettingsChanged(oldSettings);
    }
}

