/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.analyzers;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class CFStringAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "CFStrings";
    private static final String DESCRIPTION = "Parses CFString section in MachO files and inserts helpful EOL comment on all xrefs";
    private static final String CF_STRING_LABEL_PREFIX = "cf_";
    private static final String CFSTRING = "__cfstring";

    public CFStringAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address structEnd;
        DataType dataType = this.getDataType(program);
        MemoryBlock block = program.getMemory().getBlock(CFSTRING);
        if (block == null) {
            return false;
        }
        Address currentAddress = block.getStart();
        Address endAddress = block.getEnd();
        Listing listing = program.getListing();
        listing.clearCodeUnits(currentAddress, endAddress, true, monitor);
        while (!monitor.isCancelled() && (structEnd = currentAddress.add((long)(dataType.getLength() - 1))).compareTo((Object)block.getEnd()) <= 0) {
            try {
                Data data = program.getListing().createData(currentAddress, dataType);
                Address strAddress = (Address)data.getComponent(2).getValue();
                Scalar lengthScalar = (Scalar)data.getComponent(3).getValue();
                int length = (int)lengthScalar.getValue();
                Data stringData = program.getListing().getDataAt(strAddress);
                if (stringData == null) continue;
                if (!(stringData.getValue() instanceof String)) {
                    try {
                        listing.clearCodeUnits(strAddress, strAddress.add((long)length), true);
                        stringData = listing.createData(strAddress, (DataType)StringDataType.dataType);
                    }
                    catch (Exception e) {
                        log.appendMsg("Error creating string at address " + String.valueOf(strAddress));
                    }
                    if (!(stringData.getValue() instanceof String)) continue;
                }
                String cFString = (String)stringData.getValue();
                String symbolString = this.makeLabel(cFString);
                String comment = this.makeComment(cFString);
                program.getListing().setComment(currentAddress, CommentType.REPEATABLE, "\"" + comment + "\",00");
                if (program.getSymbolTable().getGlobalSymbol(symbolString, currentAddress) != null) continue;
                Symbol mine = program.getSymbolTable().createLabel(currentAddress, symbolString, SourceType.ANALYSIS);
                mine.setPrimary();
            }
            catch (CodeUnitInsertionException e) {
                log.appendException((Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (InvalidInputException e) {
                log.appendException((Throwable)e);
            }
            finally {
                currentAddress = currentAddress.add((long)dataType.getLength());
            }
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        return this.isMachOAndContainsCFStrings(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return this.isMachOAndContainsCFStrings(program);
    }

    private boolean isMachOAndContainsCFStrings(Program program) {
        String format = program.getExecutableFormat();
        if ("Mac OS X Mach-O".equals(format) || "DYLD Cache".equals(format) || "Extracted DYLD Component".equals(format)) {
            for (MemoryBlock block : program.getMemory().getBlocks()) {
                if (!block.getName().equals(CFSTRING)) continue;
                return true;
            }
        }
        return false;
    }

    private DataType getDataType(Program program) {
        boolean is64Bit;
        StructureDataType structure = new StructureDataType("cfstringStruct", 0);
        boolean bl = is64Bit = program.getDefaultPointerSize() == 8;
        if (is64Bit) {
            structure.add((DataType)QWordDataType.dataType);
            structure.add((DataType)QWordDataType.dataType);
            structure.add((DataType)PointerDataType.dataType, 8);
            structure.add((DataType)LongDataType.dataType, 8);
        } else {
            structure.add((DataType)DWordDataType.dataType);
            structure.add((DataType)DWordDataType.dataType);
            structure.add((DataType)PointerDataType.dataType);
            structure.add((DataType)IntegerDataType.dataType);
        }
        return structure;
    }

    private String makeComment(String cFString) {
        StringBuffer buf = new StringBuffer();
        block5: for (int i = 0; i < cFString.length(); ++i) {
            char c = cFString.charAt(i);
            switch (c) {
                case '\t': {
                    buf.append("\\t");
                    continue block5;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block5;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block5;
                }
                default: {
                    if (c >= ' ' && c < '\u0080') {
                        buf.append(c);
                        continue block5;
                    }
                    buf.append('.');
                }
            }
        }
        return buf.toString();
    }

    private String makeLabel(String cFString) {
        if (cFString.length() == 0) {
            return "cf_\"\"";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cFString.length(); ++i) {
            char c = cFString.charAt(i);
            if (c <= ' ' || c >= '\u0080') continue;
            buf.append(c);
        }
        if (buf.length() == 0) {
            if (this.doesStringContainAllSameChars(cFString)) {
                switch (cFString.charAt(0)) {
                    case '\t': {
                        buf.append("tab(s)");
                        break;
                    }
                    case '\n': {
                        buf.append("newline(s)");
                        break;
                    }
                    case '\r': {
                        buf.append("creturn(s)");
                        break;
                    }
                    case ' ': {
                        buf.append("space(s)");
                        break;
                    }
                    default: {
                        buf.append('.');
                        break;
                    }
                }
            } else {
                buf.append("format(s)");
            }
        }
        buf.insert(0, CF_STRING_LABEL_PREFIX);
        return buf.toString();
    }

    private boolean doesStringContainAllSameChars(String string) {
        char firstChar = string.charAt(0);
        for (int i = 1; i < string.length(); ++i) {
            if (string.charAt(i) == firstChar) continue;
            return false;
        }
        return true;
    }
}

