/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.impl.MarkupItemImpl;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.stringable.StringStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class CommentMarkupType
extends VTMarkupType {
    public CommentMarkupType(String name) {
        super(name);
    }

    protected abstract CommentType getCodeUnitCommentType();

    protected abstract ProgramLocation getLocation(VTAssociation var1, Address var2, boolean var3);

    @Override
    public ProgramLocation getDestinationLocation(VTAssociation association, Address destinationAddress) {
        return this.getLocation(association, destinationAddress, false);
    }

    @Override
    public ProgramLocation getSourceLocation(VTAssociation association, Address sourceAddress) {
        return this.getLocation(association, sourceAddress, true);
    }

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        AddressSetView addressSet;
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Listing sourceListing = sourceProgram.getListing();
        Address sourceAddress = association.getSourceAddress();
        FunctionManager functionManager = sourceProgram.getFunctionManager();
        Function sourceFunction = functionManager.getFunctionAt(sourceAddress);
        if (sourceFunction == null) {
            CodeUnit codeUnit = sourceListing.getCodeUnitAt(sourceAddress);
            Address minAddress = codeUnit == null ? sourceAddress : codeUnit.getMinAddress();
            Address maxAddress = codeUnit == null ? sourceAddress : codeUnit.getMaxAddress();
            addressSet = new AddressSet(minAddress, maxAddress);
        } else {
            addressSet = sourceFunction.getBody();
        }
        AddressIterator commentAddressIterator = sourceListing.getCommentAddressIterator(this.getCodeUnitCommentType(), addressSet, true);
        while (commentAddressIterator.hasNext()) {
            Address address = commentAddressIterator.next();
            this.addCommentMarkup(list, address, association, sourceListing);
        }
        return list;
    }

    protected void addCommentMarkup(List<VTMarkupItem> list, Address commentAddress, VTAssociation association, Listing sourceListing) {
        boolean hasSourceComment;
        String sourceComment = sourceListing.getComment(this.getCodeUnitCommentType(), commentAddress);
        boolean bl = hasSourceComment = sourceComment != null && sourceComment.length() > 0;
        if (!hasSourceComment) {
            return;
        }
        list.add(new MarkupItemImpl(association, this, commentAddress));
    }

    @Override
    public boolean supportsAssociationType(VTAssociationType matchType) {
        return true;
    }

    private String getSourceComment(VTAssociation association, Address sourceAddress) {
        CommentType commentType = this.getCodeUnitCommentType();
        Listing sourceListing = this.getSourceListing(association);
        return sourceListing.getComment(commentType, sourceAddress);
    }

    @Override
    public Stringable getSourceValue(VTAssociation association, Address sourceAddress) {
        return new StringStringable(this.getSourceComment(association, sourceAddress));
    }

    @Override
    public void unapplyMarkup(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (status == VTMarkupItemStatus.DONT_CARE) {
            return;
        }
        Address destinationAddress = markupItem.getDestinationAddress();
        StringStringable originalDestinationValue = (StringStringable)markupItem.getOriginalDestinationValue();
        StringStringable currentDestinationValue = (StringStringable)markupItem.getCurrentDestinationValue();
        if (currentDestinationValue == null) {
            throw new VersionTrackingApplyException("No value applied");
        }
        String originalDestinationComment = originalDestinationValue.getString();
        CommentType commentType = this.getCodeUnitCommentType();
        Listing destinationListing = this.getDestinationListing(markupItem.getAssociation());
        String comment = destinationListing.getComment(commentType, destinationAddress);
        if (!StringUtils.equals((CharSequence)originalDestinationComment, (CharSequence)comment)) {
            destinationListing.setComment(destinationAddress, commentType, originalDestinationComment);
        }
    }

    public abstract VTMatchApplyChoices.CommentChoices getCommentChoice(ToolOptions var1);

    @Override
    public boolean applyMarkup(VTMarkupItem markupItem, ToolOptions markupOptions) throws VersionTrackingApplyException {
        String sourceComment;
        Address destinationAddress = markupItem.getDestinationAddress();
        VTMatchApplyChoices.CommentChoices commentChoice = this.getCommentChoice(markupOptions);
        if (commentChoice == VTMatchApplyChoices.CommentChoices.EXCLUDE) {
            return false;
        }
        if (destinationAddress == null) {
            throw new VersionTrackingApplyException("The destination address cannot be null!");
        }
        if (destinationAddress == Address.NO_ADDRESS) {
            throw new VersionTrackingApplyException("The destination address cannot be No Address!");
        }
        Stringable sourceValue = markupItem.getSourceValue();
        if (sourceValue == null) {
            throw new VersionTrackingApplyException("Cannot apply comment.  The data from the source program no longer exists. Markup Item: " + String.valueOf(markupItem));
        }
        String comment = sourceComment = ((StringStringable)sourceValue).getString();
        if (commentChoice == VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING) {
            StringStringable destinationValue = (StringStringable)this.getCurrentDestinationValue(markupItem.getAssociation(), destinationAddress);
            String destinationComment = destinationValue.getString();
            comment = StringUtilities.mergeStrings((String)destinationComment, (String)sourceComment);
        }
        CommentType commentType = this.getCodeUnitCommentType();
        Listing destinationListing = this.getDestinationListing(markupItem.getAssociation());
        destinationListing.setComment(destinationAddress, commentType, comment);
        return true;
    }

    private String getDestinationComment(VTAssociation association, Address destinationAddress) {
        if (destinationAddress != null && destinationAddress != Address.NO_ADDRESS) {
            CommentType commentType = this.getCodeUnitCommentType();
            Listing destinationListing = this.getDestinationListing(association);
            return destinationListing.getComment(commentType, destinationAddress);
        }
        return null;
    }

    @Override
    public Stringable getCurrentDestinationValue(VTAssociation association, Address destinationAddress) {
        return new StringStringable(this.getDestinationComment(association, destinationAddress));
    }

    @Override
    public Stringable getOriginalDestinationValue(VTAssociation association, Address destinationAddress) {
        Stringable appliedMarkupOriginalValue = null;
        try {
            appliedMarkupOriginalValue = this.getOriginalDestinationValueForAppliedMarkupOfThisType(association, destinationAddress, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        if (appliedMarkupOriginalValue != null) {
            return appliedMarkupOriginalValue;
        }
        return this.getCurrentDestinationValue(association, destinationAddress);
    }

    @Override
    public boolean hasSameSourceAndDestinationValues(VTMarkupItem markupItem) {
        VTAssociation association = markupItem.getAssociation();
        Address sourceAddress = markupItem.getSourceAddress();
        Address destinationAddress = markupItem.getDestinationAddress();
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            return false;
        }
        String sourceComment = this.getSourceComment(association, sourceAddress);
        String destinationComment = this.getDestinationComment(association, destinationAddress);
        return SystemUtilities.isEqual((Object)sourceComment, (Object)destinationComment);
    }

    @Override
    public boolean supportsApplyAction(VTMarkupItemApplyActionType applyAction) {
        return applyAction == VTMarkupItemApplyActionType.ADD || applyAction == VTMarkupItemApplyActionType.REPLACE;
    }
}

