/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.module.ModuleDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ModuleDBAdapterV1
extends ModuleDBAdapter {
    static final int V1_VERSION = 1;
    static final int V1_MODULE_NAME_COL = 0;
    static final int V1_MODULE_COMMENTS_COL = 1;
    static final int V1_MODULE_CHILD_COUNT_COL = 2;
    static final Schema V1_MODULE_SCHEMA = new Schema(1, "Key", new Field[]{StringField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE}, new String[]{"Name", "Comments", "ChildCount"});
    private Table moduleTable;

    public ModuleDBAdapterV1(DBHandle handle, boolean create, long treeID) throws VersionException, IOException {
        String tableName = ModuleDBAdapterV1.getTableName(treeID);
        if (create) {
            this.moduleTable = handle.createTable(tableName, V1_MODULE_SCHEMA, new int[]{0});
        } else {
            this.moduleTable = handle.getTable(tableName);
            if (this.moduleTable == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.moduleTable.getSchema().getVersion();
            if (version != 1) {
                throw new VersionException(version < 1);
            }
        }
    }

    @Override
    public DBRecord createModuleRecord(long parentModuleID, String name) throws IOException {
        DBRecord record = V1_MODULE_SCHEMA.createRecord(this.moduleTable.getKey());
        record.setString(0, name);
        this.moduleTable.putRecord(record);
        return record;
    }

    @Override
    DBRecord getModuleRecord(long key) throws IOException {
        return this.moduleTable.getRecord(key);
    }

    @Override
    DBRecord getModuleRecord(String name) throws IOException {
        Field[] keys = this.moduleTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " modules named " + name);
        }
        return this.moduleTable.getRecord(keys[0]);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.moduleTable.iterator();
    }

    @Override
    void updateModuleRecord(DBRecord record) throws IOException {
        this.moduleTable.putRecord(record);
    }

    @Override
    boolean removeModuleRecord(long childID) throws IOException {
        return this.moduleTable.deleteRecord(childID);
    }
}

