/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.VariableLocation;

public class VariableCommentFieldLocation
extends VariableLocation {
    private String comment;

    public VariableCommentFieldLocation(Program program, Address locationAddr, Variable var, int charOffset) {
        super(program, locationAddr, var, 0, charOffset);
        this.comment = var.getComment();
    }

    public VariableCommentFieldLocation(Program program, Variable var, int charOffset) {
        super(program, var, 0, charOffset);
        this.comment = var.getComment();
    }

    public VariableCommentFieldLocation() {
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableCommentFieldLocation other = (VariableCommentFieldLocation)obj;
        return !(this.comment == null ? other.comment != null : !this.comment.equals(other.comment));
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.comment = obj.getString("_COMMENT", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_COMMNET", this.comment);
    }
}

