/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.table.AbstractTableModel;

public class DefaultEventTableModel<E>
extends AbstractTableModel
implements AdvancedTableModel<E>,
ListEventListener<E> {
    protected EventList<E> source;
    private boolean disposeSource;
    private TableFormat<? super E> tableFormat;
    private TableModelEventAdapter<E> eventAdapter = GlazedListsSwing.defaultEventAdapterFactory().create(this);

    public DefaultEventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        this(source, false, tableFormat);
    }

    public DefaultEventTableModel(EventList<E> source, boolean disposeSource, TableFormat<? super E> tableFormat) {
        this.source = source;
        this.disposeSource = disposeSource;
        this.tableFormat = tableFormat;
        source.addListEventListener(this);
    }

    @Override
    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    @Override
    public void setTableFormat(TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.eventAdapter.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getElementAt(int index) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.handleListChange(listChanges);
    }

    protected void handleListChange(ListEvent<E> listChanges) {
        this.eventAdapter.listChanged(listChanges);
    }

    @Override
    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.source.get(row), column);
            return object;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            return false;
        }
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object toEdit = this.source.get(row);
            boolean bl = ((WritableTableFormat)this.tableFormat).isEditable(toEdit, column);
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            Object baseObject = this.source.get(row);
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject != null) {
                boolean baseObjectHasNotMoved;
                boolean bl = baseObjectHasNotMoved = row < this.getRowCount() && this.source.get(row) == baseObject;
                if (baseObjectHasNotMoved) {
                    this.source.set(row, updatedObject);
                }
            }
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
        this.source = null;
    }

    public final TableModelEventAdapter<E> getEventAdapter() {
        return this.eventAdapter;
    }

    public final void setEventAdapter(TableModelEventAdapter<E> eventAdapter) {
        this.eventAdapter = eventAdapter;
    }
}

