/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.task.shard.BatchSizeSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u0017J\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0017J.\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\u000b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e \u000f*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r \u000f**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e \u000f*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationChangesTracker;", "", "indexShard", "Lorg/opensearch/index/shard/IndexShard;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "(Lorg/opensearch/index/shard/IndexShard;Lorg/opensearch/replication/ReplicationSettings;)V", "batchSizeSettings", "Lorg/opensearch/replication/task/shard/BatchSizeSettings;", "log", "Lorg/apache/logging/log4j/Logger;", "missingBatches", "", "Lkotlin/Pair;", "", "kotlin.jvm.PlatformType", "", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "observedSeqNoAtLeader", "Ljava/util/concurrent/atomic/AtomicLong;", "seqNoAlreadyRequested", "logDebug", "", "msg", "", "logInfo", "reduceBatchSize", "requestBatchToFetch", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetBatchSize", "updateBatchFetched", "success", "", "fromSeqNoRequested", "toSeqNoRequested", "toSeqNoReceived", "seqNoAtLeader", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nShardReplicationChangesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShardReplicationChangesTracker.kt\norg/opensearch/replication/task/shard/ShardReplicationChangesTracker\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n107#2,10:155\n1#3:165\n*S KotlinDebug\n*F\n+ 1 ShardReplicationChangesTracker.kt\norg/opensearch/replication/task/shard/ShardReplicationChangesTracker\n*L\n55#1:155,10\n*E\n"})
public final class ShardReplicationChangesTracker {
    @NotNull
    private final ReplicationSettings replicationSettings;
    @NotNull
    private final Logger log;
    @NotNull
    private final Mutex mutex;
    private final List<Pair<Long, Long>> missingBatches;
    @NotNull
    private final AtomicLong observedSeqNoAtLeader;
    @NotNull
    private final AtomicLong seqNoAlreadyRequested;
    @NotNull
    private final BatchSizeSettings batchSizeSettings;

    public ShardReplicationChangesTracker(@NotNull IndexShard indexShard, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)indexShard, (String)"indexShard");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        this.replicationSettings = replicationSettings;
        Logger logger = Loggers.getLogger(this.getClass(), (ShardId)indexShard.shardId(), (String[])new String[0]);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.missingBatches = Collections.synchronizedList(new ArrayList());
        this.observedSeqNoAtLeader = new AtomicLong(indexShard.getLocalCheckpoint());
        this.seqNoAlreadyRequested = new AtomicLong(indexShard.getLocalCheckpoint());
        IndexSettings indexSettings = indexShard.indexSettings();
        Intrinsics.checkNotNullExpressionValue((Object)indexSettings, (String)"indexSettings(...)");
        this.batchSizeSettings = new BatchSizeSettings(indexSettings, this.replicationSettings);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object requestBatchToFetch(@NotNull Continuation<? super Pair<Long, Long>> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void reduceBatchSize() {
        this.batchSizeSettings.reduceBatchSize();
        this.logInfo("Batch size reduced to " + this.batchSizeSettings.getEffectiveBatchSize());
    }

    public final void resetBatchSize() {
        this.batchSizeSettings.resetBatchSize();
        this.logInfo("Batch size reset to " + this.batchSizeSettings.getEffectiveBatchSize());
    }

    @NotNull
    public final BatchSizeSettings batchSizeSettings() {
        return this.batchSizeSettings;
    }

    public final void updateBatchFetched(boolean success, long fromSeqNoRequested, long toSeqNoRequested, long toSeqNoReceived, long seqNoAtLeader) {
        if (success) {
            boolean bl;
            boolean bl2 = bl = toSeqNoRequested >= toSeqNoReceived;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = Thread.currentThread().getName() + " Got more operations in the batch than requested";
                throw new AssertionError((Object)string);
            }
            this.logDebug("Updating the batch fetched. " + fromSeqNoRequested + "-" + toSeqNoReceived + "/" + toSeqNoRequested + ", seqNoAtLeader:" + seqNoAtLeader);
            if (toSeqNoRequested > toSeqNoReceived) {
                if (this.seqNoAlreadyRequested.get() == toSeqNoRequested) {
                    this.seqNoAlreadyRequested.updateAndGet(arg_0 -> ShardReplicationChangesTracker.updateBatchFetched$lambda$2(toSeqNoReceived, arg_0));
                } else {
                    this.logDebug("Didn't get the complete batch. Adding the missing operations " + (toSeqNoReceived + 1L) + "-" + toSeqNoRequested);
                    this.missingBatches.add((Pair<Long, Long>)new Pair((Object)(toSeqNoReceived + 1L), (Object)toSeqNoRequested));
                }
            }
            this.observedSeqNoAtLeader.getAndUpdate(arg_0 -> ShardReplicationChangesTracker.updateBatchFetched$lambda$3(seqNoAtLeader, arg_0));
            this.logDebug("observedSeqNoAtLeader: " + this.observedSeqNoAtLeader.get());
        } else if (this.seqNoAlreadyRequested.get() == toSeqNoRequested) {
            this.seqNoAlreadyRequested.updateAndGet(arg_0 -> ShardReplicationChangesTracker.updateBatchFetched$lambda$4(fromSeqNoRequested, arg_0));
        } else {
            this.logDebug("Adding batch to missing " + fromSeqNoRequested + "-" + toSeqNoRequested);
            this.missingBatches.add((Pair<Long, Long>)new Pair((Object)fromSeqNoRequested, (Object)toSeqNoRequested));
        }
    }

    private final void logDebug(String msg) {
        this.log.debug(Thread.currentThread().getName() + ": " + msg);
    }

    private final void logInfo(String msg) {
        this.log.info(Thread.currentThread().getName() + ": " + msg);
    }

    private static final long updateBatchFetched$lambda$2(long $toSeqNoReceived, long it) {
        return $toSeqNoReceived;
    }

    private static final long updateBatchFetched$lambda$3(long $seqNoAtLeader, long value) {
        return $seqNoAtLeader > value ? $seqNoAtLeader : value;
    }

    private static final long updateBatchFetched$lambda$4(long $fromSeqNoRequested, long it) {
        return $fromSeqNoRequested - 1L;
    }
}

