/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.remote_info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.remote_info.ClusterRemoteInfo;
import org.opensearch.client.opensearch.cluster.remote_info.ClusterRemoteInfoVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterRemoteSniffInfo
implements ClusterRemoteInfoVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterRemoteSniffInfo> {
    private final boolean connected;
    @Nonnull
    private final Time initialConnectTimeout;
    private final int maxConnectionsPerCluster;
    private final long numNodesConnected;
    @Nonnull
    private final List<String> seeds;
    private final boolean skipUnavailable;
    public static final JsonpDeserializer<ClusterRemoteSniffInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteSniffInfo::setupClusterRemoteSniffInfoDeserializer);

    private ClusterRemoteSniffInfo(Builder builder) {
        this.connected = ApiTypeHelper.requireNonNull(builder.connected, this, "connected");
        this.initialConnectTimeout = ApiTypeHelper.requireNonNull(builder.initialConnectTimeout, this, "initialConnectTimeout");
        this.maxConnectionsPerCluster = ApiTypeHelper.requireNonNull(builder.maxConnectionsPerCluster, this, "maxConnectionsPerCluster");
        this.numNodesConnected = ApiTypeHelper.requireNonNull(builder.numNodesConnected, this, "numNodesConnected");
        this.seeds = ApiTypeHelper.unmodifiableRequired(builder.seeds, (Object)this, "seeds");
        this.skipUnavailable = ApiTypeHelper.requireNonNull(builder.skipUnavailable, this, "skipUnavailable");
    }

    public static ClusterRemoteSniffInfo of(Function<Builder, ObjectBuilder<ClusterRemoteSniffInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ClusterRemoteInfo.Kind _clusterRemoteInfoKind() {
        return ClusterRemoteInfo.Kind.Sniff;
    }

    public final boolean connected() {
        return this.connected;
    }

    @Nonnull
    public final Time initialConnectTimeout() {
        return this.initialConnectTimeout;
    }

    public final int maxConnectionsPerCluster() {
        return this.maxConnectionsPerCluster;
    }

    public final long numNodesConnected() {
        return this.numNodesConnected;
    }

    @Nonnull
    public final List<String> seeds() {
        return this.seeds;
    }

    public final boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("mode", "sniff");
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("initial_connect_timeout");
        this.initialConnectTimeout.serialize(generator, mapper);
        generator.writeKey("max_connections_per_cluster");
        generator.write(this.maxConnectionsPerCluster);
        generator.writeKey("num_nodes_connected");
        generator.write(this.numNodesConnected);
        generator.writeKey("seeds");
        generator.writeStartArray();
        for (String item0 : this.seeds) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterRemoteSniffInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected");
        op.add(Builder::initialConnectTimeout, Time._DESERIALIZER, "initial_connect_timeout");
        op.add(Builder::maxConnectionsPerCluster, JsonpDeserializer.integerDeserializer(), "max_connections_per_cluster");
        op.add(Builder::numNodesConnected, JsonpDeserializer.longDeserializer(), "num_nodes_connected");
        op.add(Builder::seeds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seeds");
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable");
        op.ignore("mode");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.connected);
        result = 31 * result + this.initialConnectTimeout.hashCode();
        result = 31 * result + Integer.hashCode(this.maxConnectionsPerCluster);
        result = 31 * result + Long.hashCode(this.numNodesConnected);
        result = 31 * result + this.seeds.hashCode();
        result = 31 * result + Boolean.hashCode(this.skipUnavailable);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRemoteSniffInfo other = (ClusterRemoteSniffInfo)o;
        return this.connected == other.connected && this.initialConnectTimeout.equals(other.initialConnectTimeout) && this.maxConnectionsPerCluster == other.maxConnectionsPerCluster && this.numNodesConnected == other.numNodesConnected && this.seeds.equals(other.seeds) && this.skipUnavailable == other.skipUnavailable;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterRemoteSniffInfo> {
        private Boolean connected;
        private Time initialConnectTimeout;
        private Integer maxConnectionsPerCluster;
        private Long numNodesConnected;
        private List<String> seeds;
        private Boolean skipUnavailable;

        public Builder() {
        }

        private Builder(ClusterRemoteSniffInfo o) {
            this.connected = o.connected;
            this.initialConnectTimeout = o.initialConnectTimeout;
            this.maxConnectionsPerCluster = o.maxConnectionsPerCluster;
            this.numNodesConnected = o.numNodesConnected;
            this.seeds = Builder._listCopy(o.seeds);
            this.skipUnavailable = o.skipUnavailable;
        }

        private Builder(Builder o) {
            this.connected = o.connected;
            this.initialConnectTimeout = o.initialConnectTimeout;
            this.maxConnectionsPerCluster = o.maxConnectionsPerCluster;
            this.numNodesConnected = o.numNodesConnected;
            this.seeds = Builder._listCopy(o.seeds);
            this.skipUnavailable = o.skipUnavailable;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        @Nonnull
        public final Builder initialConnectTimeout(Time value) {
            this.initialConnectTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder initialConnectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.initialConnectTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder maxConnectionsPerCluster(int value) {
            this.maxConnectionsPerCluster = value;
            return this;
        }

        @Nonnull
        public final Builder numNodesConnected(long value) {
            this.numNodesConnected = value;
            return this;
        }

        @Nonnull
        public final Builder seeds(List<String> list) {
            this.seeds = Builder._listAddAll(this.seeds, list);
            return this;
        }

        @Nonnull
        public final Builder seeds(String value, String ... values) {
            this.seeds = Builder._listAdd(this.seeds, value, values);
            return this;
        }

        @Nonnull
        public final Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterRemoteSniffInfo build() {
            this._checkSingleUse();
            return new ClusterRemoteSniffInfo(this);
        }
    }
}

