# main.py

#
# Copyright 2022 user

#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import gi

gi.require_version("Gtk", "4.0")
gi.require_version("Adw", "1")
gi.require_version("GtkSource", "5")
gi.require_version("Vte", "3.91")


from gi.repository import Gtk, Gio, Adw, GLib
from jade_gui.window import JadeGuiWindow


class Jade_guiApplication(Adw.Application):
    """The main application singleton class."""

    def __init__(self):
        super().__init__(
            application_id="moe.ewe.os.jadegui", flags=Gio.ApplicationFlags.HANDLES_COMMAND_LINE
        )

        self.add_main_option(
            "full-screen",
            ord("f"),
            GLib.OptionFlags.OPTIONAL_ARG,
            GLib.OptionArg.NONE,
            "Launch at full screen mode",
            None,
        )
        self._fullscreen = False

        self.create_action("quit", self.quit, ["<primary>q"])
        self.create_action("about", self.on_about_action)
        self.create_action("preferences", self.on_preferences_action)

    def do_activate(self):
        """Called when the application is activated.

        We raise the application's main window, creating it if
        necessary.
        """
        win = self.props.active_window
        if not win:
            win = JadeGuiWindow(application=self)

        if self._fullscreen:
            win.fullscreen()

        win.present()

    def on_about_action(self, widget, _):
        """Callback for the app.about action."""
        about = AboutDialog(self.props.active_window)
        about.present()

    def on_preferences_action(self, widget, _):
        """Callback for the app.preferences action."""
        print("app.preferences action activated")

    def do_command_line(self, cmdline):
        options = cmdline.get_options_dict()
        options = options.end().unpack()
        if "full-screen" in options:
            self._fullscreen = True
        self.activate()
        return 0           

    def create_action(self, name, callback, shortcuts=None):
        """Add an application action.

        Args:
            name: the name of the action
            callback: the function to be called when the action is activated
            shortcuts: an optional list of accelerators
        """
        action = Gio.SimpleAction.new(name, None)
        action.connect("activate", callback)
        self.add_action(action)
        if shortcuts:
            self.set_accels_for_action(f"app.{name}", shortcuts)


def main(version):
    """The application's entry point."""
    app = Jade_guiApplication()
    return app.run(sys.argv)
