# The PEP 484 type hints stub file for the QtOpenGL module.
#
# Generated by SIP 6.12.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt6.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt6.sip.Buffer, int, None]
PYQT_SHADER_ATTRIBUTE_ARRAY = typing.Union[typing.Sequence[QtGui.QVector2D],
        typing.Sequence[QtGui.QVector3D], typing.Sequence[QtGui.QVector4D],
        typing.Sequence[typing.Sequence[float]]]
PYQT_SHADER_UNIFORM_VALUE_ARRAY = typing.Union[
        typing.Sequence[QtGui.QVector2D], typing.Sequence[QtGui.QVector3D],
        typing.Sequence[QtGui.QVector4D], typing.Sequence[QtGui.QMatrix2x2],
        typing.Sequence[QtGui.QMatrix2x3], typing.Sequence[QtGui.QMatrix2x4],
        typing.Sequence[QtGui.QMatrix3x2], typing.Sequence[QtGui.QMatrix3x3],
        typing.Sequence[QtGui.QMatrix3x4], typing.Sequence[QtGui.QMatrix4x2],
        typing.Sequence[QtGui.QMatrix4x3], typing.Sequence[QtGui.QMatrix4x4],
        typing.Sequence[typing.Sequence[float]]]


class QOpenGLBuffer(PyQt6.sip.simplewrapper):

    class RangeAccessFlag(enum.Flag):
        RangeRead = ... # type: QOpenGLBuffer.RangeAccessFlag
        RangeWrite = ... # type: QOpenGLBuffer.RangeAccessFlag
        RangeInvalidate = ... # type: QOpenGLBuffer.RangeAccessFlag
        RangeInvalidateBuffer = ... # type: QOpenGLBuffer.RangeAccessFlag
        RangeFlushExplicit = ... # type: QOpenGLBuffer.RangeAccessFlag
        RangeUnsynchronized = ... # type: QOpenGLBuffer.RangeAccessFlag

    class Access(enum.Enum):
        ReadOnly = ... # type: QOpenGLBuffer.Access
        WriteOnly = ... # type: QOpenGLBuffer.Access
        ReadWrite = ... # type: QOpenGLBuffer.Access

    class UsagePattern(enum.Enum):
        StreamDraw = ... # type: QOpenGLBuffer.UsagePattern
        StreamRead = ... # type: QOpenGLBuffer.UsagePattern
        StreamCopy = ... # type: QOpenGLBuffer.UsagePattern
        StaticDraw = ... # type: QOpenGLBuffer.UsagePattern
        StaticRead = ... # type: QOpenGLBuffer.UsagePattern
        StaticCopy = ... # type: QOpenGLBuffer.UsagePattern
        DynamicDraw = ... # type: QOpenGLBuffer.UsagePattern
        DynamicRead = ... # type: QOpenGLBuffer.UsagePattern
        DynamicCopy = ... # type: QOpenGLBuffer.UsagePattern

    class Type(enum.Enum):
        VertexBuffer = ... # type: QOpenGLBuffer.Type
        IndexBuffer = ... # type: QOpenGLBuffer.Type
        PixelPackBuffer = ... # type: QOpenGLBuffer.Type
        PixelUnpackBuffer = ... # type: QOpenGLBuffer.Type

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: 'QOpenGLBuffer.Type') -> None: ...
    @typing.overload
    def __init__(self, other: 'QOpenGLBuffer') -> None: ...

    def swap(self, other: 'QOpenGLBuffer') -> None: ...
    def mapRange(self, offset: int, count: int, access: 'QOpenGLBuffer.RangeAccessFlag') -> typing.Optional[PyQt6.sip.voidptr]: ...
    def unmap(self) -> bool: ...
    def map(self, access: 'QOpenGLBuffer.Access') -> typing.Optional[PyQt6.sip.voidptr]: ...
    @typing.overload
    def allocate(self, data: typing.Optional[PyQt6.sip.voidptr], count: int) -> None: ...
    @typing.overload
    def allocate(self, count: int) -> None: ...
    def write(self, offset: int, data: typing.Optional[PyQt6.sip.voidptr], count: int) -> None: ...
    def read(self, offset: int, data: typing.Optional[PyQt6.sip.voidptr], count: int) -> bool: ...
    def __len__(self) -> int: ...
    def size(self) -> int: ...
    def bufferId(self) -> int: ...
    @typing.overload
    def release(self) -> None: ...
    @typing.overload
    @staticmethod
    def release(type: 'QOpenGLBuffer.Type') -> None: ...
    def bind(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def create(self) -> bool: ...
    def setUsagePattern(self, value: 'QOpenGLBuffer.UsagePattern') -> None: ...
    def usagePattern(self) -> 'QOpenGLBuffer.UsagePattern': ...
    def type(self) -> 'QOpenGLBuffer.Type': ...


class QOpenGLDebugMessage(PyQt6.sip.simplewrapper):

    class Severity(enum.Flag):
        InvalidSeverity = ... # type: QOpenGLDebugMessage.Severity
        HighSeverity = ... # type: QOpenGLDebugMessage.Severity
        MediumSeverity = ... # type: QOpenGLDebugMessage.Severity
        LowSeverity = ... # type: QOpenGLDebugMessage.Severity
        NotificationSeverity = ... # type: QOpenGLDebugMessage.Severity
        AnySeverity = ... # type: QOpenGLDebugMessage.Severity

    class Type(enum.Flag):
        InvalidType = ... # type: QOpenGLDebugMessage.Type
        ErrorType = ... # type: QOpenGLDebugMessage.Type
        DeprecatedBehaviorType = ... # type: QOpenGLDebugMessage.Type
        UndefinedBehaviorType = ... # type: QOpenGLDebugMessage.Type
        PortabilityType = ... # type: QOpenGLDebugMessage.Type
        PerformanceType = ... # type: QOpenGLDebugMessage.Type
        OtherType = ... # type: QOpenGLDebugMessage.Type
        MarkerType = ... # type: QOpenGLDebugMessage.Type
        GroupPushType = ... # type: QOpenGLDebugMessage.Type
        GroupPopType = ... # type: QOpenGLDebugMessage.Type
        AnyType = ... # type: QOpenGLDebugMessage.Type

    class Source(enum.Flag):
        InvalidSource = ... # type: QOpenGLDebugMessage.Source
        APISource = ... # type: QOpenGLDebugMessage.Source
        WindowSystemSource = ... # type: QOpenGLDebugMessage.Source
        ShaderCompilerSource = ... # type: QOpenGLDebugMessage.Source
        ThirdPartySource = ... # type: QOpenGLDebugMessage.Source
        ApplicationSource = ... # type: QOpenGLDebugMessage.Source
        OtherSource = ... # type: QOpenGLDebugMessage.Source
        AnySource = ... # type: QOpenGLDebugMessage.Source

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, debugMessage: 'QOpenGLDebugMessage') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    @staticmethod
    def createThirdPartyMessage(text: typing.Optional[str], id: int = ..., severity: 'QOpenGLDebugMessage.Severity' = ..., type: 'QOpenGLDebugMessage.Type' = ...) -> 'QOpenGLDebugMessage': ...
    @staticmethod
    def createApplicationMessage(text: typing.Optional[str], id: int = ..., severity: 'QOpenGLDebugMessage.Severity' = ..., type: 'QOpenGLDebugMessage.Type' = ...) -> 'QOpenGLDebugMessage': ...
    def message(self) -> str: ...
    def id(self) -> int: ...
    def severity(self) -> 'QOpenGLDebugMessage.Severity': ...
    def type(self) -> 'QOpenGLDebugMessage.Type': ...
    def source(self) -> 'QOpenGLDebugMessage.Source': ...
    def swap(self, debugMessage: 'QOpenGLDebugMessage') -> None: ...


class QOpenGLDebugLogger(QtCore.QObject):

    class LoggingMode(enum.Enum):
        AsynchronousLogging = ... # type: QOpenGLDebugLogger.LoggingMode
        SynchronousLogging = ... # type: QOpenGLDebugLogger.LoggingMode

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    messageLogged: typing.ClassVar[QtCore.pyqtSignal]
    def stopLogging(self) -> None: ...
    def startLogging(self, loggingMode: 'QOpenGLDebugLogger.LoggingMode' = ...) -> None: ...
    def logMessage(self, debugMessage: QOpenGLDebugMessage) -> None: ...
    def loggedMessages(self) -> list[QOpenGLDebugMessage]: ...
    @typing.overload
    def disableMessages(self, sources: QOpenGLDebugMessage.Source = ..., types: QOpenGLDebugMessage.Type = ..., severities: QOpenGLDebugMessage.Severity = ...) -> None: ...
    @typing.overload
    def disableMessages(self, ids: collections.abc.Iterable[int], sources: QOpenGLDebugMessage.Source = ..., types: QOpenGLDebugMessage.Type = ...) -> None: ...
    @typing.overload
    def enableMessages(self, sources: QOpenGLDebugMessage.Source = ..., types: QOpenGLDebugMessage.Type = ..., severities: QOpenGLDebugMessage.Severity = ...) -> None: ...
    @typing.overload
    def enableMessages(self, ids: collections.abc.Iterable[int], sources: QOpenGLDebugMessage.Source = ..., types: QOpenGLDebugMessage.Type = ...) -> None: ...
    def popGroup(self) -> None: ...
    def pushGroup(self, name: typing.Optional[str], id: int = ..., source: QOpenGLDebugMessage.Source = ...) -> None: ...
    def maximumMessageLength(self) -> int: ...
    def loggingMode(self) -> 'QOpenGLDebugLogger.LoggingMode': ...
    def isLogging(self) -> bool: ...
    def initialize(self) -> bool: ...


class QOpenGLFramebufferObject(PyQt6.sip.simplewrapper):

    class FramebufferRestorePolicy(enum.Enum):
        DontRestoreFramebufferBinding = ... # type: QOpenGLFramebufferObject.FramebufferRestorePolicy
        RestoreFramebufferBindingToDefault = ... # type: QOpenGLFramebufferObject.FramebufferRestorePolicy
        RestoreFrameBufferBinding = ... # type: QOpenGLFramebufferObject.FramebufferRestorePolicy

    class Attachment(enum.Enum):
        NoAttachment = ... # type: QOpenGLFramebufferObject.Attachment
        CombinedDepthStencil = ... # type: QOpenGLFramebufferObject.Attachment
        Depth = ... # type: QOpenGLFramebufferObject.Attachment

    @typing.overload
    def __init__(self, size: QtCore.QSize, target: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...
    @typing.overload
    def __init__(self, size: QtCore.QSize, attachment: 'QOpenGLFramebufferObject.Attachment', target: int = ..., internal_format: int = ...) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, attachment: 'QOpenGLFramebufferObject.Attachment', target: int = ..., internal_format: int = ...) -> None: ...
    @typing.overload
    def __init__(self, size: QtCore.QSize, format: 'QOpenGLFramebufferObjectFormat') -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: 'QOpenGLFramebufferObjectFormat') -> None: ...

    def sizes(self) -> list[QtCore.QSize]: ...
    @typing.overload
    def addColorAttachment(self, size: QtCore.QSize, internal_format: int = ...) -> None: ...
    @typing.overload
    def addColorAttachment(self, width: int, height: int, internal_format: int = ...) -> None: ...
    @typing.overload
    def takeTexture(self) -> int: ...
    @typing.overload
    def takeTexture(self, colorAttachmentIndex: int) -> int: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: typing.Optional['QOpenGLFramebufferObject'], targetRect: QtCore.QRect, source: typing.Optional['QOpenGLFramebufferObject'], sourceRect: QtCore.QRect, buffers: int = ..., filter: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: typing.Optional['QOpenGLFramebufferObject'], source: typing.Optional['QOpenGLFramebufferObject'], buffers: int = ..., filter: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: typing.Optional['QOpenGLFramebufferObject'], targetRect: QtCore.QRect, source: typing.Optional['QOpenGLFramebufferObject'], sourceRect: QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int) -> None: ...
    @typing.overload
    @staticmethod
    def blitFramebuffer(target: typing.Optional['QOpenGLFramebufferObject'], targetRect: QtCore.QRect, source: typing.Optional['QOpenGLFramebufferObject'], sourceRect: QtCore.QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int, restorePolicy: 'QOpenGLFramebufferObject.FramebufferRestorePolicy') -> None: ...
    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool: ...
    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool: ...
    @staticmethod
    def bindDefault() -> bool: ...
    def handle(self) -> int: ...
    def setAttachment(self, attachment: 'QOpenGLFramebufferObject.Attachment') -> None: ...
    def attachment(self) -> 'QOpenGLFramebufferObject.Attachment': ...
    @typing.overload
    def toImage(self, flipped: bool = ...) -> QtGui.QImage: ...
    @typing.overload
    def toImage(self, flipped: bool, colorAttachmentIndex: int) -> QtGui.QImage: ...
    def size(self) -> QtCore.QSize: ...
    def textures(self) -> list[int]: ...
    def texture(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def release(self) -> bool: ...
    def bind(self) -> bool: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def format(self) -> 'QOpenGLFramebufferObjectFormat': ...


class QOpenGLFramebufferObjectFormat(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QOpenGLFramebufferObjectFormat') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def internalTextureFormat(self) -> int: ...
    def setInternalTextureFormat(self, internalTextureFormat: int) -> None: ...
    def textureTarget(self) -> int: ...
    def setTextureTarget(self, target: int) -> None: ...
    def attachment(self) -> QOpenGLFramebufferObject.Attachment: ...
    def setAttachment(self, attachment: QOpenGLFramebufferObject.Attachment) -> None: ...
    def mipmap(self) -> bool: ...
    def setMipmap(self, enabled: bool) -> None: ...
    def samples(self) -> int: ...
    def setSamples(self, samples: int) -> None: ...


class QOpenGLPaintDevice(QtGui.QPaintDevice):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int) -> None: ...

    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def setDevicePixelRatio(self, devicePixelRatio: float) -> None: ...
    def ensureActiveTarget(self) -> None: ...
    def paintFlipped(self) -> bool: ...
    def setPaintFlipped(self, flipped: bool) -> None: ...
    def setDotsPerMeterY(self, a0: float) -> None: ...
    def setDotsPerMeterX(self, a0: float) -> None: ...
    def dotsPerMeterY(self) -> float: ...
    def dotsPerMeterX(self) -> float: ...
    def setSize(self, size: QtCore.QSize) -> None: ...
    def size(self) -> QtCore.QSize: ...
    def context(self) -> typing.Optional[QtGui.QOpenGLContext]: ...
    def paintEngine(self) -> typing.Optional[QtGui.QPaintEngine]: ...


class QOpenGLPixelTransferOptions(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QOpenGLPixelTransferOptions') -> None: ...

    def isSwapBytesEnabled(self) -> bool: ...
    def setSwapBytesEnabled(self, swapBytes: bool) -> None: ...
    def isLeastSignificantBitFirst(self) -> bool: ...
    def setLeastSignificantByteFirst(self, lsbFirst: bool) -> None: ...
    def rowLength(self) -> int: ...
    def setRowLength(self, rowLength: int) -> None: ...
    def imageHeight(self) -> int: ...
    def setImageHeight(self, imageHeight: int) -> None: ...
    def skipPixels(self) -> int: ...
    def setSkipPixels(self, skipPixels: int) -> None: ...
    def skipRows(self) -> int: ...
    def setSkipRows(self, skipRows: int) -> None: ...
    def skipImages(self) -> int: ...
    def setSkipImages(self, skipImages: int) -> None: ...
    def alignment(self) -> int: ...
    def setAlignment(self, alignment: int) -> None: ...
    def swap(self, other: 'QOpenGLPixelTransferOptions') -> None: ...


class QOpenGLShader(QtCore.QObject):

    class ShaderTypeBit(enum.Flag):
        Vertex = ... # type: QOpenGLShader.ShaderTypeBit
        Fragment = ... # type: QOpenGLShader.ShaderTypeBit
        Geometry = ... # type: QOpenGLShader.ShaderTypeBit
        TessellationControl = ... # type: QOpenGLShader.ShaderTypeBit
        TessellationEvaluation = ... # type: QOpenGLShader.ShaderTypeBit
        Compute = ... # type: QOpenGLShader.ShaderTypeBit

    def __init__(self, type: 'QOpenGLShader.ShaderTypeBit', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def hasOpenGLShaders(type: 'QOpenGLShader.ShaderTypeBit', context: typing.Optional[QtGui.QOpenGLContext] = ...) -> bool: ...
    def shaderId(self) -> int: ...
    def log(self) -> str: ...
    def isCompiled(self) -> bool: ...
    def sourceCode(self) -> QtCore.QByteArray: ...
    def compileSourceFile(self, fileName: typing.Optional[str]) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    @typing.overload
    def compileSourceCode(self, source: typing.Optional[str]) -> bool: ...
    def shaderType(self) -> 'QOpenGLShader.ShaderTypeBit': ...


class QOpenGLShaderProgram(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def addCacheableShaderFromSourceFile(self, type: QOpenGLShader.ShaderTypeBit, fileName: typing.Optional[str]) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type: QOpenGLShader.ShaderTypeBit, source: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    @typing.overload
    def addCacheableShaderFromSourceCode(self, type: QOpenGLShader.ShaderTypeBit, source: typing.Optional[str]) -> bool: ...
    def create(self) -> bool: ...
    def defaultInnerTessellationLevels(self) -> list[float]: ...
    def setDefaultInnerTessellationLevels(self, levels: collections.abc.Iterable[float]) -> None: ...
    def defaultOuterTessellationLevels(self) -> list[float]: ...
    def setDefaultOuterTessellationLevels(self, levels: collections.abc.Iterable[float]) -> None: ...
    def patchVertexCount(self) -> int: ...
    def setPatchVertexCount(self, count: int) -> None: ...
    def maxGeometryOutputVertices(self) -> int: ...
    @staticmethod
    def hasOpenGLShaderPrograms(context: typing.Optional[QtGui.QOpenGLContext] = ...) -> bool: ...
    @typing.overload
    def setUniformValueArray(self, location: int, values: PYQT_SHADER_UNIFORM_VALUE_ARRAY) -> None: ...
    @typing.overload
    def setUniformValueArray(self, name: typing.Optional[str], values: PYQT_SHADER_UNIFORM_VALUE_ARRAY) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: int) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: float) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, point: QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, point: QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, size: QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, location: int, value: QtGui.QTransform) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: int) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: float) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], x: float, y: float) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], x: float, y: float, z: float) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], x: float, y: float, z: float, w: float) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QVector2D) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QVector3D) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QVector4D) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], point: QtCore.QPoint) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], point: QtCore.QPointF) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], size: QtCore.QSize) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix2x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix2x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix2x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix3x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix3x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix3x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix4x2) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix4x3) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QMatrix4x4) -> None: ...
    @typing.overload
    def setUniformValue(self, name: typing.Optional[str], value: QtGui.QTransform) -> None: ...
    @typing.overload
    def uniformLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> int: ...
    @typing.overload
    def uniformLocation(self, name: typing.Optional[str]) -> int: ...
    @typing.overload
    def disableAttributeArray(self, location: int) -> None: ...
    @typing.overload
    def disableAttributeArray(self, name: typing.Optional[str]) -> None: ...
    @typing.overload
    def enableAttributeArray(self, location: int) -> None: ...
    @typing.overload
    def enableAttributeArray(self, name: typing.Optional[str]) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @typing.overload
    def setAttributeBuffer(self, name: typing.Optional[str], type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @typing.overload
    def setAttributeArray(self, location: int, values: PYQT_SHADER_ATTRIBUTE_ARRAY) -> None: ...
    @typing.overload
    def setAttributeArray(self, name: typing.Optional[str], values: PYQT_SHADER_ATTRIBUTE_ARRAY) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, value: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, value: QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, location: int, value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], value: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], x: float, y: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], x: float, y: float, z: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], x: float, y: float, z: float, w: float) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], value: QtGui.QVector2D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], value: QtGui.QVector3D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], value: QtGui.QVector4D) -> None: ...
    @typing.overload
    def setAttributeValue(self, name: typing.Optional[str], value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    @typing.overload
    def attributeLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> int: ...
    @typing.overload
    def attributeLocation(self, name: typing.Optional[str]) -> int: ...
    @typing.overload
    def bindAttributeLocation(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview], location: int) -> None: ...
    @typing.overload
    def bindAttributeLocation(self, name: typing.Optional[str], location: int) -> None: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def bind(self) -> bool: ...
    def log(self) -> str: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def removeAllShaders(self) -> None: ...
    def addShaderFromSourceFile(self, type: QOpenGLShader.ShaderTypeBit, fileName: typing.Optional[str]) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type: QOpenGLShader.ShaderTypeBit, source: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    @typing.overload
    def addShaderFromSourceCode(self, type: QOpenGLShader.ShaderTypeBit, source: typing.Optional[str]) -> bool: ...
    def shaders(self) -> list[QOpenGLShader]: ...
    def removeShader(self, shader: typing.Optional[QOpenGLShader]) -> None: ...
    def addShader(self, shader: typing.Optional[QOpenGLShader]) -> bool: ...


class QOpenGLTexture(PyQt6.sip.simplewrapper):

    class ComparisonMode(enum.Enum):
        CompareRefToTexture = ... # type: QOpenGLTexture.ComparisonMode
        CompareNone = ... # type: QOpenGLTexture.ComparisonMode

    class ComparisonFunction(enum.Enum):
        CompareLessEqual = ... # type: QOpenGLTexture.ComparisonFunction
        CompareGreaterEqual = ... # type: QOpenGLTexture.ComparisonFunction
        CompareLess = ... # type: QOpenGLTexture.ComparisonFunction
        CompareGreater = ... # type: QOpenGLTexture.ComparisonFunction
        CompareEqual = ... # type: QOpenGLTexture.ComparisonFunction
        CommpareNotEqual = ... # type: QOpenGLTexture.ComparisonFunction
        CompareAlways = ... # type: QOpenGLTexture.ComparisonFunction
        CompareNever = ... # type: QOpenGLTexture.ComparisonFunction
        CompareNotEqual = ... # type: QOpenGLTexture.ComparisonFunction

    class CoordinateDirection(enum.Enum):
        DirectionS = ... # type: QOpenGLTexture.CoordinateDirection
        DirectionT = ... # type: QOpenGLTexture.CoordinateDirection
        DirectionR = ... # type: QOpenGLTexture.CoordinateDirection

    class WrapMode(enum.Enum):
        Repeat = ... # type: QOpenGLTexture.WrapMode
        MirroredRepeat = ... # type: QOpenGLTexture.WrapMode
        ClampToEdge = ... # type: QOpenGLTexture.WrapMode
        ClampToBorder = ... # type: QOpenGLTexture.WrapMode

    class Filter(enum.Enum):
        Nearest = ... # type: QOpenGLTexture.Filter
        Linear = ... # type: QOpenGLTexture.Filter
        NearestMipMapNearest = ... # type: QOpenGLTexture.Filter
        NearestMipMapLinear = ... # type: QOpenGLTexture.Filter
        LinearMipMapNearest = ... # type: QOpenGLTexture.Filter
        LinearMipMapLinear = ... # type: QOpenGLTexture.Filter

    class DepthStencilMode(enum.Enum):
        DepthMode = ... # type: QOpenGLTexture.DepthStencilMode
        StencilMode = ... # type: QOpenGLTexture.DepthStencilMode

    class SwizzleValue(enum.Enum):
        RedValue = ... # type: QOpenGLTexture.SwizzleValue
        GreenValue = ... # type: QOpenGLTexture.SwizzleValue
        BlueValue = ... # type: QOpenGLTexture.SwizzleValue
        AlphaValue = ... # type: QOpenGLTexture.SwizzleValue
        ZeroValue = ... # type: QOpenGLTexture.SwizzleValue
        OneValue = ... # type: QOpenGLTexture.SwizzleValue

    class SwizzleComponent(enum.Enum):
        SwizzleRed = ... # type: QOpenGLTexture.SwizzleComponent
        SwizzleGreen = ... # type: QOpenGLTexture.SwizzleComponent
        SwizzleBlue = ... # type: QOpenGLTexture.SwizzleComponent
        SwizzleAlpha = ... # type: QOpenGLTexture.SwizzleComponent

    class Feature(enum.Flag):
        ImmutableStorage = ... # type: QOpenGLTexture.Feature
        ImmutableMultisampleStorage = ... # type: QOpenGLTexture.Feature
        TextureRectangle = ... # type: QOpenGLTexture.Feature
        TextureArrays = ... # type: QOpenGLTexture.Feature
        Texture3D = ... # type: QOpenGLTexture.Feature
        TextureMultisample = ... # type: QOpenGLTexture.Feature
        TextureBuffer = ... # type: QOpenGLTexture.Feature
        TextureCubeMapArrays = ... # type: QOpenGLTexture.Feature
        Swizzle = ... # type: QOpenGLTexture.Feature
        StencilTexturing = ... # type: QOpenGLTexture.Feature
        AnisotropicFiltering = ... # type: QOpenGLTexture.Feature
        NPOTTextures = ... # type: QOpenGLTexture.Feature
        NPOTTextureRepeat = ... # type: QOpenGLTexture.Feature
        Texture1D = ... # type: QOpenGLTexture.Feature
        TextureComparisonOperators = ... # type: QOpenGLTexture.Feature
        TextureMipMapLevel = ... # type: QOpenGLTexture.Feature

    class PixelType(enum.Enum):
        NoPixelType = ... # type: QOpenGLTexture.PixelType
        Int8 = ... # type: QOpenGLTexture.PixelType
        UInt8 = ... # type: QOpenGLTexture.PixelType
        Int16 = ... # type: QOpenGLTexture.PixelType
        UInt16 = ... # type: QOpenGLTexture.PixelType
        Int32 = ... # type: QOpenGLTexture.PixelType
        UInt32 = ... # type: QOpenGLTexture.PixelType
        Float16 = ... # type: QOpenGLTexture.PixelType
        Float16OES = ... # type: QOpenGLTexture.PixelType
        Float32 = ... # type: QOpenGLTexture.PixelType
        UInt32_RGB9_E5 = ... # type: QOpenGLTexture.PixelType
        UInt32_RG11B10F = ... # type: QOpenGLTexture.PixelType
        UInt8_RG3B2 = ... # type: QOpenGLTexture.PixelType
        UInt8_RG3B2_Rev = ... # type: QOpenGLTexture.PixelType
        UInt16_RGB5A1 = ... # type: QOpenGLTexture.PixelType
        UInt16_RGB5A1_Rev = ... # type: QOpenGLTexture.PixelType
        UInt16_R5G6B5 = ... # type: QOpenGLTexture.PixelType
        UInt16_R5G6B5_Rev = ... # type: QOpenGLTexture.PixelType
        UInt16_RGBA4 = ... # type: QOpenGLTexture.PixelType
        UInt16_RGBA4_Rev = ... # type: QOpenGLTexture.PixelType
        UInt32_RGB10A2 = ... # type: QOpenGLTexture.PixelType
        UInt32_RGB10A2_Rev = ... # type: QOpenGLTexture.PixelType
        UInt32_RGBA8 = ... # type: QOpenGLTexture.PixelType
        UInt32_RGBA8_Rev = ... # type: QOpenGLTexture.PixelType
        UInt32_D24S8 = ... # type: QOpenGLTexture.PixelType
        Float32_D32_UInt32_S8_X24 = ... # type: QOpenGLTexture.PixelType

    class PixelFormat(enum.Enum):
        NoSourceFormat = ... # type: QOpenGLTexture.PixelFormat
        Red = ... # type: QOpenGLTexture.PixelFormat
        RG = ... # type: QOpenGLTexture.PixelFormat
        RGB = ... # type: QOpenGLTexture.PixelFormat
        BGR = ... # type: QOpenGLTexture.PixelFormat
        RGBA = ... # type: QOpenGLTexture.PixelFormat
        BGRA = ... # type: QOpenGLTexture.PixelFormat
        Red_Integer = ... # type: QOpenGLTexture.PixelFormat
        RG_Integer = ... # type: QOpenGLTexture.PixelFormat
        RGB_Integer = ... # type: QOpenGLTexture.PixelFormat
        BGR_Integer = ... # type: QOpenGLTexture.PixelFormat
        RGBA_Integer = ... # type: QOpenGLTexture.PixelFormat
        BGRA_Integer = ... # type: QOpenGLTexture.PixelFormat
        Depth = ... # type: QOpenGLTexture.PixelFormat
        DepthStencil = ... # type: QOpenGLTexture.PixelFormat
        Alpha = ... # type: QOpenGLTexture.PixelFormat
        Luminance = ... # type: QOpenGLTexture.PixelFormat
        LuminanceAlpha = ... # type: QOpenGLTexture.PixelFormat
        Stencil = ... # type: QOpenGLTexture.PixelFormat

    class CubeMapFace(enum.Enum):
        CubeMapPositiveX = ... # type: QOpenGLTexture.CubeMapFace
        CubeMapNegativeX = ... # type: QOpenGLTexture.CubeMapFace
        CubeMapPositiveY = ... # type: QOpenGLTexture.CubeMapFace
        CubeMapNegativeY = ... # type: QOpenGLTexture.CubeMapFace
        CubeMapPositiveZ = ... # type: QOpenGLTexture.CubeMapFace
        CubeMapNegativeZ = ... # type: QOpenGLTexture.CubeMapFace

    class TextureFormat(enum.Enum):
        NoFormat = ... # type: QOpenGLTexture.TextureFormat
        R8_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RG8_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB8_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RGBA8_UNorm = ... # type: QOpenGLTexture.TextureFormat
        R16_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RG16_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB16_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RGBA16_UNorm = ... # type: QOpenGLTexture.TextureFormat
        R8_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RG8_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB8_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGBA8_SNorm = ... # type: QOpenGLTexture.TextureFormat
        R16_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RG16_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB16_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGBA16_SNorm = ... # type: QOpenGLTexture.TextureFormat
        R8U = ... # type: QOpenGLTexture.TextureFormat
        RG8U = ... # type: QOpenGLTexture.TextureFormat
        RGB8U = ... # type: QOpenGLTexture.TextureFormat
        RGBA8U = ... # type: QOpenGLTexture.TextureFormat
        R16U = ... # type: QOpenGLTexture.TextureFormat
        RG16U = ... # type: QOpenGLTexture.TextureFormat
        RGB16U = ... # type: QOpenGLTexture.TextureFormat
        RGBA16U = ... # type: QOpenGLTexture.TextureFormat
        R32U = ... # type: QOpenGLTexture.TextureFormat
        RG32U = ... # type: QOpenGLTexture.TextureFormat
        RGB32U = ... # type: QOpenGLTexture.TextureFormat
        RGBA32U = ... # type: QOpenGLTexture.TextureFormat
        R8I = ... # type: QOpenGLTexture.TextureFormat
        RG8I = ... # type: QOpenGLTexture.TextureFormat
        RGB8I = ... # type: QOpenGLTexture.TextureFormat
        RGBA8I = ... # type: QOpenGLTexture.TextureFormat
        R16I = ... # type: QOpenGLTexture.TextureFormat
        RG16I = ... # type: QOpenGLTexture.TextureFormat
        RGB16I = ... # type: QOpenGLTexture.TextureFormat
        RGBA16I = ... # type: QOpenGLTexture.TextureFormat
        R32I = ... # type: QOpenGLTexture.TextureFormat
        RG32I = ... # type: QOpenGLTexture.TextureFormat
        RGB32I = ... # type: QOpenGLTexture.TextureFormat
        RGBA32I = ... # type: QOpenGLTexture.TextureFormat
        R16F = ... # type: QOpenGLTexture.TextureFormat
        RG16F = ... # type: QOpenGLTexture.TextureFormat
        RGB16F = ... # type: QOpenGLTexture.TextureFormat
        RGBA16F = ... # type: QOpenGLTexture.TextureFormat
        R32F = ... # type: QOpenGLTexture.TextureFormat
        RG32F = ... # type: QOpenGLTexture.TextureFormat
        RGB32F = ... # type: QOpenGLTexture.TextureFormat
        RGBA32F = ... # type: QOpenGLTexture.TextureFormat
        RGB9E5 = ... # type: QOpenGLTexture.TextureFormat
        RG11B10F = ... # type: QOpenGLTexture.TextureFormat
        RG3B2 = ... # type: QOpenGLTexture.TextureFormat
        R5G6B5 = ... # type: QOpenGLTexture.TextureFormat
        RGB5A1 = ... # type: QOpenGLTexture.TextureFormat
        RGBA4 = ... # type: QOpenGLTexture.TextureFormat
        RGB10A2 = ... # type: QOpenGLTexture.TextureFormat
        D16 = ... # type: QOpenGLTexture.TextureFormat
        D24 = ... # type: QOpenGLTexture.TextureFormat
        D24S8 = ... # type: QOpenGLTexture.TextureFormat
        D32 = ... # type: QOpenGLTexture.TextureFormat
        D32F = ... # type: QOpenGLTexture.TextureFormat
        D32FS8X24 = ... # type: QOpenGLTexture.TextureFormat
        RGB_DXT1 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_DXT1 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_DXT3 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_DXT5 = ... # type: QOpenGLTexture.TextureFormat
        R_ATI1N_UNorm = ... # type: QOpenGLTexture.TextureFormat
        R_ATI1N_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RG_ATI2N_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RG_ATI2N_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB_BP_UNSIGNED_FLOAT = ... # type: QOpenGLTexture.TextureFormat
        RGB_BP_SIGNED_FLOAT = ... # type: QOpenGLTexture.TextureFormat
        RGB_BP_UNorm = ... # type: QOpenGLTexture.TextureFormat
        SRGB8 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8 = ... # type: QOpenGLTexture.TextureFormat
        SRGB_DXT1 = ... # type: QOpenGLTexture.TextureFormat
        SRGB_Alpha_DXT1 = ... # type: QOpenGLTexture.TextureFormat
        SRGB_Alpha_DXT3 = ... # type: QOpenGLTexture.TextureFormat
        SRGB_Alpha_DXT5 = ... # type: QOpenGLTexture.TextureFormat
        SRGB_BP_UNorm = ... # type: QOpenGLTexture.TextureFormat
        DepthFormat = ... # type: QOpenGLTexture.TextureFormat
        AlphaFormat = ... # type: QOpenGLTexture.TextureFormat
        RGBFormat = ... # type: QOpenGLTexture.TextureFormat
        RGBAFormat = ... # type: QOpenGLTexture.TextureFormat
        LuminanceFormat = ... # type: QOpenGLTexture.TextureFormat
        LuminanceAlphaFormat = ... # type: QOpenGLTexture.TextureFormat
        S8 = ... # type: QOpenGLTexture.TextureFormat
        R11_EAC_UNorm = ... # type: QOpenGLTexture.TextureFormat
        R11_EAC_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RG11_EAC_UNorm = ... # type: QOpenGLTexture.TextureFormat
        RG11_EAC_SNorm = ... # type: QOpenGLTexture.TextureFormat
        RGB8_ETC2 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_ETC2 = ... # type: QOpenGLTexture.TextureFormat
        RGB8_PunchThrough_Alpha1_ETC2 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_PunchThrough_Alpha1_ETC2 = ... # type: QOpenGLTexture.TextureFormat
        RGBA8_ETC2_EAC = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ETC2_EAC = ... # type: QOpenGLTexture.TextureFormat
        RGB8_ETC1 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_4x4 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_5x4 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_5x5 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_6x5 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_6x6 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_8x5 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_8x6 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_8x8 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_10x5 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_10x6 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_10x8 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_10x10 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_12x10 = ... # type: QOpenGLTexture.TextureFormat
        RGBA_ASTC_12x12 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_4x4 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_5x4 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_5x5 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_6x5 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_6x6 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_8x5 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_8x6 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_8x8 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_10x5 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_10x6 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_10x8 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_10x10 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_12x10 = ... # type: QOpenGLTexture.TextureFormat
        SRGB8_Alpha8_ASTC_12x12 = ... # type: QOpenGLTexture.TextureFormat

    class TextureUnitReset(enum.Enum):
        ResetTextureUnit = ... # type: QOpenGLTexture.TextureUnitReset
        DontResetTextureUnit = ... # type: QOpenGLTexture.TextureUnitReset

    class MipMapGeneration(enum.Enum):
        GenerateMipMaps = ... # type: QOpenGLTexture.MipMapGeneration
        DontGenerateMipMaps = ... # type: QOpenGLTexture.MipMapGeneration

    class BindingTarget(enum.Enum):
        BindingTarget1D = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget1DArray = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget2D = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget2DArray = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget3D = ... # type: QOpenGLTexture.BindingTarget
        BindingTargetCubeMap = ... # type: QOpenGLTexture.BindingTarget
        BindingTargetCubeMapArray = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget2DMultisample = ... # type: QOpenGLTexture.BindingTarget
        BindingTarget2DMultisampleArray = ... # type: QOpenGLTexture.BindingTarget
        BindingTargetRectangle = ... # type: QOpenGLTexture.BindingTarget
        BindingTargetBuffer = ... # type: QOpenGLTexture.BindingTarget

    class Target(enum.Enum):
        Target1D = ... # type: QOpenGLTexture.Target
        Target1DArray = ... # type: QOpenGLTexture.Target
        Target2D = ... # type: QOpenGLTexture.Target
        Target2DArray = ... # type: QOpenGLTexture.Target
        Target3D = ... # type: QOpenGLTexture.Target
        TargetCubeMap = ... # type: QOpenGLTexture.Target
        TargetCubeMapArray = ... # type: QOpenGLTexture.Target
        Target2DMultisample = ... # type: QOpenGLTexture.Target
        Target2DMultisampleArray = ... # type: QOpenGLTexture.Target
        TargetRectangle = ... # type: QOpenGLTexture.Target
        TargetBuffer = ... # type: QOpenGLTexture.Target

    @typing.overload
    def __init__(self, target: 'QOpenGLTexture.Target') -> None: ...
    @typing.overload
    def __init__(self, image: QtGui.QImage, genMipMaps: 'QOpenGLTexture.MipMapGeneration' = ...) -> None: ...

    def comparisonMode(self) -> 'QOpenGLTexture.ComparisonMode': ...
    def setComparisonMode(self, mode: 'QOpenGLTexture.ComparisonMode') -> None: ...
    def comparisonFunction(self) -> 'QOpenGLTexture.ComparisonFunction': ...
    def setComparisonFunction(self, function: 'QOpenGLTexture.ComparisonFunction') -> None: ...
    def isFixedSamplePositions(self) -> bool: ...
    def setFixedSamplePositions(self, fixed: bool) -> None: ...
    def samples(self) -> int: ...
    def setSamples(self, samples: int) -> None: ...
    def target(self) -> 'QOpenGLTexture.Target': ...
    def levelofDetailBias(self) -> float: ...
    def setLevelofDetailBias(self, bias: float) -> None: ...
    def levelOfDetailRange(self) -> tuple[float, float]: ...
    def setLevelOfDetailRange(self, min: float, max: float) -> None: ...
    def maximumLevelOfDetail(self) -> float: ...
    def setMaximumLevelOfDetail(self, value: float) -> None: ...
    def minimumLevelOfDetail(self) -> float: ...
    def setMinimumLevelOfDetail(self, value: float) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setBorderColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, int]) -> None: ...
    def wrapMode(self, direction: 'QOpenGLTexture.CoordinateDirection') -> 'QOpenGLTexture.WrapMode': ...
    @typing.overload
    def setWrapMode(self, mode: 'QOpenGLTexture.WrapMode') -> None: ...
    @typing.overload
    def setWrapMode(self, direction: 'QOpenGLTexture.CoordinateDirection', mode: 'QOpenGLTexture.WrapMode') -> None: ...
    def maximumAnisotropy(self) -> float: ...
    def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
    def minMagFilters(self) -> tuple['QOpenGLTexture.Filter', 'QOpenGLTexture.Filter']: ...
    def setMinMagFilters(self, minificationFilter: 'QOpenGLTexture.Filter', magnificationFilter: 'QOpenGLTexture.Filter') -> None: ...
    def magnificationFilter(self) -> 'QOpenGLTexture.Filter': ...
    def setMagnificationFilter(self, filter: 'QOpenGLTexture.Filter') -> None: ...
    def minificationFilter(self) -> 'QOpenGLTexture.Filter': ...
    def setMinificationFilter(self, filter: 'QOpenGLTexture.Filter') -> None: ...
    def depthStencilMode(self) -> 'QOpenGLTexture.DepthStencilMode': ...
    def setDepthStencilMode(self, mode: 'QOpenGLTexture.DepthStencilMode') -> None: ...
    def swizzleMask(self, component: 'QOpenGLTexture.SwizzleComponent') -> 'QOpenGLTexture.SwizzleValue': ...
    @typing.overload
    def setSwizzleMask(self, component: 'QOpenGLTexture.SwizzleComponent', value: 'QOpenGLTexture.SwizzleValue') -> None: ...
    @typing.overload
    def setSwizzleMask(self, r: 'QOpenGLTexture.SwizzleValue', g: 'QOpenGLTexture.SwizzleValue', b: 'QOpenGLTexture.SwizzleValue', a: 'QOpenGLTexture.SwizzleValue') -> None: ...
    @typing.overload
    def generateMipMaps(self) -> None: ...
    @typing.overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...) -> None: ...
    def isAutoMipMapGenerationEnabled(self) -> bool: ...
    def setAutoMipMapGenerationEnabled(self, enabled: bool) -> None: ...
    def mipLevelRange(self) -> tuple[int, int]: ...
    def setMipLevelRange(self, baseLevel: int, maxLevel: int) -> None: ...
    def mipMaxLevel(self) -> int: ...
    def setMipMaxLevel(self, maxLevel: int) -> None: ...
    def mipBaseLevel(self) -> int: ...
    def setMipBaseLevel(self, baseLevel: int) -> None: ...
    @staticmethod
    def hasFeature(feature: 'QOpenGLTexture.Feature') -> bool: ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, cubeFace: 'QOpenGLTexture.CubeMapFace', dataSize: int, data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, dataSize: int, data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, dataSize: int, data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setCompressedData(self, dataSize: int, data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setCompressedData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: 'QOpenGLTexture.CubeMapFace', dataSize: int, data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, cubeFace: 'QOpenGLTexture.CubeMapFace', sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, mipLevel: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, image: QtGui.QImage, genMipMaps: 'QOpenGLTexture.MipMapGeneration' = ...) -> None: ...
    @typing.overload
    def setData(self, mipLevel: int, layer: int, layerCount: int, cubeFace: 'QOpenGLTexture.CubeMapFace', sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, cubeFace: 'QOpenGLTexture.CubeMapFace', sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    @typing.overload
    def setData(self, xOffset: int, yOffset: int, zOffset: int, width: int, height: int, depth: int, mipLevel: int, layer: int, cubeFace: 'QOpenGLTexture.CubeMapFace', layerCount: int, sourceFormat: 'QOpenGLTexture.PixelFormat', sourceType: 'QOpenGLTexture.PixelType', data: typing.Optional[PyQt6.sip.voidptr], options: typing.Optional[QOpenGLPixelTransferOptions] = ...) -> None: ...
    def isTextureView(self) -> bool: ...
    def createTextureView(self, target: 'QOpenGLTexture.Target', viewFormat: 'QOpenGLTexture.TextureFormat', minimumMipmapLevel: int, maximumMipmapLevel: int, minimumLayer: int, maximumLayer: int) -> typing.Optional['QOpenGLTexture']: ...
    def isStorageAllocated(self) -> bool: ...
    @typing.overload
    def allocateStorage(self) -> None: ...
    @typing.overload
    def allocateStorage(self, pixelFormat: 'QOpenGLTexture.PixelFormat', pixelType: 'QOpenGLTexture.PixelType') -> None: ...
    def faces(self) -> int: ...
    def layers(self) -> int: ...
    def setLayers(self, layers: int) -> None: ...
    def maximumMipLevels(self) -> int: ...
    def mipLevels(self) -> int: ...
    def setMipLevels(self, levels: int) -> None: ...
    def depth(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
    def format(self) -> 'QOpenGLTexture.TextureFormat': ...
    def setFormat(self, format: 'QOpenGLTexture.TextureFormat') -> None: ...
    @typing.overload
    @staticmethod
    def boundTextureId(target: 'QOpenGLTexture.BindingTarget') -> int: ...
    @typing.overload
    @staticmethod
    def boundTextureId(unit: int, target: 'QOpenGLTexture.BindingTarget') -> int: ...
    @typing.overload
    def isBound(self) -> bool: ...
    @typing.overload
    def isBound(self, unit: int) -> bool: ...
    @typing.overload
    def release(self) -> None: ...
    @typing.overload
    def release(self, unit: int, reset: 'QOpenGLTexture.TextureUnitReset' = ...) -> None: ...
    @typing.overload
    def bind(self) -> None: ...
    @typing.overload
    def bind(self, unit: int, reset: 'QOpenGLTexture.TextureUnitReset' = ...) -> None: ...
    def textureId(self) -> int: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...


class QOpenGLTextureBlitter(PyQt6.sip.simplewrapper):

    class Origin(enum.Enum):
        OriginBottomLeft = ... # type: QOpenGLTextureBlitter.Origin
        OriginTopLeft = ... # type: QOpenGLTextureBlitter.Origin

    def __init__(self) -> None: ...

    def supportsRectangleTarget(self) -> bool: ...
    @staticmethod
    def sourceTransform(subTexture: QtCore.QRectF, textureSize: QtCore.QSize, origin: 'QOpenGLTextureBlitter.Origin') -> QtGui.QMatrix3x3: ...
    @staticmethod
    def targetTransform(target: QtCore.QRectF, viewport: QtCore.QRect) -> QtGui.QMatrix4x4: ...
    @typing.overload
    def blit(self, texture: int, targetTransform: QtGui.QMatrix4x4, sourceOrigin: 'QOpenGLTextureBlitter.Origin') -> None: ...
    @typing.overload
    def blit(self, texture: int, targetTransform: QtGui.QMatrix4x4, sourceTransform: QtGui.QMatrix3x3) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setRedBlueSwizzle(self, swizzle: bool) -> None: ...
    def release(self) -> None: ...
    def bind(self, target: int = ...) -> None: ...
    def supportsExternalOESTarget(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def create(self) -> bool: ...


class QAbstractOpenGLFunctions(PyQt6.sip.wrapper): ...


class QOpenGLVersionFunctionsFactory(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QOpenGLVersionFunctionsFactory') -> None: ...

    @staticmethod
    def get(versionProfile: 'QOpenGLVersionProfile' = ..., context: typing.Optional[QtGui.QOpenGLContext] = ...) -> QAbstractOpenGLFunctions: ...


class QOpenGLVertexArrayObject(QtCore.QObject):

    class Binder(PyQt6.sip.simplewrapper):

        def __init__(self, v: typing.Optional['QOpenGLVertexArrayObject']) -> None: ...

        def __exit__(self, type: typing.Any, value: typing.Any, traceback: typing.Any) -> None: ...
        def __enter__(self) -> typing.Any: ...
        def rebind(self) -> None: ...
        def release(self) -> None: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def release(self) -> None: ...
    def bind(self) -> None: ...
    def objectId(self) -> int: ...
    def isCreated(self) -> bool: ...
    def destroy(self) -> None: ...
    def create(self) -> bool: ...


class QOpenGLWindow(QtGui.QPaintDeviceWindow):

    class UpdateBehavior(enum.Enum):
        NoPartialUpdate = ... # type: QOpenGLWindow.UpdateBehavior
        PartialUpdateBlit = ... # type: QOpenGLWindow.UpdateBehavior
        PartialUpdateBlend = ... # type: QOpenGLWindow.UpdateBehavior

    @typing.overload
    def __init__(self, updateBehavior: 'QOpenGLWindow.UpdateBehavior' = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...
    @typing.overload
    def __init__(self, shareContext: typing.Optional[QtGui.QOpenGLContext], updateBehavior: 'QOpenGLWindow.UpdateBehavior' = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def resizeEvent(self, event: typing.Optional[QtGui.QResizeEvent]) -> None: ...
    def paintEvent(self, event: typing.Optional[QtGui.QPaintEvent]) -> None: ...
    def paintOverGL(self) -> None: ...
    def paintUnderGL(self) -> None: ...
    def paintGL(self) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def initializeGL(self) -> None: ...
    frameSwapped: typing.ClassVar[QtCore.pyqtSignal]
    def shareContext(self) -> typing.Optional[QtGui.QOpenGLContext]: ...
    def grabFramebuffer(self) -> QtGui.QImage: ...
    def defaultFramebufferObject(self) -> int: ...
    def context(self) -> typing.Optional[QtGui.QOpenGLContext]: ...
    def doneCurrent(self) -> None: ...
    def makeCurrent(self) -> None: ...
    def isValid(self) -> bool: ...
    def updateBehavior(self) -> 'QOpenGLWindow.UpdateBehavior': ...


class QOpenGLFunctions_ES2(QAbstractOpenGLFunctions):

    def __init__(self) -> None: ...

    def glViewport(self, x: int, y: int, width: int, height: int) -> None: ...
    def glVertexAttribPointer(self, indx: int, size: int, type: int, normalized: int, stride: int, ptr: PYQT_OPENGL_BOUND_ARRAY) -> None: ...
    def glVertexAttrib4fv(self, indx: int, values: PYQT_OPENGL_ARRAY) -> None: ...
    def glVertexAttrib4f(self, indx: int, x: float, y: float, z: float, w: float) -> None: ...
    def glVertexAttrib3fv(self, indx: int, values: PYQT_OPENGL_ARRAY) -> None: ...
    def glVertexAttrib3f(self, indx: int, x: float, y: float, z: float) -> None: ...
    def glVertexAttrib2fv(self, indx: int, values: PYQT_OPENGL_ARRAY) -> None: ...
    def glVertexAttrib2f(self, indx: int, x: float, y: float) -> None: ...
    def glVertexAttrib1fv(self, indx: int, values: PYQT_OPENGL_ARRAY) -> None: ...
    def glVertexAttrib1f(self, indx: int, x: float) -> None: ...
    def glValidateProgram(self, program: int) -> None: ...
    def glUseProgram(self, program: int) -> None: ...
    def glUniformMatrix4fv(self, location: int, count: int, transpose: int, value: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniformMatrix3fv(self, location: int, count: int, transpose: int, value: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniformMatrix2fv(self, location: int, count: int, transpose: int, value: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform4iv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform4i(self, location: int, x: int, y: int, z: int, w: int) -> None: ...
    def glUniform4fv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform4f(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    def glUniform3iv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform3i(self, location: int, x: int, y: int, z: int) -> None: ...
    def glUniform3fv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform3f(self, location: int, x: float, y: float, z: float) -> None: ...
    def glUniform2iv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform2i(self, location: int, x: int, y: int) -> None: ...
    def glUniform2fv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform2f(self, location: int, x: float, y: float) -> None: ...
    def glUniform1iv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform1i(self, location: int, x: int) -> None: ...
    def glUniform1fv(self, location: int, count: int, v: PYQT_OPENGL_ARRAY) -> None: ...
    def glUniform1f(self, location: int, x: float) -> None: ...
    def glTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, type: int, pixels: PYQT_OPENGL_ARRAY) -> None: ...
    def glTexParameteriv(self, target: int, pname: int, params: PYQT_OPENGL_ARRAY) -> None: ...
    def glTexParameteri(self, target: int, pname: int, param: int) -> None: ...
    def glTexParameterfv(self, target: int, pname: int, params: PYQT_OPENGL_ARRAY) -> None: ...
    def glTexParameterf(self, target: int, pname: int, param: float) -> None: ...
    def glTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, format: int, type: int, pixels: PYQT_OPENGL_ARRAY) -> None: ...
    def glStencilOpSeparate(self, face: int, fail: int, zfail: int, zpass: int) -> None: ...
    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None: ...
    def glStencilMaskSeparate(self, face: int, mask: int) -> None: ...
    def glStencilMask(self, mask: int) -> None: ...
    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None: ...
    def glStencilFunc(self, func: int, ref: int, mask: int) -> None: ...
    def glScissor(self, x: int, y: int, width: int, height: int) -> None: ...
    def glSampleCoverage(self, value: float, invert: int) -> None: ...
    def glRenderbufferStorage(self, target: int, internalformat: int, width: int, height: int) -> None: ...
    def glReleaseShaderCompiler(self) -> None: ...
    def glReadPixels(self, x: int, y: int, width: int, height: int, format: int, type: int) -> typing.Union[tuple[float, ...], tuple[int, ...]]: ...
    def glPolygonOffset(self, factor: float, units: float) -> None: ...
    def glPixelStorei(self, pname: int, param: int) -> None: ...
    def glLinkProgram(self, program: int) -> None: ...
    def glLineWidth(self, width: float) -> None: ...
    def glIsTexture(self, texture: int) -> int: ...
    def glIsShader(self, shader: int) -> int: ...
    def glIsRenderbuffer(self, renderbuffer: int) -> int: ...
    def glIsProgram(self, program: int) -> int: ...
    def glIsFramebuffer(self, framebuffer: int) -> int: ...
    def glIsEnabled(self, cap: int) -> int: ...
    def glIsBuffer(self, buffer: int) -> int: ...
    def glHint(self, target: int, mode: int) -> None: ...
    def glGetVertexAttribiv(self, index: int, pname: int) -> typing.Optional[typing.Union[int, tuple[int, int, int, int]]]: ...
    def glGetVertexAttribfv(self, index: int, pname: int) -> typing.Optional[typing.Union[float, tuple[float, float, float, float]]]: ...
    def glGetUniformLocation(self, program: int, name: typing.Optional[str]) -> int: ...
    def glGetTexParameteriv(self, target: int, pname: int) -> typing.Optional[typing.Union[int, tuple[int, int, int, int]]]: ...
    def glGetTexParameterfv(self, target: int, pname: int) -> typing.Optional[typing.Union[float, tuple[float, float, float, float]]]: ...
    def glGetString(self, name: int) -> typing.Optional[str]: ...
    def glGetShaderSource(self, shader: int) -> bytes: ...
    def glGetShaderPrecisionFormat(self, shadertype: int, precisiontype: int) -> tuple[tuple[int, int], int]: ...
    def glGetShaderInfoLog(self, shader: int) -> bytes: ...
    def glGetShaderiv(self, shader: int, pname: int) -> typing.Optional[int]: ...
    def glGetRenderbufferParameteriv(self, target: int, pname: int) -> typing.Optional[int]: ...
    def glGetProgramInfoLog(self, program: int) -> bytes: ...
    def glGetProgramiv(self, program: int, pname: int) -> typing.Optional[typing.Union[int, tuple[int, int, int]]]: ...
    def glGetIntegerv(self, pname: int) -> typing.Optional[typing.Union[int, tuple[int, ...]]]: ...
    def glGetFramebufferAttachmentParameteriv(self, target: int, attachment: int, pname: int) -> typing.Optional[int]: ...
    def glGetFloatv(self, pname: int) -> typing.Optional[typing.Union[float, tuple[float, ...]]]: ...
    def glGetError(self) -> int: ...
    def glGetBufferParameteriv(self, target: int, pname: int) -> typing.Optional[int]: ...
    def glGetBooleanv(self, pname: int) -> typing.Optional[typing.Union[bool, tuple[bool, ...]]]: ...
    def glGetAttribLocation(self, program: int, name: typing.Optional[str]) -> int: ...
    def glGetAttachedShaders(self, program: int) -> tuple[int, ...]: ...
    def glGetActiveUniform(self, program: int, index: int) -> tuple[str, int, int]: ...
    def glGetActiveAttrib(self, program: int, index: int) -> tuple[str, int, int]: ...
    def glGenTextures(self, n: int, textures: typing.Union[int, tuple[int, ...]]) -> None: ...
    def glGenRenderbuffers(self, n: int) -> typing.Optional[typing.Union[int, tuple[int, ...]]]: ...
    def glGenFramebuffers(self, n: int, framebuffers: typing.Union[int, tuple[int, ...]]) -> None: ...
    def glGenerateMipmap(self, target: int) -> None: ...
    def glGenBuffers(self, n: int) -> typing.Optional[typing.Union[int, tuple[int, ...]]]: ...
    def glFrontFace(self, mode: int) -> None: ...
    def glFramebufferTexture2D(self, target: int, attachment: int, textarget: int, texture: int, level: int) -> None: ...
    def glFramebufferRenderbuffer(self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int) -> None: ...
    def glFlush(self) -> None: ...
    def glFinish(self) -> None: ...
    def glEnableVertexAttribArray(self, index: int) -> None: ...
    def glEnable(self, cap: int) -> None: ...
    def glDrawElements(self, mode: int, count: int, type: int, indices: PYQT_OPENGL_ARRAY) -> None: ...
    def glDrawArrays(self, mode: int, first: int, count: int) -> None: ...
    def glDisableVertexAttribArray(self, index: int) -> None: ...
    def glDisable(self, cap: int) -> None: ...
    def glDetachShader(self, program: int, shader: int) -> None: ...
    def glDepthRangef(self, zNear: float, zFar: float) -> None: ...
    def glDepthMask(self, flag: int) -> None: ...
    def glDepthFunc(self, func: int) -> None: ...
    def glDeleteTextures(self, n: int, textures: PYQT_OPENGL_ARRAY) -> None: ...
    def glDeleteShader(self, shader: int) -> None: ...
    def glDeleteRenderbuffers(self, n: int, renderbuffers: typing.Any) -> None: ...
    def glDeleteProgram(self, program: int) -> None: ...
    def glDeleteFramebuffers(self, n: int, framebuffers: typing.Any) -> None: ...
    def glDeleteBuffers(self, n: int, buffers: PYQT_OPENGL_ARRAY) -> None: ...
    def glCullFace(self, mode: int) -> None: ...
    def glCreateShader(self, type: int) -> int: ...
    def glCreateProgram(self) -> int: ...
    def glCopyTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, x: int, y: int, width: int, height: int) -> None: ...
    def glCopyTexImage2D(self, target: int, level: int, internalformat: int, x: int, y: int, width: int, height: int, border: int) -> None: ...
    def glCompressedTexSubImage2D(self, target: int, level: int, xoffset: int, yoffset: int, width: int, height: int, format: int, imageSize: int, data: PYQT_OPENGL_ARRAY) -> None: ...
    def glCompressedTexImage2D(self, target: int, level: int, internalformat: int, width: int, height: int, border: int, imageSize: int, data: PYQT_OPENGL_ARRAY) -> None: ...
    def glCompileShader(self, shader: int) -> None: ...
    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None: ...
    def glClearStencil(self, s: int) -> None: ...
    def glClearDepthf(self, depth: float) -> None: ...
    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glClear(self, mask: int) -> None: ...
    def glCheckFramebufferStatus(self, target: int) -> int: ...
    def glBufferSubData(self, target: int, offset: int, size: int, data: PYQT_OPENGL_ARRAY) -> None: ...
    def glBufferData(self, target: int, size: int, data: PYQT_OPENGL_ARRAY, usage: int) -> None: ...
    def glBlendFuncSeparate(self, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int) -> None: ...
    def glBlendFunc(self, sfactor: int, dfactor: int) -> None: ...
    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None: ...
    def glBlendEquation(self, mode: int) -> None: ...
    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None: ...
    def glBindTexture(self, target: int, texture: int) -> None: ...
    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None: ...
    def glBindFramebuffer(self, target: int, framebuffer: int) -> None: ...
    def glBindBuffer(self, target: int, buffer: int) -> None: ...
    def glBindAttribLocation(self, program: int, index: int, name: typing.Optional[str]) -> None: ...
    def glAttachShader(self, program: int, shader: int) -> None: ...
    def glActiveTexture(self, texture: int) -> None: ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLVersionProfile(PyQt6.sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, format: QtGui.QSurfaceFormat) -> None: ...
    @typing.overload
    def __init__(self, other: 'QOpenGLVersionProfile') -> None: ...

    def __eq__(self, other: object): ...
    def __ne__(self, other: object): ...
    def __hash__(self) -> int: ...
    def isValid(self) -> bool: ...
    def isLegacyVersion(self) -> bool: ...
    def hasProfiles(self) -> bool: ...
    def setProfile(self, profile: QtGui.QSurfaceFormat.OpenGLContextProfile) -> None: ...
    def profile(self) -> QtGui.QSurfaceFormat.OpenGLContextProfile: ...
    def setVersion(self, majorVersion: int, minorVersion: int) -> None: ...
    def version(self) -> tuple[int, int]: ...
