# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_uu_coreutils_global_optspecs
	string join \n h/help
end

function __fish_uu_coreutils_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_uu_coreutils_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_uu_coreutils_using_subcommand
	set -l cmd (__fish_uu_coreutils_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "arch" -d 'Display machine architecture'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "base32" -d 'encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  The data are encoded as described for the base32 alphabet in RFC 4648. When decoding, the input may contain newlines in addition to the bytes of the formal base32 alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "base64" -d 'encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  The data are encoded as described for the base64 alphabet in RFC 3548. When decoding, the input may contain newlines in addition to the bytes of the formal base64 alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "basename" -d 'Print NAME with any leading directory components removed If specified, also remove a trailing SUFFIX'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "basenc" -d 'Encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  When decoding, the input may contain newlines in addition to the bytes of the formal alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cat" -d 'Concatenate FILE(s), or standard input, to standard output With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "chgrp" -d 'Change the group of each FILE to GROUP.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "chmod" -d 'Change the mode of each FILE to MODE. With --reference, change the mode of each FILE to that of RFILE.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "chown" -d 'Change file owner and group'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "chroot" -d 'Run COMMAND with root directory set to NEWROOT.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cksum" -d 'Print CRC and size for each file'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "comm" -d 'Compare two sorted files line by line.  When FILE1 or FILE2 (not both) is -, read standard input.  With no options, produce three-column output. Column one contains lines unique to FILE1, column two contains lines unique to FILE2, and column three contains lines common to both files.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cp" -d 'Copy SOURCE to DEST, or multiple SOURCE(s) to DIRECTORY.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "csplit" -d 'Split a file into sections determined by context lines'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "cut" -d 'Prints specified byte or field columns from each line of stdin or the input files'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "date" -d 'Print or set the system date and time'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dd" -d 'Copy, and optionally convert, a file system resource'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "df" -d 'Show information about the file system on which each FILE resides, or all file systems by default.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dir" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dircolors" -d 'Output commands to set the LS_COLORS environment variable.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "dirname" -d 'Strip last component from file name'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "du" -d 'Estimate file space usage'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "echo" -d 'Display a line of text'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "env" -d 'Set each NAME to VALUE in the environment and run COMMAND'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "expand" -d 'Convert tabs in each `FILE` to spaces, writing to standard output. With no `FILE`, or when `FILE` is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "expr" -d 'Print the value of `EXPRESSION` to standard output'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "factor" -d 'Print the prime factors of the given NUMBER(s). If none are specified, read from standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "false" -d 'Returns false, an unsuccessful exit status.  Immediately returns with the exit status `1`. When invoked with one of the recognized options it will try to write the help or version text. Any IO error during this operation is diagnosed, yet the program will also return `1`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "fmt" -d 'Reformat paragraphs from input files (or stdin) to stdout.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "fold" -d 'Writes each file (or standard input if no files are given) to standard output whilst breaking long lines'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "groups" -d 'Print group memberships for each `USERNAME` or, if no `USERNAME` is specified, for the current process (which may differ if the groups data‐base has changed).'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "hashsum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "md5sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha1sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha224sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha384sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha512sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha3sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha3-224sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha3-256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha3-384sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sha3-512sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shake128sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shake256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "b2sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "b3sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "head" -d 'Print the first 10 lines of each `FILE` to standard output. With more than one `FILE`, precede each with a header giving the file name. With no `FILE`, or when `FILE` is `-`, read standard input.  Mandatory arguments to long flags are mandatory for short flags too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "hostid" -d 'Print the numeric identifier (in hexadecimal) for the current host'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "hostname" -d 'Display or set the system\'s host name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "id" -d 'Print user and group information for each specified `USER`, or (when `USER` omitted) for the current user.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "install" -d 'Copy SOURCE to DEST or multiple SOURCE(s) to the existing DIRECTORY, while setting permission modes and owner/group'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "join" -d 'For each pair of input lines with identical join fields, write a line to standard output. The default join field is the first, delimited by blanks.  When `FILE1` or `FILE2` (not both) is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "kill" -d 'Send signal to processes or list information about signals.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "link" -d 'Call the link function to create a link named FILE2 to an existing FILE1.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ln" -d 'Make links between files.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "logname" -d 'Print user\'s login name'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ls" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mkdir" -d 'Create the given DIRECTORY(ies) if they do not exist'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mkfifo" -d 'Create a FIFO with the given name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mknod" -d 'Create the special file NAME of the given TYPE.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mktemp" -d 'Create a temporary file or directory.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "more" -d 'Display the contents of a text file'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "mv" -d 'Move `SOURCE` to `DEST`, or multiple `SOURCE`(s) to `DIRECTORY`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nice" -d 'Run `COMMAND` with an adjusted niceness, which affects process scheduling. With no `COMMAND`, print the current niceness.  Niceness values range from at least -20 (most favorable to the process) to 19 (least favorable to the process).'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nl" -d 'Number lines of files'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nohup" -d 'Run COMMAND ignoring hangup signals.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "nproc" -d 'Print the number of cores available to the current process. If the `OMP_NUM_THREADS` or `OMP_THREAD_LIMIT` environment variables are set, then they will determine the minimum and maximum returned value respectively.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "numfmt" -d 'Convert numbers from/to human-readable strings'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "od" -d 'Dump files in octal and other formats'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "paste" -d 'Write lines consisting of the sequentially corresponding lines from each `FILE`, separated by `TAB`s, to standard output.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pathchk" -d 'Check whether file names are valid or portable'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pinky" -d 'Displays brief user information on Unix-based systems  Warning: When built with musl libc, the `pinky` utility may show incomplete  or missing user information due to musl\'s stub implementation of `utmpx`  functions. This limitation affects the ability to retrieve accurate details  about logged-in users.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pr" -d 'Write content of given file or standard input to standard output with pagination filter'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "printenv" -d 'Display the values of the specified environment VARIABLE(s), or (with no VARIABLE) display name and value pairs for them all.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "printf" -d 'Print output based off of the format string and proceeding arguments.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "ptx" -d 'Produce a permuted index of file contents Output a permuted index, including context, of the words in the input files. Mandatory arguments to long options are mandatory for short options too. With no FILE, or when FILE is -, read standard input. Default is \'-F /\'.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "pwd" -d 'Display the full filename of the current working directory.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "readlink" -d 'Print value of a symbolic link or canonical file name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "realpath" -d 'Print the resolved path'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "rm" -d 'Remove (unlink) the FILE(s)'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "rmdir" -d 'Remove the DIRECTORY(ies), if they are empty.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "seq" -d 'Display numbers from FIRST to LAST, in steps of INCREMENT.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shred" -d 'Overwrite the specified FILE(s) repeatedly, in order to make it harder for even very expensive hardware probing to recover the data.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "shuf" -d 'Shuffle the input by outputting a random permutation of input lines. Each output permutation is equally likely. With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sleep" -d 'Pause for NUMBER seconds.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sort" -d 'Display sorted concatenation of all FILE(s). With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "split" -d 'Create output files containing consecutive or interleaved sections of input'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "stat" -d 'Display file or file system status.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "stdbuf" -d 'Run `COMMAND`, with modified buffering operations for its standard streams.  Mandatory arguments to long options are mandatory for short options too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sum" -d 'Checksum and count the blocks in a file.  With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "sync" -d 'Synchronize cached writes to persistent storage'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tac" -d 'Write each file to standard output, last line first.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tail" -d 'Print the last 10 lines of each FILE to standard output. With more than one FILE, precede each with a header giving the file name. With no FILE, or when FILE is -, read standard input.  Mandatory arguments to long flags are mandatory for short flags too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tee" -d 'Copy standard input to each FILE, and also to standard output.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "timeout" -d 'Start `COMMAND`, and kill it if still running after `DURATION`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "touch" -d 'Update the access and modification times of each `FILE` to the current time.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tr" -d 'Translate or delete characters'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "true" -d 'Returns true, a successful exit status.  Immediately returns with the exit status `0`, except when invoked with one of the recognized options. In those cases it will try to write the help or version text. Any IO error during this operation causes the program to return `1` instead.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "truncate" -d 'Shrink or extend the size of each file to the specified size.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tsort" -d 'Topological sort the strings in FILE. Strings are defined as any sequence of tokens separated by whitespace (tab, space, or newline), ordering them based on dependencies in a directed acyclic graph (DAG).  Useful for scheduling and determining execution order. If FILE is not passed in, stdin is used instead.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "tty" -d 'Print the file name of the terminal connected to standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "uname" -d 'Print certain system information.  With no OPTION, same as -s.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "unexpand" -d 'Convert blanks in each `FILE` to tabs, writing to standard output. With no `FILE`, or when `FILE` is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "uniq" -d 'Report or omit repeated lines.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "unlink" -d 'Unlink the file at `FILE`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "uptime" -d 'Display the current time, the length of time the system has been up, the number of users on the system, and the average number of jobs in the run queue over the last 1, 5 and 15 minutes.  Warning: When built with musl libc, the `uptime` utility may show \'0 users\'  due to musl\'s stub implementation of utmpx functions. Boot time and load averages  are still calculated using alternative mechanisms.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "users" -d 'Print the user names of users currently logged in to the current host.  Warning: When built with musl libc, the `users` utility may show \'0 users\'  due to musl\'s stub implementation of utmpx functions.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "test" -d 'Check file types and compare values.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "[" -d 'Check file types and compare values.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "vdir" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "wc" -d 'Display newline, word, and byte counts for each FILE, and a total line if more than one FILE is specified. With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "who" -d 'Print information about users who are currently logged in.  Note: When built with musl libc, the `who` utility will not display any  information about logged-in users. This is due to musl\'s stub implementation  of `utmpx` functions, which prevents access to the necessary data.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "whoami" -d 'Print the current username.'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "yes" -d 'Repeatedly display a line with STRING (or \'y\')'
complete -c uu-coreutils -n "__fish_uu_coreutils_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand arch" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand base32" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand base64" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand basename" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand basenc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cat" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand chgrp" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand chmod" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand chown" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand chroot" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cksum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand comm" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cp" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand csplit" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand cut" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand date" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dd" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand df" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dircolors" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand dirname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand du" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand echo" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand env" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand expand" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand expr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand factor" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand false" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand fmt" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand fold" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand groups" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand hashsum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand md5sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha1sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha224sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha256sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha384sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha512sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha3sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha3-224sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha3-256sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha3-384sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sha3-512sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shake128sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shake256sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand b2sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand b3sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand head" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand hostid" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand hostname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand id" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand install" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand join" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand kill" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand link" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ln" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand logname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ls" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mkdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mkfifo" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mknod" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mktemp" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand more" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand mv" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nice" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nl" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nohup" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand nproc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand numfmt" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand od" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand paste" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pathchk" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pinky" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand printenv" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand printf" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand ptx" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand pwd" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand readlink" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand realpath" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand rm" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand rmdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand seq" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shred" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand shuf" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sleep" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sort" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand split" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand stat" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand stdbuf" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sum" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand sync" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tac" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tail" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tee" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand timeout" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand touch" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tr" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand true" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand truncate" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tsort" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand tty" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand uname" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand unexpand" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand uniq" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand unlink" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand uptime" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand users" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand test" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand [" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand vdir" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand wc" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand who" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand whoami" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand yes" -s h -l help -d 'Print help'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "arch" -d 'Display machine architecture'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "base32" -d 'encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  The data are encoded as described for the base32 alphabet in RFC 4648. When decoding, the input may contain newlines in addition to the bytes of the formal base32 alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "base64" -d 'encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  The data are encoded as described for the base64 alphabet in RFC 3548. When decoding, the input may contain newlines in addition to the bytes of the formal base64 alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "basename" -d 'Print NAME with any leading directory components removed If specified, also remove a trailing SUFFIX'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "basenc" -d 'Encode/decode data and print to standard output With no FILE, or when FILE is -, read standard input.  When decoding, the input may contain newlines in addition to the bytes of the formal alphabet. Use --ignore-garbage to attempt to recover from any other non-alphabet bytes in the encoded stream.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "cat" -d 'Concatenate FILE(s), or standard input, to standard output With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "chgrp" -d 'Change the group of each FILE to GROUP.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "chmod" -d 'Change the mode of each FILE to MODE. With --reference, change the mode of each FILE to that of RFILE.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "chown" -d 'Change file owner and group'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "chroot" -d 'Run COMMAND with root directory set to NEWROOT.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "cksum" -d 'Print CRC and size for each file'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "comm" -d 'Compare two sorted files line by line.  When FILE1 or FILE2 (not both) is -, read standard input.  With no options, produce three-column output. Column one contains lines unique to FILE1, column two contains lines unique to FILE2, and column three contains lines common to both files.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "cp" -d 'Copy SOURCE to DEST, or multiple SOURCE(s) to DIRECTORY.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "csplit" -d 'Split a file into sections determined by context lines'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "cut" -d 'Prints specified byte or field columns from each line of stdin or the input files'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "date" -d 'Print or set the system date and time'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "dd" -d 'Copy, and optionally convert, a file system resource'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "df" -d 'Show information about the file system on which each FILE resides, or all file systems by default.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "dir" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "dircolors" -d 'Output commands to set the LS_COLORS environment variable.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "dirname" -d 'Strip last component from file name'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "du" -d 'Estimate file space usage'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "echo" -d 'Display a line of text'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "env" -d 'Set each NAME to VALUE in the environment and run COMMAND'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "expand" -d 'Convert tabs in each `FILE` to spaces, writing to standard output. With no `FILE`, or when `FILE` is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "expr" -d 'Print the value of `EXPRESSION` to standard output'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "factor" -d 'Print the prime factors of the given NUMBER(s). If none are specified, read from standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "false" -d 'Returns false, an unsuccessful exit status.  Immediately returns with the exit status `1`. When invoked with one of the recognized options it will try to write the help or version text. Any IO error during this operation is diagnosed, yet the program will also return `1`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "fmt" -d 'Reformat paragraphs from input files (or stdin) to stdout.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "fold" -d 'Writes each file (or standard input if no files are given) to standard output whilst breaking long lines'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "groups" -d 'Print group memberships for each `USERNAME` or, if no `USERNAME` is specified, for the current process (which may differ if the groups data‐base has changed).'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "hashsum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "md5sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha1sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha224sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha384sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha512sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha3sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha3-224sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha3-256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha3-384sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sha3-512sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "shake128sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "shake256sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "b2sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "b3sum" -d 'Compute and check message digests.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "head" -d 'Print the first 10 lines of each `FILE` to standard output. With more than one `FILE`, precede each with a header giving the file name. With no `FILE`, or when `FILE` is `-`, read standard input.  Mandatory arguments to long flags are mandatory for short flags too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "hostid" -d 'Print the numeric identifier (in hexadecimal) for the current host'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "hostname" -d 'Display or set the system\'s host name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "id" -d 'Print user and group information for each specified `USER`, or (when `USER` omitted) for the current user.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "install" -d 'Copy SOURCE to DEST or multiple SOURCE(s) to the existing DIRECTORY, while setting permission modes and owner/group'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "join" -d 'For each pair of input lines with identical join fields, write a line to standard output. The default join field is the first, delimited by blanks.  When `FILE1` or `FILE2` (not both) is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "kill" -d 'Send signal to processes or list information about signals.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "link" -d 'Call the link function to create a link named FILE2 to an existing FILE1.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "ln" -d 'Make links between files.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "logname" -d 'Print user\'s login name'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "ls" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "mkdir" -d 'Create the given DIRECTORY(ies) if they do not exist'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "mkfifo" -d 'Create a FIFO with the given name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "mknod" -d 'Create the special file NAME of the given TYPE.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "mktemp" -d 'Create a temporary file or directory.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "more" -d 'Display the contents of a text file'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "mv" -d 'Move `SOURCE` to `DEST`, or multiple `SOURCE`(s) to `DIRECTORY`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "nice" -d 'Run `COMMAND` with an adjusted niceness, which affects process scheduling. With no `COMMAND`, print the current niceness.  Niceness values range from at least -20 (most favorable to the process) to 19 (least favorable to the process).'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "nl" -d 'Number lines of files'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "nohup" -d 'Run COMMAND ignoring hangup signals.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "nproc" -d 'Print the number of cores available to the current process. If the `OMP_NUM_THREADS` or `OMP_THREAD_LIMIT` environment variables are set, then they will determine the minimum and maximum returned value respectively.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "numfmt" -d 'Convert numbers from/to human-readable strings'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "od" -d 'Dump files in octal and other formats'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "paste" -d 'Write lines consisting of the sequentially corresponding lines from each `FILE`, separated by `TAB`s, to standard output.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "pathchk" -d 'Check whether file names are valid or portable'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "pinky" -d 'Displays brief user information on Unix-based systems  Warning: When built with musl libc, the `pinky` utility may show incomplete  or missing user information due to musl\'s stub implementation of `utmpx`  functions. This limitation affects the ability to retrieve accurate details  about logged-in users.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "pr" -d 'Write content of given file or standard input to standard output with pagination filter'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "printenv" -d 'Display the values of the specified environment VARIABLE(s), or (with no VARIABLE) display name and value pairs for them all.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "printf" -d 'Print output based off of the format string and proceeding arguments.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "ptx" -d 'Produce a permuted index of file contents Output a permuted index, including context, of the words in the input files. Mandatory arguments to long options are mandatory for short options too. With no FILE, or when FILE is -, read standard input. Default is \'-F /\'.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "pwd" -d 'Display the full filename of the current working directory.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "readlink" -d 'Print value of a symbolic link or canonical file name.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "realpath" -d 'Print the resolved path'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "rm" -d 'Remove (unlink) the FILE(s)'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "rmdir" -d 'Remove the DIRECTORY(ies), if they are empty.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "seq" -d 'Display numbers from FIRST to LAST, in steps of INCREMENT.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "shred" -d 'Overwrite the specified FILE(s) repeatedly, in order to make it harder for even very expensive hardware probing to recover the data.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "shuf" -d 'Shuffle the input by outputting a random permutation of input lines. Each output permutation is equally likely. With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sleep" -d 'Pause for NUMBER seconds.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sort" -d 'Display sorted concatenation of all FILE(s). With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "split" -d 'Create output files containing consecutive or interleaved sections of input'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "stat" -d 'Display file or file system status.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "stdbuf" -d 'Run `COMMAND`, with modified buffering operations for its standard streams.  Mandatory arguments to long options are mandatory for short options too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sum" -d 'Checksum and count the blocks in a file.  With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "sync" -d 'Synchronize cached writes to persistent storage'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tac" -d 'Write each file to standard output, last line first.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tail" -d 'Print the last 10 lines of each FILE to standard output. With more than one FILE, precede each with a header giving the file name. With no FILE, or when FILE is -, read standard input.  Mandatory arguments to long flags are mandatory for short flags too.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tee" -d 'Copy standard input to each FILE, and also to standard output.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "timeout" -d 'Start `COMMAND`, and kill it if still running after `DURATION`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "touch" -d 'Update the access and modification times of each `FILE` to the current time.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tr" -d 'Translate or delete characters'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "true" -d 'Returns true, a successful exit status.  Immediately returns with the exit status `0`, except when invoked with one of the recognized options. In those cases it will try to write the help or version text. Any IO error during this operation causes the program to return `1` instead.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "truncate" -d 'Shrink or extend the size of each file to the specified size.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tsort" -d 'Topological sort the strings in FILE. Strings are defined as any sequence of tokens separated by whitespace (tab, space, or newline), ordering them based on dependencies in a directed acyclic graph (DAG).  Useful for scheduling and determining execution order. If FILE is not passed in, stdin is used instead.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "tty" -d 'Print the file name of the terminal connected to standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "uname" -d 'Print certain system information.  With no OPTION, same as -s.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "unexpand" -d 'Convert blanks in each `FILE` to tabs, writing to standard output. With no `FILE`, or when `FILE` is `-`, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "uniq" -d 'Report or omit repeated lines.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "unlink" -d 'Unlink the file at `FILE`.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "uptime" -d 'Display the current time, the length of time the system has been up, the number of users on the system, and the average number of jobs in the run queue over the last 1, 5 and 15 minutes.  Warning: When built with musl libc, the `uptime` utility may show \'0 users\'  due to musl\'s stub implementation of utmpx functions. Boot time and load averages  are still calculated using alternative mechanisms.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "users" -d 'Print the user names of users currently logged in to the current host.  Warning: When built with musl libc, the `users` utility may show \'0 users\'  due to musl\'s stub implementation of utmpx functions.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "test" -d 'Check file types and compare values.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "[" -d 'Check file types and compare values.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "vdir" -d 'List directory contents. Ignore files and directories starting with a \'.\' by default'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "wc" -d 'Display newline, word, and byte counts for each FILE, and a total line if more than one FILE is specified. With no FILE, or when FILE is -, read standard input.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "who" -d 'Print information about users who are currently logged in.  Note: When built with musl libc, the `who` utility will not display any  information about logged-in users. This is due to musl\'s stub implementation  of `utmpx` functions, which prevents access to the necessary data.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "whoami" -d 'Print the current username.'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "yes" -d 'Repeatedly display a line with STRING (or \'y\')'
complete -c uu-coreutils -n "__fish_uu_coreutils_using_subcommand help; and not __fish_seen_subcommand_from arch base32 base64 basename basenc cat chgrp chmod chown chroot cksum comm cp csplit cut date dd df dir dircolors dirname du echo env expand expr factor false fmt fold groups hashsum md5sum sha1sum sha224sum sha256sum sha384sum sha512sum sha3sum sha3-224sum sha3-256sum sha3-384sum sha3-512sum shake128sum shake256sum b2sum b3sum head hostid hostname id install join kill link ln logname ls mkdir mkfifo mknod mktemp more mv nice nl nohup nproc numfmt od paste pathchk pinky pr printenv printf ptx pwd readlink realpath rm rmdir seq shred shuf sleep sort split stat stdbuf sum sync tac tail tee timeout touch tr true truncate tsort tty uname unexpand uniq unlink uptime users test [ vdir wc who whoami yes help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
