/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ktxAstcParams
extends Struct<ktxAstcParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STRUCTSIZE;
    public static final int VERBOSE;
    public static final int THREADCOUNT;
    public static final int BLOCKDIMENSION;
    public static final int MODE;
    public static final int QUALITYLEVEL;
    public static final int NORMALMAP;
    public static final int PERCEPTUAL;
    public static final int INPUTSWIZZLE;

    protected ktxAstcParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxAstcParams create(long address, @Nullable ByteBuffer container) {
        return new ktxAstcParams(address, container);
    }

    public ktxAstcParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxAstcParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ktx_uint32_t")
    public int structSize() {
        return ktxAstcParams.nstructSize(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean verbose() {
        return ktxAstcParams.nverbose(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int threadCount() {
        return ktxAstcParams.nthreadCount(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int blockDimension() {
        return ktxAstcParams.nblockDimension(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int mode() {
        return ktxAstcParams.nmode(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int qualityLevel() {
        return ktxAstcParams.nqualityLevel(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean normalMap() {
        return ktxAstcParams.nnormalMap(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean perceptual() {
        return ktxAstcParams.nperceptual(this.address());
    }

    @NativeType(value="char[4]")
    public ByteBuffer inputSwizzle() {
        return ktxAstcParams.ninputSwizzle(this.address());
    }

    @NativeType(value="char")
    public byte inputSwizzle(int index) {
        return ktxAstcParams.ninputSwizzle(this.address(), index);
    }

    public ktxAstcParams structSize(@NativeType(value="ktx_uint32_t") int value) {
        ktxAstcParams.nstructSize(this.address(), value);
        return this;
    }

    public ktxAstcParams verbose(@NativeType(value="ktx_bool_t") boolean value) {
        ktxAstcParams.nverbose(this.address(), value);
        return this;
    }

    public ktxAstcParams threadCount(@NativeType(value="ktx_uint32_t") int value) {
        ktxAstcParams.nthreadCount(this.address(), value);
        return this;
    }

    public ktxAstcParams blockDimension(@NativeType(value="ktx_uint32_t") int value) {
        ktxAstcParams.nblockDimension(this.address(), value);
        return this;
    }

    public ktxAstcParams mode(@NativeType(value="ktx_uint32_t") int value) {
        ktxAstcParams.nmode(this.address(), value);
        return this;
    }

    public ktxAstcParams qualityLevel(@NativeType(value="ktx_uint32_t") int value) {
        ktxAstcParams.nqualityLevel(this.address(), value);
        return this;
    }

    public ktxAstcParams normalMap(@NativeType(value="ktx_bool_t") boolean value) {
        ktxAstcParams.nnormalMap(this.address(), value);
        return this;
    }

    public ktxAstcParams perceptual(@NativeType(value="ktx_bool_t") boolean value) {
        ktxAstcParams.nperceptual(this.address(), value);
        return this;
    }

    public ktxAstcParams inputSwizzle(@NativeType(value="char[4]") ByteBuffer value) {
        ktxAstcParams.ninputSwizzle(this.address(), value);
        return this;
    }

    public ktxAstcParams inputSwizzle(int index, @NativeType(value="char") byte value) {
        ktxAstcParams.ninputSwizzle(this.address(), index, value);
        return this;
    }

    public ktxAstcParams set(int structSize, boolean verbose, int threadCount, int blockDimension, int mode, int qualityLevel, boolean normalMap, boolean perceptual, ByteBuffer inputSwizzle) {
        this.structSize(structSize);
        this.verbose(verbose);
        this.threadCount(threadCount);
        this.blockDimension(blockDimension);
        this.mode(mode);
        this.qualityLevel(qualityLevel);
        this.normalMap(normalMap);
        this.perceptual(perceptual);
        this.inputSwizzle(inputSwizzle);
        return this;
    }

    public ktxAstcParams set(ktxAstcParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ktxAstcParams malloc() {
        return new ktxAstcParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ktxAstcParams calloc() {
        return new ktxAstcParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ktxAstcParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ktxAstcParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ktxAstcParams create(long address) {
        return new ktxAstcParams(address, null);
    }

    @Nullable
    public static ktxAstcParams createSafe(long address) {
        return address == 0L ? null : new ktxAstcParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ktxAstcParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxAstcParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxAstcParams malloc(MemoryStack stack) {
        return new ktxAstcParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxAstcParams calloc(MemoryStack stack) {
        return new ktxAstcParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstructSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)STRUCTSIZE);
    }

    public static boolean nverbose(long struct) {
        return UNSAFE.getByte(null, struct + (long)VERBOSE) != 0;
    }

    public static int nthreadCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)THREADCOUNT);
    }

    public static int nblockDimension(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKDIMENSION);
    }

    public static int nmode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODE);
    }

    public static int nqualityLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUALITYLEVEL);
    }

    public static boolean nnormalMap(long struct) {
        return UNSAFE.getByte(null, struct + (long)NORMALMAP) != 0;
    }

    public static boolean nperceptual(long struct) {
        return UNSAFE.getByte(null, struct + (long)PERCEPTUAL) != 0;
    }

    public static ByteBuffer ninputSwizzle(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)INPUTSWIZZLE), (int)4);
    }

    public static byte ninputSwizzle(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)INPUTSWIZZLE + Checks.check((int)index, (int)4) * 1L);
    }

    public static void nstructSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STRUCTSIZE, value);
    }

    public static void nverbose(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)VERBOSE, value ? (byte)1 : 0);
    }

    public static void nthreadCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)THREADCOUNT, value);
    }

    public static void nblockDimension(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BLOCKDIMENSION, value);
    }

    public static void nmode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODE, value);
    }

    public static void nqualityLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUALITYLEVEL, value);
    }

    public static void nnormalMap(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)NORMALMAP, value ? (byte)1 : 0);
    }

    public static void nperceptual(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)PERCEPTUAL, value ? (byte)1 : 0);
    }

    public static void ninputSwizzle(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)INPUTSWIZZLE), (long)(value.remaining() * 1));
    }

    public static void ninputSwizzle(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)INPUTSWIZZLE + Checks.check((int)index, (int)4) * 1L, value);
    }

    static {
        Struct.Layout layout = ktxAstcParams.__struct((Struct.Member[])new Struct.Member[]{ktxAstcParams.__member((int)4), ktxAstcParams.__member((int)1), ktxAstcParams.__member((int)4), ktxAstcParams.__member((int)4), ktxAstcParams.__member((int)4), ktxAstcParams.__member((int)4), ktxAstcParams.__member((int)1), ktxAstcParams.__member((int)1), ktxAstcParams.__array((int)1, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STRUCTSIZE = layout.offsetof(0);
        VERBOSE = layout.offsetof(1);
        THREADCOUNT = layout.offsetof(2);
        BLOCKDIMENSION = layout.offsetof(3);
        MODE = layout.offsetof(4);
        QUALITYLEVEL = layout.offsetof(5);
        NORMALMAP = layout.offsetof(6);
        PERCEPTUAL = layout.offsetof(7);
        INPUTSWIZZLE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<ktxAstcParams, Buffer>
    implements NativeResource {
        private static final ktxAstcParams ELEMENT_FACTORY = ktxAstcParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ktxAstcParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ktx_uint32_t")
        public int structSize() {
            return ktxAstcParams.nstructSize(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean verbose() {
            return ktxAstcParams.nverbose(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int threadCount() {
            return ktxAstcParams.nthreadCount(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int blockDimension() {
            return ktxAstcParams.nblockDimension(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int mode() {
            return ktxAstcParams.nmode(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int qualityLevel() {
            return ktxAstcParams.nqualityLevel(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean normalMap() {
            return ktxAstcParams.nnormalMap(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean perceptual() {
            return ktxAstcParams.nperceptual(this.address());
        }

        @NativeType(value="char[4]")
        public ByteBuffer inputSwizzle() {
            return ktxAstcParams.ninputSwizzle(this.address());
        }

        @NativeType(value="char")
        public byte inputSwizzle(int index) {
            return ktxAstcParams.ninputSwizzle(this.address(), index);
        }

        public Buffer structSize(@NativeType(value="ktx_uint32_t") int value) {
            ktxAstcParams.nstructSize(this.address(), value);
            return this;
        }

        public Buffer verbose(@NativeType(value="ktx_bool_t") boolean value) {
            ktxAstcParams.nverbose(this.address(), value);
            return this;
        }

        public Buffer threadCount(@NativeType(value="ktx_uint32_t") int value) {
            ktxAstcParams.nthreadCount(this.address(), value);
            return this;
        }

        public Buffer blockDimension(@NativeType(value="ktx_uint32_t") int value) {
            ktxAstcParams.nblockDimension(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="ktx_uint32_t") int value) {
            ktxAstcParams.nmode(this.address(), value);
            return this;
        }

        public Buffer qualityLevel(@NativeType(value="ktx_uint32_t") int value) {
            ktxAstcParams.nqualityLevel(this.address(), value);
            return this;
        }

        public Buffer normalMap(@NativeType(value="ktx_bool_t") boolean value) {
            ktxAstcParams.nnormalMap(this.address(), value);
            return this;
        }

        public Buffer perceptual(@NativeType(value="ktx_bool_t") boolean value) {
            ktxAstcParams.nperceptual(this.address(), value);
            return this;
        }

        public Buffer inputSwizzle(@NativeType(value="char[4]") ByteBuffer value) {
            ktxAstcParams.ninputSwizzle(this.address(), value);
            return this;
        }

        public Buffer inputSwizzle(int index, @NativeType(value="char") byte value) {
            ktxAstcParams.ninputSwizzle(this.address(), index, value);
            return this;
        }
    }
}

