/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ktxTextureCreateInfo
extends Struct<ktxTextureCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GLINTERNALFORMAT;
    public static final int VKFORMAT;
    public static final int PDFD;
    public static final int BASEWIDTH;
    public static final int BASEHEIGHT;
    public static final int BASEDEPTH;
    public static final int NUMDIMENSIONS;
    public static final int NUMLEVELS;
    public static final int NUMLAYERS;
    public static final int NUMFACES;
    public static final int ISARRAY;
    public static final int GENERATEMIPMAPS;

    protected ktxTextureCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxTextureCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new ktxTextureCreateInfo(address, container);
    }

    public ktxTextureCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxTextureCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ktx_uint32_t")
    public int glInternalformat() {
        return ktxTextureCreateInfo.nglInternalformat(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int vkFormat() {
        return ktxTextureCreateInfo.nvkFormat(this.address());
    }

    @Nullable
    @NativeType(value="ktx_uint32_t *")
    public IntBuffer pDfd(int capacity) {
        return ktxTextureCreateInfo.npDfd(this.address(), capacity);
    }

    @NativeType(value="ktx_uint32_t")
    public int baseWidth() {
        return ktxTextureCreateInfo.nbaseWidth(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int baseHeight() {
        return ktxTextureCreateInfo.nbaseHeight(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int baseDepth() {
        return ktxTextureCreateInfo.nbaseDepth(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int numDimensions() {
        return ktxTextureCreateInfo.nnumDimensions(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int numLevels() {
        return ktxTextureCreateInfo.nnumLevels(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int numLayers() {
        return ktxTextureCreateInfo.nnumLayers(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int numFaces() {
        return ktxTextureCreateInfo.nnumFaces(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean isArray() {
        return ktxTextureCreateInfo.nisArray(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean generateMipmaps() {
        return ktxTextureCreateInfo.ngenerateMipmaps(this.address());
    }

    public ktxTextureCreateInfo glInternalformat(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nglInternalformat(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo vkFormat(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nvkFormat(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo pDfd(@Nullable @NativeType(value="ktx_uint32_t *") IntBuffer value) {
        ktxTextureCreateInfo.npDfd(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo baseWidth(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nbaseWidth(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo baseHeight(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nbaseHeight(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo baseDepth(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nbaseDepth(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo numDimensions(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nnumDimensions(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo numLevels(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nnumLevels(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo numLayers(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nnumLayers(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo numFaces(@NativeType(value="ktx_uint32_t") int value) {
        ktxTextureCreateInfo.nnumFaces(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo isArray(@NativeType(value="ktx_bool_t") boolean value) {
        ktxTextureCreateInfo.nisArray(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo generateMipmaps(@NativeType(value="ktx_bool_t") boolean value) {
        ktxTextureCreateInfo.ngenerateMipmaps(this.address(), value);
        return this;
    }

    public ktxTextureCreateInfo set(int glInternalformat, int vkFormat, @Nullable IntBuffer pDfd, int baseWidth, int baseHeight, int baseDepth, int numDimensions, int numLevels, int numLayers, int numFaces, boolean isArray, boolean generateMipmaps) {
        this.glInternalformat(glInternalformat);
        this.vkFormat(vkFormat);
        this.pDfd(pDfd);
        this.baseWidth(baseWidth);
        this.baseHeight(baseHeight);
        this.baseDepth(baseDepth);
        this.numDimensions(numDimensions);
        this.numLevels(numLevels);
        this.numLayers(numLayers);
        this.numFaces(numFaces);
        this.isArray(isArray);
        this.generateMipmaps(generateMipmaps);
        return this;
    }

    public ktxTextureCreateInfo set(ktxTextureCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ktxTextureCreateInfo malloc() {
        return new ktxTextureCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ktxTextureCreateInfo calloc() {
        return new ktxTextureCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ktxTextureCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ktxTextureCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ktxTextureCreateInfo create(long address) {
        return new ktxTextureCreateInfo(address, null);
    }

    @Nullable
    public static ktxTextureCreateInfo createSafe(long address) {
        return address == 0L ? null : new ktxTextureCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ktxTextureCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxTextureCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxTextureCreateInfo malloc(MemoryStack stack) {
        return new ktxTextureCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxTextureCreateInfo calloc(MemoryStack stack) {
        return new ktxTextureCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nglInternalformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)GLINTERNALFORMAT);
    }

    public static int nvkFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)VKFORMAT);
    }

    @Nullable
    public static IntBuffer npDfd(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PDFD)), (int)capacity);
    }

    public static int nbaseWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEWIDTH);
    }

    public static int nbaseHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEHEIGHT);
    }

    public static int nbaseDepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEDEPTH);
    }

    public static int nnumDimensions(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMDIMENSIONS);
    }

    public static int nnumLevels(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMLEVELS);
    }

    public static int nnumLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMLAYERS);
    }

    public static int nnumFaces(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMFACES);
    }

    public static boolean nisArray(long struct) {
        return UNSAFE.getByte(null, struct + (long)ISARRAY) != 0;
    }

    public static boolean ngenerateMipmaps(long struct) {
        return UNSAFE.getByte(null, struct + (long)GENERATEMIPMAPS) != 0;
    }

    public static void nglInternalformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GLINTERNALFORMAT, value);
    }

    public static void nvkFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VKFORMAT, value);
    }

    public static void npDfd(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDFD), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    public static void nbaseWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEWIDTH, value);
    }

    public static void nbaseHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEHEIGHT, value);
    }

    public static void nbaseDepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEDEPTH, value);
    }

    public static void nnumDimensions(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMDIMENSIONS, value);
    }

    public static void nnumLevels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMLEVELS, value);
    }

    public static void nnumLayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMLAYERS, value);
    }

    public static void nnumFaces(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUMFACES, value);
    }

    public static void nisArray(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)ISARRAY, value ? (byte)1 : 0);
    }

    public static void ngenerateMipmaps(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)GENERATEMIPMAPS, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = ktxTextureCreateInfo.__struct((Struct.Member[])new Struct.Member[]{ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)POINTER_SIZE), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)4), ktxTextureCreateInfo.__member((int)1), ktxTextureCreateInfo.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GLINTERNALFORMAT = layout.offsetof(0);
        VKFORMAT = layout.offsetof(1);
        PDFD = layout.offsetof(2);
        BASEWIDTH = layout.offsetof(3);
        BASEHEIGHT = layout.offsetof(4);
        BASEDEPTH = layout.offsetof(5);
        NUMDIMENSIONS = layout.offsetof(6);
        NUMLEVELS = layout.offsetof(7);
        NUMLAYERS = layout.offsetof(8);
        NUMFACES = layout.offsetof(9);
        ISARRAY = layout.offsetof(10);
        GENERATEMIPMAPS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<ktxTextureCreateInfo, Buffer>
    implements NativeResource {
        private static final ktxTextureCreateInfo ELEMENT_FACTORY = ktxTextureCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ktxTextureCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ktx_uint32_t")
        public int glInternalformat() {
            return ktxTextureCreateInfo.nglInternalformat(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int vkFormat() {
            return ktxTextureCreateInfo.nvkFormat(this.address());
        }

        @Nullable
        @NativeType(value="ktx_uint32_t *")
        public IntBuffer pDfd(int capacity) {
            return ktxTextureCreateInfo.npDfd(this.address(), capacity);
        }

        @NativeType(value="ktx_uint32_t")
        public int baseWidth() {
            return ktxTextureCreateInfo.nbaseWidth(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int baseHeight() {
            return ktxTextureCreateInfo.nbaseHeight(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int baseDepth() {
            return ktxTextureCreateInfo.nbaseDepth(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int numDimensions() {
            return ktxTextureCreateInfo.nnumDimensions(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int numLevels() {
            return ktxTextureCreateInfo.nnumLevels(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int numLayers() {
            return ktxTextureCreateInfo.nnumLayers(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int numFaces() {
            return ktxTextureCreateInfo.nnumFaces(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean isArray() {
            return ktxTextureCreateInfo.nisArray(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean generateMipmaps() {
            return ktxTextureCreateInfo.ngenerateMipmaps(this.address());
        }

        public Buffer glInternalformat(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nglInternalformat(this.address(), value);
            return this;
        }

        public Buffer vkFormat(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nvkFormat(this.address(), value);
            return this;
        }

        public Buffer pDfd(@Nullable @NativeType(value="ktx_uint32_t *") IntBuffer value) {
            ktxTextureCreateInfo.npDfd(this.address(), value);
            return this;
        }

        public Buffer baseWidth(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nbaseWidth(this.address(), value);
            return this;
        }

        public Buffer baseHeight(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nbaseHeight(this.address(), value);
            return this;
        }

        public Buffer baseDepth(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nbaseDepth(this.address(), value);
            return this;
        }

        public Buffer numDimensions(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nnumDimensions(this.address(), value);
            return this;
        }

        public Buffer numLevels(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nnumLevels(this.address(), value);
            return this;
        }

        public Buffer numLayers(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nnumLayers(this.address(), value);
            return this;
        }

        public Buffer numFaces(@NativeType(value="ktx_uint32_t") int value) {
            ktxTextureCreateInfo.nnumFaces(this.address(), value);
            return this;
        }

        public Buffer isArray(@NativeType(value="ktx_bool_t") boolean value) {
            ktxTextureCreateInfo.nisArray(this.address(), value);
            return this;
        }

        public Buffer generateMipmaps(@NativeType(value="ktx_bool_t") boolean value) {
            ktxTextureCreateInfo.ngenerateMipmaps(this.address(), value);
            return this;
        }
    }
}

