/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAnimMesh")
public class AIAnimMesh
extends Struct<AIAnimMesh>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MVERTICES;
    public static final int MNORMALS;
    public static final int MTANGENTS;
    public static final int MBITANGENTS;
    public static final int MCOLORS;
    public static final int MTEXTURECOORDS;
    public static final int MNUMVERTICES;
    public static final int MWEIGHT;

    protected AIAnimMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIAnimMesh create(long address, @Nullable ByteBuffer container) {
        return new AIAnimMesh(address, container);
    }

    public AIAnimMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIAnimMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIAnimMesh.nmName(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mVertices() {
        return AIAnimMesh.nmVertices(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mNormals() {
        return AIAnimMesh.nmNormals(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mTangents() {
        return AIAnimMesh.nmTangents(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mBitangents() {
        return AIAnimMesh.nmBitangents(this.address());
    }

    @NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]")
    public PointerBuffer mColors() {
        return AIAnimMesh.nmColors(this.address());
    }

    @Nullable
    @NativeType(value="struct aiColor4D *")
    public AIColor4D.Buffer mColors(int index) {
        return AIAnimMesh.nmColors(this.address(), index);
    }

    @NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]")
    public PointerBuffer mTextureCoords() {
        return AIAnimMesh.nmTextureCoords(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVector3D *")
    public AIVector3D.Buffer mTextureCoords(int index) {
        return AIAnimMesh.nmTextureCoords(this.address(), index);
    }

    @NativeType(value="unsigned int")
    public int mNumVertices() {
        return AIAnimMesh.nmNumVertices(this.address());
    }

    public float mWeight() {
        return AIAnimMesh.nmWeight(this.address());
    }

    public AIAnimMesh mName(@NativeType(value="struct aiString") AIString value) {
        AIAnimMesh.nmName(this.address(), value);
        return this;
    }

    public AIAnimMesh mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIAnimMesh mVertices(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh mNormals(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmNormals(this.address(), value);
        return this;
    }

    public AIAnimMesh mTangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmTangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mBitangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmBitangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(@NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
        AIAnimMesh.nmColors(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(int index, @Nullable @NativeType(value="struct aiColor4D *") AIColor4D.Buffer value) {
        AIAnimMesh.nmColors(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mColors(int index, Consumer<AIColor4D.Buffer> consumer) {
        consumer.accept(this.mColors(index));
        return this;
    }

    public AIAnimMesh mTextureCoords(@NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), value);
        return this;
    }

    public AIAnimMesh mTextureCoords(int index, @Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mTextureCoords(int index, Consumer<AIVector3D.Buffer> consumer) {
        consumer.accept(this.mTextureCoords(index));
        return this;
    }

    public AIAnimMesh mNumVertices(@NativeType(value="unsigned int") int value) {
        AIAnimMesh.nmNumVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh mWeight(float value) {
        AIAnimMesh.nmWeight(this.address(), value);
        return this;
    }

    public AIAnimMesh set(AIString mName, @Nullable AIVector3D.Buffer mVertices, @Nullable AIVector3D.Buffer mNormals, @Nullable AIVector3D.Buffer mTangents, @Nullable AIVector3D.Buffer mBitangents, PointerBuffer mColors, PointerBuffer mTextureCoords, int mNumVertices, float mWeight) {
        this.mName(mName);
        this.mVertices(mVertices);
        this.mNormals(mNormals);
        this.mTangents(mTangents);
        this.mBitangents(mBitangents);
        this.mColors(mColors);
        this.mTextureCoords(mTextureCoords);
        this.mNumVertices(mNumVertices);
        this.mWeight(mWeight);
        return this;
    }

    public AIAnimMesh set(AIAnimMesh src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIAnimMesh malloc() {
        return new AIAnimMesh(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIAnimMesh calloc() {
        return new AIAnimMesh(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIAnimMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIAnimMesh(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIAnimMesh create(long address) {
        return new AIAnimMesh(address, null);
    }

    @Nullable
    public static AIAnimMesh createSafe(long address) {
        return address == 0L ? null : new AIAnimMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIAnimMesh.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIAnimMesh.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIAnimMesh mallocStack() {
        return AIAnimMesh.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimMesh callocStack() {
        return AIAnimMesh.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimMesh mallocStack(MemoryStack stack) {
        return AIAnimMesh.malloc(stack);
    }

    @Deprecated
    public static AIAnimMesh callocStack(MemoryStack stack) {
        return AIAnimMesh.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIAnimMesh.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIAnimMesh.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.calloc(capacity, stack);
    }

    public static AIAnimMesh malloc(MemoryStack stack) {
        return new AIAnimMesh(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIAnimMesh calloc(MemoryStack stack) {
        return new AIAnimMesh(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    @Nullable
    public static AIVector3D.Buffer nmVertices(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MVERTICES)), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmNormals(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MNORMALS)), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmTangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MTANGENTS)), AIAnimMesh.nmNumVertices(struct));
    }

    @Nullable
    public static AIVector3D.Buffer nmBitangents(long struct) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MBITANGENTS)), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmColors(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)MCOLORS), (int)8);
    }

    @Nullable
    public static AIColor4D.Buffer nmColors(long struct, int index) {
        return AIColor4D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MCOLORS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE)), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmTextureCoords(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)MTEXTURECOORDS), (int)8);
    }

    @Nullable
    public static AIVector3D.Buffer nmTextureCoords(long struct, int index) {
        return AIVector3D.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MTEXTURECOORDS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE)), AIAnimMesh.nmNumVertices(struct));
    }

    public static int nmNumVertices(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMVERTICES);
    }

    public static float nmWeight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MWEIGHT);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmVertices(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MVERTICES), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNormals(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MNORMALS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmTangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTANGENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmBitangents(long struct, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MBITANGENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmColors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)MCOLORS), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nmColors(long struct, int index, @Nullable AIColor4D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MCOLORS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmTextureCoords(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)MTEXTURECOORDS), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nmTextureCoords(long struct, int index, @Nullable AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTEXTURECOORDS + Checks.check((int)index, (int)8) * (long)POINTER_SIZE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNumVertices(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMVERTICES, value);
    }

    public static void nmWeight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MWEIGHT, value);
    }

    static {
        Struct.Layout layout = AIAnimMesh.__struct((Struct.Member[])new Struct.Member[]{AIAnimMesh.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIAnimMesh.__member((int)POINTER_SIZE), AIAnimMesh.__member((int)POINTER_SIZE), AIAnimMesh.__member((int)POINTER_SIZE), AIAnimMesh.__member((int)POINTER_SIZE), AIAnimMesh.__array((int)POINTER_SIZE, (int)8), AIAnimMesh.__array((int)POINTER_SIZE, (int)8), AIAnimMesh.__member((int)4), AIAnimMesh.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MVERTICES = layout.offsetof(1);
        MNORMALS = layout.offsetof(2);
        MTANGENTS = layout.offsetof(3);
        MBITANGENTS = layout.offsetof(4);
        MCOLORS = layout.offsetof(5);
        MTEXTURECOORDS = layout.offsetof(6);
        MNUMVERTICES = layout.offsetof(7);
        MWEIGHT = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AIAnimMesh, Buffer>
    implements NativeResource {
        private static final AIAnimMesh ELEMENT_FACTORY = AIAnimMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIAnimMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIAnimMesh.nmName(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mVertices() {
            return AIAnimMesh.nmVertices(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mNormals() {
            return AIAnimMesh.nmNormals(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mTangents() {
            return AIAnimMesh.nmTangents(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mBitangents() {
            return AIAnimMesh.nmBitangents(this.address());
        }

        @NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]")
        public PointerBuffer mColors() {
            return AIAnimMesh.nmColors(this.address());
        }

        @Nullable
        @NativeType(value="struct aiColor4D *")
        public AIColor4D.Buffer mColors(int index) {
            return AIAnimMesh.nmColors(this.address(), index);
        }

        @NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]")
        public PointerBuffer mTextureCoords() {
            return AIAnimMesh.nmTextureCoords(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVector3D *")
        public AIVector3D.Buffer mTextureCoords(int index) {
            return AIAnimMesh.nmTextureCoords(this.address(), index);
        }

        @NativeType(value="unsigned int")
        public int mNumVertices() {
            return AIAnimMesh.nmNumVertices(this.address());
        }

        public float mWeight() {
            return AIAnimMesh.nmWeight(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIAnimMesh.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mVertices(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmVertices(this.address(), value);
            return this;
        }

        public Buffer mNormals(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmNormals(this.address(), value);
            return this;
        }

        public Buffer mTangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmTangents(this.address(), value);
            return this;
        }

        public Buffer mBitangents(@Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmBitangents(this.address(), value);
            return this;
        }

        public Buffer mColors(@NativeType(value="struct aiColor4D *[Assimp.AI_MAX_NUMBER_OF_COLOR_SETS]") PointerBuffer value) {
            AIAnimMesh.nmColors(this.address(), value);
            return this;
        }

        public Buffer mColors(int index, @Nullable @NativeType(value="struct aiColor4D *") AIColor4D.Buffer value) {
            AIAnimMesh.nmColors(this.address(), index, value);
            return this;
        }

        public Buffer mColors(int index, Consumer<AIColor4D.Buffer> consumer) {
            consumer.accept(this.mColors(index));
            return this;
        }

        public Buffer mTextureCoords(@NativeType(value="struct aiVector3D *[Assimp.AI_MAX_NUMBER_OF_TEXTURECOORDS]") PointerBuffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), value);
            return this;
        }

        public Buffer mTextureCoords(int index, @Nullable @NativeType(value="struct aiVector3D *") AIVector3D.Buffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), index, value);
            return this;
        }

        public Buffer mTextureCoords(int index, Consumer<AIVector3D.Buffer> consumer) {
            consumer.accept(this.mTextureCoords(index));
            return this;
        }

        public Buffer mNumVertices(@NativeType(value="unsigned int") int value) {
            AIAnimMesh.nmNumVertices(this.address(), value);
            return this;
        }

        public Buffer mWeight(float value) {
            AIAnimMesh.nmWeight(this.address(), value);
            return this;
        }
    }
}

