/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiCamera")
public class AICamera
extends Struct<AICamera>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MPOSITION;
    public static final int MUP;
    public static final int MLOOKAT;
    public static final int MHORIZONTALFOV;
    public static final int MCLIPPLANENEAR;
    public static final int MCLIPPLANEFAR;
    public static final int MASPECT;
    public static final int MORTHOGRAPHICWIDTH;

    protected AICamera(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AICamera create(long address, @Nullable ByteBuffer container) {
        return new AICamera(address, container);
    }

    public AICamera(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AICamera.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AICamera.nmName(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mPosition() {
        return AICamera.nmPosition(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mUp() {
        return AICamera.nmUp(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mLookAt() {
        return AICamera.nmLookAt(this.address());
    }

    public float mHorizontalFOV() {
        return AICamera.nmHorizontalFOV(this.address());
    }

    public float mClipPlaneNear() {
        return AICamera.nmClipPlaneNear(this.address());
    }

    public float mClipPlaneFar() {
        return AICamera.nmClipPlaneFar(this.address());
    }

    public float mAspect() {
        return AICamera.nmAspect(this.address());
    }

    public float mOrthographicWidth() {
        return AICamera.nmOrthographicWidth(this.address());
    }

    public AICamera mName(@NativeType(value="struct aiString") AIString value) {
        AICamera.nmName(this.address(), value);
        return this;
    }

    public AICamera mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AICamera mPosition(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmPosition(this.address(), value);
        return this;
    }

    public AICamera mPosition(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mPosition());
        return this;
    }

    public AICamera mUp(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmUp(this.address(), value);
        return this;
    }

    public AICamera mUp(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mUp());
        return this;
    }

    public AICamera mLookAt(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AICamera.nmLookAt(this.address(), value);
        return this;
    }

    public AICamera mLookAt(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mLookAt());
        return this;
    }

    public AICamera mHorizontalFOV(float value) {
        AICamera.nmHorizontalFOV(this.address(), value);
        return this;
    }

    public AICamera mClipPlaneNear(float value) {
        AICamera.nmClipPlaneNear(this.address(), value);
        return this;
    }

    public AICamera mClipPlaneFar(float value) {
        AICamera.nmClipPlaneFar(this.address(), value);
        return this;
    }

    public AICamera mAspect(float value) {
        AICamera.nmAspect(this.address(), value);
        return this;
    }

    public AICamera mOrthographicWidth(float value) {
        AICamera.nmOrthographicWidth(this.address(), value);
        return this;
    }

    public AICamera set(AIString mName, AIVector3D mPosition, AIVector3D mUp, AIVector3D mLookAt, float mHorizontalFOV, float mClipPlaneNear, float mClipPlaneFar, float mAspect, float mOrthographicWidth) {
        this.mName(mName);
        this.mPosition(mPosition);
        this.mUp(mUp);
        this.mLookAt(mLookAt);
        this.mHorizontalFOV(mHorizontalFOV);
        this.mClipPlaneNear(mClipPlaneNear);
        this.mClipPlaneFar(mClipPlaneFar);
        this.mAspect(mAspect);
        this.mOrthographicWidth(mOrthographicWidth);
        return this;
    }

    public AICamera set(AICamera src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AICamera malloc() {
        return new AICamera(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AICamera calloc() {
        return new AICamera(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AICamera create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AICamera(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AICamera create(long address) {
        return new AICamera(address, null);
    }

    @Nullable
    public static AICamera createSafe(long address) {
        return address == 0L ? null : new AICamera(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AICamera.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AICamera.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AICamera mallocStack() {
        return AICamera.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AICamera callocStack() {
        return AICamera.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AICamera mallocStack(MemoryStack stack) {
        return AICamera.malloc(stack);
    }

    @Deprecated
    public static AICamera callocStack(MemoryStack stack) {
        return AICamera.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AICamera.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AICamera.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AICamera.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AICamera.calloc(capacity, stack);
    }

    public static AICamera malloc(MemoryStack stack) {
        return new AICamera(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AICamera calloc(MemoryStack stack) {
        return new AICamera(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static AIVector3D nmPosition(long struct) {
        return AIVector3D.create(struct + (long)MPOSITION);
    }

    public static AIVector3D nmUp(long struct) {
        return AIVector3D.create(struct + (long)MUP);
    }

    public static AIVector3D nmLookAt(long struct) {
        return AIVector3D.create(struct + (long)MLOOKAT);
    }

    public static float nmHorizontalFOV(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MHORIZONTALFOV);
    }

    public static float nmClipPlaneNear(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MCLIPPLANENEAR);
    }

    public static float nmClipPlaneFar(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MCLIPPLANEFAR);
    }

    public static float nmAspect(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MASPECT);
    }

    public static float nmOrthographicWidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MORTHOGRAPHICWIDTH);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmPosition(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MPOSITION), (long)AIVector3D.SIZEOF);
    }

    public static void nmUp(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MUP), (long)AIVector3D.SIZEOF);
    }

    public static void nmLookAt(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MLOOKAT), (long)AIVector3D.SIZEOF);
    }

    public static void nmHorizontalFOV(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MHORIZONTALFOV, value);
    }

    public static void nmClipPlaneNear(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MCLIPPLANENEAR, value);
    }

    public static void nmClipPlaneFar(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MCLIPPLANEFAR, value);
    }

    public static void nmAspect(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MASPECT, value);
    }

    public static void nmOrthographicWidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MORTHOGRAPHICWIDTH, value);
    }

    static {
        Struct.Layout layout = AICamera.__struct((Struct.Member[])new Struct.Member[]{AICamera.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AICamera.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AICamera.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AICamera.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AICamera.__member((int)4), AICamera.__member((int)4), AICamera.__member((int)4), AICamera.__member((int)4), AICamera.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MPOSITION = layout.offsetof(1);
        MUP = layout.offsetof(2);
        MLOOKAT = layout.offsetof(3);
        MHORIZONTALFOV = layout.offsetof(4);
        MCLIPPLANENEAR = layout.offsetof(5);
        MCLIPPLANEFAR = layout.offsetof(6);
        MASPECT = layout.offsetof(7);
        MORTHOGRAPHICWIDTH = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AICamera, Buffer>
    implements NativeResource {
        private static final AICamera ELEMENT_FACTORY = AICamera.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AICamera getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AICamera.nmName(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mPosition() {
            return AICamera.nmPosition(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mUp() {
            return AICamera.nmUp(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mLookAt() {
            return AICamera.nmLookAt(this.address());
        }

        public float mHorizontalFOV() {
            return AICamera.nmHorizontalFOV(this.address());
        }

        public float mClipPlaneNear() {
            return AICamera.nmClipPlaneNear(this.address());
        }

        public float mClipPlaneFar() {
            return AICamera.nmClipPlaneFar(this.address());
        }

        public float mAspect() {
            return AICamera.nmAspect(this.address());
        }

        public float mOrthographicWidth() {
            return AICamera.nmOrthographicWidth(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AICamera.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mPosition(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmPosition(this.address(), value);
            return this;
        }

        public Buffer mPosition(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mPosition());
            return this;
        }

        public Buffer mUp(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmUp(this.address(), value);
            return this;
        }

        public Buffer mUp(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mUp());
            return this;
        }

        public Buffer mLookAt(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AICamera.nmLookAt(this.address(), value);
            return this;
        }

        public Buffer mLookAt(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mLookAt());
            return this;
        }

        public Buffer mHorizontalFOV(float value) {
            AICamera.nmHorizontalFOV(this.address(), value);
            return this;
        }

        public Buffer mClipPlaneNear(float value) {
            AICamera.nmClipPlaneNear(this.address(), value);
            return this;
        }

        public Buffer mClipPlaneFar(float value) {
            AICamera.nmClipPlaneFar(this.address(), value);
            return this;
        }

        public Buffer mAspect(float value) {
            AICamera.nmAspect(this.address(), value);
            return this;
        }

        public Buffer mOrthographicWidth(float value) {
            AICamera.nmOrthographicWidth(this.address(), value);
            return this;
        }
    }
}

