/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiColor4D")
public class AIColor4D
extends Struct<AIColor4D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected AIColor4D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIColor4D create(long address, @Nullable ByteBuffer container) {
        return new AIColor4D(address, container);
    }

    public AIColor4D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIColor4D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return AIColor4D.nr(this.address());
    }

    public float g() {
        return AIColor4D.ng(this.address());
    }

    public float b() {
        return AIColor4D.nb(this.address());
    }

    public float a() {
        return AIColor4D.na(this.address());
    }

    public AIColor4D r(float value) {
        AIColor4D.nr(this.address(), value);
        return this;
    }

    public AIColor4D g(float value) {
        AIColor4D.ng(this.address(), value);
        return this;
    }

    public AIColor4D b(float value) {
        AIColor4D.nb(this.address(), value);
        return this;
    }

    public AIColor4D a(float value) {
        AIColor4D.na(this.address(), value);
        return this;
    }

    public AIColor4D set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public AIColor4D set(AIColor4D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIColor4D malloc() {
        return new AIColor4D(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIColor4D calloc() {
        return new AIColor4D(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIColor4D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIColor4D(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIColor4D create(long address) {
        return new AIColor4D(address, null);
    }

    @Nullable
    public static AIColor4D createSafe(long address) {
        return address == 0L ? null : new AIColor4D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIColor4D.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIColor4D.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIColor4D mallocStack() {
        return AIColor4D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIColor4D callocStack() {
        return AIColor4D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIColor4D mallocStack(MemoryStack stack) {
        return AIColor4D.malloc(stack);
    }

    @Deprecated
    public static AIColor4D callocStack(MemoryStack stack) {
        return AIColor4D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIColor4D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIColor4D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIColor4D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIColor4D.calloc(capacity, stack);
    }

    public static AIColor4D malloc(MemoryStack stack) {
        return new AIColor4D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIColor4D calloc(MemoryStack stack) {
        return new AIColor4D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = AIColor4D.__struct((Struct.Member[])new Struct.Member[]{AIColor4D.__member((int)4), AIColor4D.__member((int)4), AIColor4D.__member((int)4), AIColor4D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIColor4D, Buffer>
    implements NativeResource {
        private static final AIColor4D ELEMENT_FACTORY = AIColor4D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIColor4D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return AIColor4D.nr(this.address());
        }

        public float g() {
            return AIColor4D.ng(this.address());
        }

        public float b() {
            return AIColor4D.nb(this.address());
        }

        public float a() {
            return AIColor4D.na(this.address());
        }

        public Buffer r(float value) {
            AIColor4D.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            AIColor4D.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            AIColor4D.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            AIColor4D.na(this.address(), value);
            return this;
        }
    }
}

