/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMaterialProperty")
public class AIMaterialProperty
extends Struct<AIMaterialProperty> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MKEY;
    public static final int MSEMANTIC;
    public static final int MINDEX;
    public static final int MDATALENGTH;
    public static final int MTYPE;
    public static final int MDATA;

    protected AIMaterialProperty(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIMaterialProperty create(long address, @Nullable ByteBuffer container) {
        return new AIMaterialProperty(address, container);
    }

    public AIMaterialProperty(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMaterialProperty.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mKey() {
        return AIMaterialProperty.nmKey(this.address());
    }

    @NativeType(value="unsigned int")
    public int mSemantic() {
        return AIMaterialProperty.nmSemantic(this.address());
    }

    @NativeType(value="unsigned int")
    public int mIndex() {
        return AIMaterialProperty.nmIndex(this.address());
    }

    @NativeType(value="unsigned int")
    public int mDataLength() {
        return AIMaterialProperty.nmDataLength(this.address());
    }

    @NativeType(value="aiPropertyTypeInfo")
    public int mType() {
        return AIMaterialProperty.nmType(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer mData() {
        return AIMaterialProperty.nmData(this.address());
    }

    public static AIMaterialProperty create(long address) {
        return new AIMaterialProperty(address, null);
    }

    @Nullable
    public static AIMaterialProperty createSafe(long address) {
        return address == 0L ? null : new AIMaterialProperty(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static AIString nmKey(long struct) {
        return AIString.create(struct + (long)MKEY);
    }

    public static int nmSemantic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSEMANTIC);
    }

    public static int nmIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINDEX);
    }

    public static int nmDataLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MDATALENGTH);
    }

    public static int nmType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MDATA)), (int)AIMaterialProperty.nmDataLength(struct));
    }

    static {
        Struct.Layout layout = AIMaterialProperty.__struct((Struct.Member[])new Struct.Member[]{AIMaterialProperty.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIMaterialProperty.__member((int)4), AIMaterialProperty.__member((int)4), AIMaterialProperty.__member((int)4), AIMaterialProperty.__member((int)4), AIMaterialProperty.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MKEY = layout.offsetof(0);
        MSEMANTIC = layout.offsetof(1);
        MINDEX = layout.offsetof(2);
        MDATALENGTH = layout.offsetof(3);
        MTYPE = layout.offsetof(4);
        MDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<AIMaterialProperty, Buffer> {
        private static final AIMaterialProperty ELEMENT_FACTORY = AIMaterialProperty.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMaterialProperty getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mKey() {
            return AIMaterialProperty.nmKey(this.address());
        }

        @NativeType(value="unsigned int")
        public int mSemantic() {
            return AIMaterialProperty.nmSemantic(this.address());
        }

        @NativeType(value="unsigned int")
        public int mIndex() {
            return AIMaterialProperty.nmIndex(this.address());
        }

        @NativeType(value="unsigned int")
        public int mDataLength() {
            return AIMaterialProperty.nmDataLength(this.address());
        }

        @NativeType(value="aiPropertyTypeInfo")
        public int mType() {
            return AIMaterialProperty.nmType(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer mData() {
            return AIMaterialProperty.nmData(this.address());
        }
    }
}

