/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIQuatKey;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVectorKey;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiNodeAnim")
public class AINodeAnim
extends Struct<AINodeAnim>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNODENAME;
    public static final int MNUMPOSITIONKEYS;
    public static final int MPOSITIONKEYS;
    public static final int MNUMROTATIONKEYS;
    public static final int MROTATIONKEYS;
    public static final int MNUMSCALINGKEYS;
    public static final int MSCALINGKEYS;
    public static final int MPRESTATE;
    public static final int MPOSTSTATE;

    protected AINodeAnim(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AINodeAnim create(long address, @Nullable ByteBuffer container) {
        return new AINodeAnim(address, container);
    }

    public AINodeAnim(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AINodeAnim.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mNodeName() {
        return AINodeAnim.nmNodeName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumPositionKeys() {
        return AINodeAnim.nmNumPositionKeys(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVectorKey *")
    public AIVectorKey.Buffer mPositionKeys() {
        return AINodeAnim.nmPositionKeys(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumRotationKeys() {
        return AINodeAnim.nmNumRotationKeys(this.address());
    }

    @Nullable
    @NativeType(value="struct aiQuatKey *")
    public AIQuatKey.Buffer mRotationKeys() {
        return AINodeAnim.nmRotationKeys(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumScalingKeys() {
        return AINodeAnim.nmNumScalingKeys(this.address());
    }

    @Nullable
    @NativeType(value="struct aiVectorKey *")
    public AIVectorKey.Buffer mScalingKeys() {
        return AINodeAnim.nmScalingKeys(this.address());
    }

    @NativeType(value="aiAnimBehaviour")
    public int mPreState() {
        return AINodeAnim.nmPreState(this.address());
    }

    @NativeType(value="aiAnimBehaviour")
    public int mPostState() {
        return AINodeAnim.nmPostState(this.address());
    }

    public AINodeAnim mNodeName(@NativeType(value="struct aiString") AIString value) {
        AINodeAnim.nmNodeName(this.address(), value);
        return this;
    }

    public AINodeAnim mNodeName(Consumer<AIString> consumer) {
        consumer.accept(this.mNodeName());
        return this;
    }

    public AINodeAnim mPositionKeys(@Nullable @NativeType(value="struct aiVectorKey *") AIVectorKey.Buffer value) {
        AINodeAnim.nmPositionKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mRotationKeys(@Nullable @NativeType(value="struct aiQuatKey *") AIQuatKey.Buffer value) {
        AINodeAnim.nmRotationKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mScalingKeys(@Nullable @NativeType(value="struct aiVectorKey *") AIVectorKey.Buffer value) {
        AINodeAnim.nmScalingKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mPreState(@NativeType(value="aiAnimBehaviour") int value) {
        AINodeAnim.nmPreState(this.address(), value);
        return this;
    }

    public AINodeAnim mPostState(@NativeType(value="aiAnimBehaviour") int value) {
        AINodeAnim.nmPostState(this.address(), value);
        return this;
    }

    public AINodeAnim set(AIString mNodeName, @Nullable AIVectorKey.Buffer mPositionKeys, @Nullable AIQuatKey.Buffer mRotationKeys, @Nullable AIVectorKey.Buffer mScalingKeys, int mPreState, int mPostState) {
        this.mNodeName(mNodeName);
        this.mPositionKeys(mPositionKeys);
        this.mRotationKeys(mRotationKeys);
        this.mScalingKeys(mScalingKeys);
        this.mPreState(mPreState);
        this.mPostState(mPostState);
        return this;
    }

    public AINodeAnim set(AINodeAnim src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AINodeAnim malloc() {
        return new AINodeAnim(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AINodeAnim calloc() {
        return new AINodeAnim(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AINodeAnim create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AINodeAnim(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AINodeAnim create(long address) {
        return new AINodeAnim(address, null);
    }

    @Nullable
    public static AINodeAnim createSafe(long address) {
        return address == 0L ? null : new AINodeAnim(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AINodeAnim.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AINodeAnim.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AINodeAnim mallocStack() {
        return AINodeAnim.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINodeAnim callocStack() {
        return AINodeAnim.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINodeAnim mallocStack(MemoryStack stack) {
        return AINodeAnim.malloc(stack);
    }

    @Deprecated
    public static AINodeAnim callocStack(MemoryStack stack) {
        return AINodeAnim.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AINodeAnim.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AINodeAnim.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AINodeAnim.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AINodeAnim.calloc(capacity, stack);
    }

    public static AINodeAnim malloc(MemoryStack stack) {
        return new AINodeAnim(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AINodeAnim calloc(MemoryStack stack) {
        return new AINodeAnim(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmNodeName(long struct) {
        return AIString.create(struct + (long)MNODENAME);
    }

    public static int nmNumPositionKeys(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMPOSITIONKEYS);
    }

    @Nullable
    public static AIVectorKey.Buffer nmPositionKeys(long struct) {
        return AIVectorKey.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MPOSITIONKEYS)), AINodeAnim.nmNumPositionKeys(struct));
    }

    public static int nmNumRotationKeys(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMROTATIONKEYS);
    }

    @Nullable
    public static AIQuatKey.Buffer nmRotationKeys(long struct) {
        return AIQuatKey.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MROTATIONKEYS)), AINodeAnim.nmNumRotationKeys(struct));
    }

    public static int nmNumScalingKeys(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMSCALINGKEYS);
    }

    @Nullable
    public static AIVectorKey.Buffer nmScalingKeys(long struct) {
        return AIVectorKey.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MSCALINGKEYS)), AINodeAnim.nmNumScalingKeys(struct));
    }

    public static int nmPreState(long struct) {
        return UNSAFE.getInt(null, struct + (long)MPRESTATE);
    }

    public static int nmPostState(long struct) {
        return UNSAFE.getInt(null, struct + (long)MPOSTSTATE);
    }

    public static void nmNodeName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNODENAME), (long)AIString.SIZEOF);
    }

    public static void nmNumPositionKeys(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMPOSITIONKEYS, value);
    }

    public static void nmPositionKeys(long struct, @Nullable AIVectorKey.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MPOSITIONKEYS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AINodeAnim.nmNumPositionKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumRotationKeys(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMROTATIONKEYS, value);
    }

    public static void nmRotationKeys(long struct, @Nullable AIQuatKey.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MROTATIONKEYS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AINodeAnim.nmNumRotationKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumScalingKeys(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMSCALINGKEYS, value);
    }

    public static void nmScalingKeys(long struct, @Nullable AIVectorKey.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MSCALINGKEYS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AINodeAnim.nmNumScalingKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmPreState(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MPRESTATE, value);
    }

    public static void nmPostState(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MPOSTSTATE, value);
    }

    public static void validate(long struct) {
        if (AINodeAnim.nmNumPositionKeys(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MPOSITIONKEYS)));
        }
        if (AINodeAnim.nmNumRotationKeys(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MROTATIONKEYS)));
        }
        if (AINodeAnim.nmNumScalingKeys(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MSCALINGKEYS)));
        }
    }

    static {
        Struct.Layout layout = AINodeAnim.__struct((Struct.Member[])new Struct.Member[]{AINodeAnim.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AINodeAnim.__member((int)4), AINodeAnim.__member((int)POINTER_SIZE), AINodeAnim.__member((int)4), AINodeAnim.__member((int)POINTER_SIZE), AINodeAnim.__member((int)4), AINodeAnim.__member((int)POINTER_SIZE), AINodeAnim.__member((int)4), AINodeAnim.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNODENAME = layout.offsetof(0);
        MNUMPOSITIONKEYS = layout.offsetof(1);
        MPOSITIONKEYS = layout.offsetof(2);
        MNUMROTATIONKEYS = layout.offsetof(3);
        MROTATIONKEYS = layout.offsetof(4);
        MNUMSCALINGKEYS = layout.offsetof(5);
        MSCALINGKEYS = layout.offsetof(6);
        MPRESTATE = layout.offsetof(7);
        MPOSTSTATE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AINodeAnim, Buffer>
    implements NativeResource {
        private static final AINodeAnim ELEMENT_FACTORY = AINodeAnim.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AINodeAnim getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mNodeName() {
            return AINodeAnim.nmNodeName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumPositionKeys() {
            return AINodeAnim.nmNumPositionKeys(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVectorKey *")
        public AIVectorKey.Buffer mPositionKeys() {
            return AINodeAnim.nmPositionKeys(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumRotationKeys() {
            return AINodeAnim.nmNumRotationKeys(this.address());
        }

        @Nullable
        @NativeType(value="struct aiQuatKey *")
        public AIQuatKey.Buffer mRotationKeys() {
            return AINodeAnim.nmRotationKeys(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumScalingKeys() {
            return AINodeAnim.nmNumScalingKeys(this.address());
        }

        @Nullable
        @NativeType(value="struct aiVectorKey *")
        public AIVectorKey.Buffer mScalingKeys() {
            return AINodeAnim.nmScalingKeys(this.address());
        }

        @NativeType(value="aiAnimBehaviour")
        public int mPreState() {
            return AINodeAnim.nmPreState(this.address());
        }

        @NativeType(value="aiAnimBehaviour")
        public int mPostState() {
            return AINodeAnim.nmPostState(this.address());
        }

        public Buffer mNodeName(@NativeType(value="struct aiString") AIString value) {
            AINodeAnim.nmNodeName(this.address(), value);
            return this;
        }

        public Buffer mNodeName(Consumer<AIString> consumer) {
            consumer.accept(this.mNodeName());
            return this;
        }

        public Buffer mPositionKeys(@Nullable @NativeType(value="struct aiVectorKey *") AIVectorKey.Buffer value) {
            AINodeAnim.nmPositionKeys(this.address(), value);
            return this;
        }

        public Buffer mRotationKeys(@Nullable @NativeType(value="struct aiQuatKey *") AIQuatKey.Buffer value) {
            AINodeAnim.nmRotationKeys(this.address(), value);
            return this;
        }

        public Buffer mScalingKeys(@Nullable @NativeType(value="struct aiVectorKey *") AIVectorKey.Buffer value) {
            AINodeAnim.nmScalingKeys(this.address(), value);
            return this;
        }

        public Buffer mPreState(@NativeType(value="aiAnimBehaviour") int value) {
            AINodeAnim.nmPreState(this.address(), value);
            return this;
        }

        public Buffer mPostState(@NativeType(value="aiAnimBehaviour") int value) {
            AINodeAnim.nmPostState(this.address(), value);
            return this;
        }
    }
}

