/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiQuaternion")
public class AIQuaternion
extends Struct<AIQuaternion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected AIQuaternion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIQuaternion create(long address, @Nullable ByteBuffer container) {
        return new AIQuaternion(address, container);
    }

    public AIQuaternion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIQuaternion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float w() {
        return AIQuaternion.nw(this.address());
    }

    public float x() {
        return AIQuaternion.nx(this.address());
    }

    public float y() {
        return AIQuaternion.ny(this.address());
    }

    public float z() {
        return AIQuaternion.nz(this.address());
    }

    public AIQuaternion w(float value) {
        AIQuaternion.nw(this.address(), value);
        return this;
    }

    public AIQuaternion x(float value) {
        AIQuaternion.nx(this.address(), value);
        return this;
    }

    public AIQuaternion y(float value) {
        AIQuaternion.ny(this.address(), value);
        return this;
    }

    public AIQuaternion z(float value) {
        AIQuaternion.nz(this.address(), value);
        return this;
    }

    public AIQuaternion set(float w, float x, float y, float z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public AIQuaternion set(AIQuaternion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIQuaternion malloc() {
        return new AIQuaternion(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIQuaternion calloc() {
        return new AIQuaternion(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIQuaternion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIQuaternion(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIQuaternion create(long address) {
        return new AIQuaternion(address, null);
    }

    @Nullable
    public static AIQuaternion createSafe(long address) {
        return address == 0L ? null : new AIQuaternion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIQuaternion.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIQuaternion.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIQuaternion mallocStack() {
        return AIQuaternion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIQuaternion callocStack() {
        return AIQuaternion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIQuaternion mallocStack(MemoryStack stack) {
        return AIQuaternion.malloc(stack);
    }

    @Deprecated
    public static AIQuaternion callocStack(MemoryStack stack) {
        return AIQuaternion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIQuaternion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIQuaternion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIQuaternion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIQuaternion.calloc(capacity, stack);
    }

    public static AIQuaternion malloc(MemoryStack stack) {
        return new AIQuaternion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIQuaternion calloc(MemoryStack stack) {
        return new AIQuaternion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nz(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Z);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = AIQuaternion.__struct((Struct.Member[])new Struct.Member[]{AIQuaternion.__member((int)4), AIQuaternion.__member((int)4), AIQuaternion.__member((int)4), AIQuaternion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIQuaternion, Buffer>
    implements NativeResource {
        private static final AIQuaternion ELEMENT_FACTORY = AIQuaternion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIQuaternion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float w() {
            return AIQuaternion.nw(this.address());
        }

        public float x() {
            return AIQuaternion.nx(this.address());
        }

        public float y() {
            return AIQuaternion.ny(this.address());
        }

        public float z() {
            return AIQuaternion.nz(this.address());
        }

        public Buffer w(float value) {
            AIQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            AIQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            AIQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            AIQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

