/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AITexel;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiTexture")
public class AITexture
extends Struct<AITexture> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MWIDTH;
    public static final int MHEIGHT;
    public static final int ACHFORMATHINT;
    public static final int PCDATA;
    public static final int MFILENAME;

    protected AITexture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AITexture create(long address, @Nullable ByteBuffer container) {
        return new AITexture(address, container);
    }

    public AITexture(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AITexture.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mWidth() {
        return AITexture.nmWidth(this.address());
    }

    @NativeType(value="unsigned int")
    public int mHeight() {
        return AITexture.nmHeight(this.address());
    }

    @NativeType(value="char[9]")
    public ByteBuffer achFormatHint() {
        return AITexture.nachFormatHint(this.address());
    }

    @NativeType(value="char[9]")
    public String achFormatHintString() {
        return AITexture.nachFormatHintString(this.address());
    }

    @NativeType(value="struct aiTexel *")
    public AITexel.Buffer pcData() {
        return AITexture.npcData(this.address());
    }

    @NativeType(value="struct aiString")
    public AIString mFilename() {
        return AITexture.nmFilename(this.address());
    }

    public static AITexture create(long address) {
        return new AITexture(address, null);
    }

    @Nullable
    public static AITexture createSafe(long address) {
        return address == 0L ? null : new AITexture(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nmWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)MWIDTH);
    }

    public static int nmHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)MHEIGHT);
    }

    public static ByteBuffer nachFormatHint(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ACHFORMATHINT), (int)9);
    }

    public static String nachFormatHintString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)ACHFORMATHINT));
    }

    public static AITexel.Buffer npcData(long struct) {
        return AITexel.create(MemoryUtil.memGetAddress((long)(struct + (long)PCDATA)), AITexture.nmWidth(struct) * AITexture.nmHeight(struct));
    }

    public static AIString nmFilename(long struct) {
        return AIString.create(struct + (long)MFILENAME);
    }

    @NativeType(value="char *")
    public ByteBuffer pcDataCompressed() {
        return AITexture.npcDataCompressed(this.address());
    }

    public static ByteBuffer npcDataCompressed(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PCDATA)), (int)AITexture.nmWidth(struct));
    }

    static {
        Struct.Layout layout = AITexture.__struct((Struct.Member[])new Struct.Member[]{AITexture.__member((int)4), AITexture.__member((int)4), AITexture.__array((int)1, (int)9), AITexture.__member((int)POINTER_SIZE), AITexture.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MWIDTH = layout.offsetof(0);
        MHEIGHT = layout.offsetof(1);
        ACHFORMATHINT = layout.offsetof(2);
        PCDATA = layout.offsetof(3);
        MFILENAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<AITexture, Buffer> {
        private static final AITexture ELEMENT_FACTORY = AITexture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AITexture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mWidth() {
            return AITexture.nmWidth(this.address());
        }

        @NativeType(value="unsigned int")
        public int mHeight() {
            return AITexture.nmHeight(this.address());
        }

        @NativeType(value="char[9]")
        public ByteBuffer achFormatHint() {
            return AITexture.nachFormatHint(this.address());
        }

        @NativeType(value="char[9]")
        public String achFormatHintString() {
            return AITexture.nachFormatHintString(this.address());
        }

        @NativeType(value="struct aiTexel *")
        public AITexel.Buffer pcData() {
            return AITexture.npcData(this.address());
        }

        @NativeType(value="struct aiString")
        public AIString mFilename() {
            return AITexture.nmFilename(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pcDataCompressed() {
            return AITexture.npcDataCompressed(this.address());
        }
    }
}

