/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVertexWeight")
public class AIVertexWeight
extends Struct<AIVertexWeight>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MVERTEXID;
    public static final int MWEIGHT;

    protected AIVertexWeight(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIVertexWeight create(long address, @Nullable ByteBuffer container) {
        return new AIVertexWeight(address, container);
    }

    public AIVertexWeight(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIVertexWeight.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mVertexId() {
        return AIVertexWeight.nmVertexId(this.address());
    }

    public float mWeight() {
        return AIVertexWeight.nmWeight(this.address());
    }

    public AIVertexWeight mVertexId(@NativeType(value="unsigned int") int value) {
        AIVertexWeight.nmVertexId(this.address(), value);
        return this;
    }

    public AIVertexWeight mWeight(float value) {
        AIVertexWeight.nmWeight(this.address(), value);
        return this;
    }

    public AIVertexWeight set(int mVertexId, float mWeight) {
        this.mVertexId(mVertexId);
        this.mWeight(mWeight);
        return this;
    }

    public AIVertexWeight set(AIVertexWeight src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIVertexWeight malloc() {
        return new AIVertexWeight(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIVertexWeight calloc() {
        return new AIVertexWeight(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIVertexWeight create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIVertexWeight(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIVertexWeight create(long address) {
        return new AIVertexWeight(address, null);
    }

    @Nullable
    public static AIVertexWeight createSafe(long address) {
        return address == 0L ? null : new AIVertexWeight(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIVertexWeight.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVertexWeight.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIVertexWeight mallocStack() {
        return AIVertexWeight.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVertexWeight callocStack() {
        return AIVertexWeight.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIVertexWeight mallocStack(MemoryStack stack) {
        return AIVertexWeight.malloc(stack);
    }

    @Deprecated
    public static AIVertexWeight callocStack(MemoryStack stack) {
        return AIVertexWeight.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIVertexWeight.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIVertexWeight.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVertexWeight.calloc(capacity, stack);
    }

    public static AIVertexWeight malloc(MemoryStack stack) {
        return new AIVertexWeight(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIVertexWeight calloc(MemoryStack stack) {
        return new AIVertexWeight(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmVertexId(long struct) {
        return UNSAFE.getInt(null, struct + (long)MVERTEXID);
    }

    public static float nmWeight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MWEIGHT);
    }

    public static void nmVertexId(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MVERTEXID, value);
    }

    public static void nmWeight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MWEIGHT, value);
    }

    static {
        Struct.Layout layout = AIVertexWeight.__struct((Struct.Member[])new Struct.Member[]{AIVertexWeight.__member((int)4), AIVertexWeight.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MVERTEXID = layout.offsetof(0);
        MWEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVertexWeight, Buffer>
    implements NativeResource {
        private static final AIVertexWeight ELEMENT_FACTORY = AIVertexWeight.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIVertexWeight getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mVertexId() {
            return AIVertexWeight.nmVertexId(this.address());
        }

        public float mWeight() {
            return AIVertexWeight.nmWeight(this.address());
        }

        public Buffer mVertexId(@NativeType(value="unsigned int") int value) {
            AIVertexWeight.nmVertexId(this.address(), value);
            return this;
        }

        public Buffer mWeight(float value) {
            AIVertexWeight.nmWeight(this.address(), value);
            return this;
        }
    }
}

