/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrDebugUtilsLabelEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerEXT;
import org.lwjgl.openxr.XrDebugUtilsObjectNameInfoEXT;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDebugUtils {
    public static final int XR_EXT_debug_utils_SPEC_VERSION = 5;
    public static final String XR_EXT_DEBUG_UTILS_EXTENSION_NAME = "XR_EXT_debug_utils";
    public static final int XR_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT = 1000019000;
    public static final int XR_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT = 1000019001;
    public static final int XR_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT = 1000019002;
    public static final int XR_TYPE_DEBUG_UTILS_LABEL_EXT = 1000019003;
    public static final int XR_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT = 1000019000;
    public static final int XR_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT = 1;
    public static final int XR_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT = 16;
    public static final int XR_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT = 256;
    public static final int XR_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT = 4096;
    public static final int XR_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT = 1;
    public static final int XR_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT = 2;
    public static final int XR_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT = 4;
    public static final int XR_DEBUG_UTILS_MESSAGE_TYPE_CONFORMANCE_BIT_EXT = 8;

    protected EXTDebugUtils() {
        throw new UnsupportedOperationException();
    }

    public static int nxrSetDebugUtilsObjectNameEXT(XrInstance instance, long nameInfo) {
        long __functionAddress = instance.getCapabilities().xrSetDebugUtilsObjectNameEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)instance.address(), (long)nameInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSetDebugUtilsObjectNameEXT(XrInstance instance, @NativeType(value="XrDebugUtilsObjectNameInfoEXT const *") XrDebugUtilsObjectNameInfoEXT nameInfo) {
        return EXTDebugUtils.nxrSetDebugUtilsObjectNameEXT(instance, nameInfo.address());
    }

    public static int nxrCreateDebugUtilsMessengerEXT(XrInstance instance, long createInfo, long messenger) {
        long __functionAddress = instance.getCapabilities().xrCreateDebugUtilsMessengerEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrDebugUtilsMessengerCreateInfoEXT.validate(createInfo);
        }
        return JNI.callPPPI((long)instance.address(), (long)createInfo, (long)messenger, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateDebugUtilsMessengerEXT(XrInstance instance, @NativeType(value="XrDebugUtilsMessengerCreateInfoEXT const *") XrDebugUtilsMessengerCreateInfoEXT createInfo, @NativeType(value="XrDebugUtilsMessengerEXT *") PointerBuffer messenger) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)messenger, (int)1);
        }
        return EXTDebugUtils.nxrCreateDebugUtilsMessengerEXT(instance, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)messenger));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyDebugUtilsMessengerEXT(XrDebugUtilsMessengerEXT messenger) {
        long __functionAddress = messenger.getCapabilities().xrDestroyDebugUtilsMessengerEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)messenger.address(), (long)__functionAddress);
    }

    public static int nxrSubmitDebugUtilsMessageEXT(XrInstance instance, long messageSeverity, long messageTypes, long callbackData) {
        long __functionAddress = instance.getCapabilities().xrSubmitDebugUtilsMessageEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrDebugUtilsMessengerCallbackDataEXT.validate(callbackData);
        }
        return JNI.callPJJPI((long)instance.address(), (long)messageSeverity, (long)messageTypes, (long)callbackData, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSubmitDebugUtilsMessageEXT(XrInstance instance, @NativeType(value="XrDebugUtilsMessageSeverityFlagsEXT") long messageSeverity, @NativeType(value="XrDebugUtilsMessageTypeFlagsEXT") long messageTypes, @NativeType(value="XrDebugUtilsMessengerCallbackDataEXT const *") XrDebugUtilsMessengerCallbackDataEXT callbackData) {
        return EXTDebugUtils.nxrSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, callbackData.address());
    }

    public static int nxrSessionBeginDebugUtilsLabelRegionEXT(XrSession session, long labelInfo) {
        long __functionAddress = session.getCapabilities().xrSessionBeginDebugUtilsLabelRegionEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrDebugUtilsLabelEXT.validate(labelInfo);
        }
        return JNI.callPPI((long)session.address(), (long)labelInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSessionBeginDebugUtilsLabelRegionEXT(XrSession session, @NativeType(value="XrDebugUtilsLabelEXT const *") XrDebugUtilsLabelEXT labelInfo) {
        return EXTDebugUtils.nxrSessionBeginDebugUtilsLabelRegionEXT(session, labelInfo.address());
    }

    @NativeType(value="XrResult")
    public static int xrSessionEndDebugUtilsLabelRegionEXT(XrSession session) {
        long __functionAddress = session.getCapabilities().xrSessionEndDebugUtilsLabelRegionEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)session.address(), (long)__functionAddress);
    }

    public static int nxrSessionInsertDebugUtilsLabelEXT(XrSession session, long labelInfo) {
        long __functionAddress = session.getCapabilities().xrSessionInsertDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrDebugUtilsLabelEXT.validate(labelInfo);
        }
        return JNI.callPPI((long)session.address(), (long)labelInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSessionInsertDebugUtilsLabelEXT(XrSession session, @NativeType(value="XrDebugUtilsLabelEXT const *") XrDebugUtilsLabelEXT labelInfo) {
        return EXTDebugUtils.nxrSessionInsertDebugUtilsLabelEXT(session, labelInfo.address());
    }
}

