/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrVirtualKeyboardCreateInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardInputInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardLocationInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardMETA;
import org.lwjgl.openxr.XrVirtualKeyboardModelAnimationStatesMETA;
import org.lwjgl.openxr.XrVirtualKeyboardModelVisibilitySetInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardSpaceCreateInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardTextContextChangeInfoMETA;
import org.lwjgl.openxr.XrVirtualKeyboardTextureDataMETA;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class METAVirtualKeyboard {
    public static final int XR_META_virtual_keyboard_SPEC_VERSION = 1;
    public static final String XR_META_VIRTUAL_KEYBOARD_EXTENSION_NAME = "XR_META_virtual_keyboard";
    public static final int XR_MAX_VIRTUAL_KEYBOARD_COMMIT_TEXT_SIZE_META = 3992;
    public static final int XR_OBJECT_TYPE_VIRTUAL_KEYBOARD_META = 1000219000;
    public static final int XR_TYPE_SYSTEM_VIRTUAL_KEYBOARD_PROPERTIES_META = 1000219001;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_CREATE_INFO_META = 1000219002;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_SPACE_CREATE_INFO_META = 1000219003;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_LOCATION_INFO_META = 1000219004;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_MODEL_VISIBILITY_SET_INFO_META = 1000219005;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_ANIMATION_STATE_META = 1000219006;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_MODEL_ANIMATION_STATES_META = 1000219007;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_TEXTURE_DATA_META = 1000219009;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_INPUT_INFO_META = 1000219010;
    public static final int XR_TYPE_VIRTUAL_KEYBOARD_TEXT_CONTEXT_CHANGE_INFO_META = 1000219011;
    public static final int XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_COMMIT_TEXT_META = 1000219014;
    public static final int XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_BACKSPACE_META = 1000219015;
    public static final int XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_ENTER_META = 1000219016;
    public static final int XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_SHOWN_META = 1000219017;
    public static final int XR_TYPE_EVENT_DATA_VIRTUAL_KEYBOARD_HIDDEN_META = 1000219018;
    public static final int XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_CUSTOM_META = 0;
    public static final int XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_FAR_META = 1;
    public static final int XR_VIRTUAL_KEYBOARD_LOCATION_TYPE_DIRECT_META = 2;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_LEFT_META = 1;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_RAY_RIGHT_META = 2;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_LEFT_META = 3;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_RAY_RIGHT_META = 4;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_LEFT_META = 5;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_CONTROLLER_DIRECT_RIGHT_META = 6;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_LEFT_META = 7;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_SOURCE_HAND_DIRECT_INDEX_TIP_RIGHT_META = 8;
    public static final int XR_VIRTUAL_KEYBOARD_INPUT_STATE_PRESSED_BIT_META = 1;

    protected METAVirtualKeyboard() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateVirtualKeyboardMETA(XrSession session, long createInfo, long keyboard) {
        long __functionAddress = session.getCapabilities().xrCreateVirtualKeyboardMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)keyboard, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateVirtualKeyboardMETA(XrSession session, @NativeType(value="XrVirtualKeyboardCreateInfoMETA const *") XrVirtualKeyboardCreateInfoMETA createInfo, @NativeType(value="XrVirtualKeyboardMETA *") PointerBuffer keyboard) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)keyboard, (int)1);
        }
        return METAVirtualKeyboard.nxrCreateVirtualKeyboardMETA(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)keyboard));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyVirtualKeyboardMETA(XrVirtualKeyboardMETA keyboard) {
        long __functionAddress = keyboard.getCapabilities().xrDestroyVirtualKeyboardMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)keyboard.address(), (long)__functionAddress);
    }

    public static int nxrCreateVirtualKeyboardSpaceMETA(XrSession session, XrVirtualKeyboardMETA keyboard, long createInfo, long keyboardSpace) {
        long __functionAddress = session.getCapabilities().xrCreateVirtualKeyboardSpaceMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVirtualKeyboardSpaceCreateInfoMETA.validate(createInfo);
        }
        return JNI.callPPPPI((long)session.address(), (long)keyboard.address(), (long)createInfo, (long)keyboardSpace, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateVirtualKeyboardSpaceMETA(XrSession session, XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardSpaceCreateInfoMETA const *") XrVirtualKeyboardSpaceCreateInfoMETA createInfo, @NativeType(value="XrSpace *") PointerBuffer keyboardSpace) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)keyboardSpace, (int)1);
        }
        return METAVirtualKeyboard.nxrCreateVirtualKeyboardSpaceMETA(session, keyboard, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)keyboardSpace));
    }

    public static int nxrSuggestVirtualKeyboardLocationMETA(XrVirtualKeyboardMETA keyboard, long locationInfo) {
        long __functionAddress = keyboard.getCapabilities().xrSuggestVirtualKeyboardLocationMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVirtualKeyboardLocationInfoMETA.validate(locationInfo);
        }
        return JNI.callPPI((long)keyboard.address(), (long)locationInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSuggestVirtualKeyboardLocationMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardLocationInfoMETA const *") XrVirtualKeyboardLocationInfoMETA locationInfo) {
        return METAVirtualKeyboard.nxrSuggestVirtualKeyboardLocationMETA(keyboard, locationInfo.address());
    }

    public static int nxrGetVirtualKeyboardScaleMETA(XrVirtualKeyboardMETA keyboard, long scale) {
        long __functionAddress = keyboard.getCapabilities().xrGetVirtualKeyboardScaleMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)keyboard.address(), (long)scale, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVirtualKeyboardScaleMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="float *") FloatBuffer scale) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)scale, (int)1);
        }
        return METAVirtualKeyboard.nxrGetVirtualKeyboardScaleMETA(keyboard, MemoryUtil.memAddress((FloatBuffer)scale));
    }

    public static int nxrSetVirtualKeyboardModelVisibilityMETA(XrVirtualKeyboardMETA keyboard, long modelVisibility) {
        long __functionAddress = keyboard.getCapabilities().xrSetVirtualKeyboardModelVisibilityMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)keyboard.address(), (long)modelVisibility, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSetVirtualKeyboardModelVisibilityMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardModelVisibilitySetInfoMETA const *") XrVirtualKeyboardModelVisibilitySetInfoMETA modelVisibility) {
        return METAVirtualKeyboard.nxrSetVirtualKeyboardModelVisibilityMETA(keyboard, modelVisibility.address());
    }

    public static int nxrGetVirtualKeyboardModelAnimationStatesMETA(XrVirtualKeyboardMETA keyboard, long animationStates) {
        long __functionAddress = keyboard.getCapabilities().xrGetVirtualKeyboardModelAnimationStatesMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)keyboard.address(), (long)animationStates, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVirtualKeyboardModelAnimationStatesMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardModelAnimationStatesMETA *") XrVirtualKeyboardModelAnimationStatesMETA animationStates) {
        return METAVirtualKeyboard.nxrGetVirtualKeyboardModelAnimationStatesMETA(keyboard, animationStates.address());
    }

    public static int nxrGetVirtualKeyboardDirtyTexturesMETA(XrVirtualKeyboardMETA keyboard, int textureIdCapacityInput, long textureIdCountOutput, long textureIds) {
        long __functionAddress = keyboard.getCapabilities().xrGetVirtualKeyboardDirtyTexturesMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)keyboard.address(), (int)textureIdCapacityInput, (long)textureIdCountOutput, (long)textureIds, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVirtualKeyboardDirtyTexturesMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="uint32_t *") IntBuffer textureIdCountOutput, @Nullable @NativeType(value="uint64_t *") LongBuffer textureIds) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)textureIdCountOutput, (int)1);
        }
        return METAVirtualKeyboard.nxrGetVirtualKeyboardDirtyTexturesMETA(keyboard, Checks.remainingSafe((Buffer)textureIds), MemoryUtil.memAddress((IntBuffer)textureIdCountOutput), MemoryUtil.memAddressSafe((LongBuffer)textureIds));
    }

    public static int nxrGetVirtualKeyboardTextureDataMETA(XrVirtualKeyboardMETA keyboard, long textureId, long textureData) {
        long __functionAddress = keyboard.getCapabilities().xrGetVirtualKeyboardTextureDataMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)keyboard.address(), (long)textureId, (long)textureData, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVirtualKeyboardTextureDataMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="uint64_t") long textureId, @NativeType(value="XrVirtualKeyboardTextureDataMETA *") XrVirtualKeyboardTextureDataMETA textureData) {
        return METAVirtualKeyboard.nxrGetVirtualKeyboardTextureDataMETA(keyboard, textureId, textureData.address());
    }

    public static int nxrSendVirtualKeyboardInputMETA(XrVirtualKeyboardMETA keyboard, long info, long interactorRootPose) {
        long __functionAddress = keyboard.getCapabilities().xrSendVirtualKeyboardInputMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)keyboard.address(), (long)info, (long)interactorRootPose, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSendVirtualKeyboardInputMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardInputInfoMETA const *") XrVirtualKeyboardInputInfoMETA info, @NativeType(value="XrPosef *") XrPosef interactorRootPose) {
        return METAVirtualKeyboard.nxrSendVirtualKeyboardInputMETA(keyboard, info.address(), interactorRootPose.address());
    }

    public static int nxrChangeVirtualKeyboardTextContextMETA(XrVirtualKeyboardMETA keyboard, long changeInfo) {
        long __functionAddress = keyboard.getCapabilities().xrChangeVirtualKeyboardTextContextMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVirtualKeyboardTextContextChangeInfoMETA.validate(changeInfo);
        }
        return JNI.callPPI((long)keyboard.address(), (long)changeInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrChangeVirtualKeyboardTextContextMETA(XrVirtualKeyboardMETA keyboard, @NativeType(value="XrVirtualKeyboardTextContextChangeInfoMETA const *") XrVirtualKeyboardTextContextChangeInfoMETA changeInfo) {
        return METAVirtualKeyboard.nxrChangeVirtualKeyboardTextContextMETA(keyboard, changeInfo.address());
    }
}

