/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrMarkerDetectorCreateInfoML;
import org.lwjgl.openxr.XrMarkerDetectorML;
import org.lwjgl.openxr.XrMarkerDetectorSnapshotInfoML;
import org.lwjgl.openxr.XrMarkerDetectorStateML;
import org.lwjgl.openxr.XrMarkerSpaceCreateInfoML;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MLMarkerUnderstanding {
    public static final int XR_ML_marker_understanding_SPEC_VERSION = 1;
    public static final String XR_ML_MARKER_UNDERSTANDING_EXTENSION_NAME = "XR_ML_marker_understanding";
    public static final int XR_OBJECT_TYPE_MARKER_DETECTOR_ML = 1000138000;
    public static final int XR_TYPE_SYSTEM_MARKER_UNDERSTANDING_PROPERTIES_ML = 1000138000;
    public static final int XR_TYPE_MARKER_DETECTOR_CREATE_INFO_ML = 1000138001;
    public static final int XR_TYPE_MARKER_DETECTOR_ARUCO_INFO_ML = 1000138002;
    public static final int XR_TYPE_MARKER_DETECTOR_SIZE_INFO_ML = 1000138003;
    public static final int XR_TYPE_MARKER_DETECTOR_APRIL_TAG_INFO_ML = 1000138004;
    public static final int XR_TYPE_MARKER_DETECTOR_CUSTOM_PROFILE_INFO_ML = 1000138005;
    public static final int XR_TYPE_MARKER_DETECTOR_SNAPSHOT_INFO_ML = 1000138006;
    public static final int XR_TYPE_MARKER_DETECTOR_STATE_ML = 1000138007;
    public static final int XR_TYPE_MARKER_SPACE_CREATE_INFO_ML = 1000138008;
    public static final int XR_ERROR_MARKER_DETECTOR_PERMISSION_DENIED_ML = -1000138000;
    public static final int XR_ERROR_MARKER_DETECTOR_LOCATE_FAILED_ML = -1000138001;
    public static final int XR_ERROR_MARKER_DETECTOR_INVALID_DATA_QUERY_ML = -1000138002;
    public static final int XR_ERROR_MARKER_DETECTOR_INVALID_CREATE_INFO_ML = -1000138003;
    public static final int XR_ERROR_MARKER_INVALID_ML = -1000138004;
    public static final int XR_MARKER_DETECTOR_PROFILE_DEFAULT_ML = 0;
    public static final int XR_MARKER_DETECTOR_PROFILE_SPEED_ML = 1;
    public static final int XR_MARKER_DETECTOR_PROFILE_ACCURACY_ML = 2;
    public static final int XR_MARKER_DETECTOR_PROFILE_SMALL_TARGETS_ML = 3;
    public static final int XR_MARKER_DETECTOR_PROFILE_LARGE_FOV_ML = 4;
    public static final int XR_MARKER_DETECTOR_PROFILE_CUSTOM_ML = 5;
    public static final int XR_MARKER_TYPE_ARUCO_ML = 0;
    public static final int XR_MARKER_TYPE_APRIL_TAG_ML = 1;
    public static final int XR_MARKER_TYPE_QR_ML = 2;
    public static final int XR_MARKER_TYPE_EAN_13_ML = 3;
    public static final int XR_MARKER_TYPE_UPC_A_ML = 4;
    public static final int XR_MARKER_TYPE_CODE_128_ML = 5;
    public static final int XR_MARKER_ARUCO_DICT_4X4_50_ML = 0;
    public static final int XR_MARKER_ARUCO_DICT_4X4_100_ML = 1;
    public static final int XR_MARKER_ARUCO_DICT_4X4_250_ML = 2;
    public static final int XR_MARKER_ARUCO_DICT_4X4_1000_ML = 3;
    public static final int XR_MARKER_ARUCO_DICT_5X5_50_ML = 4;
    public static final int XR_MARKER_ARUCO_DICT_5X5_100_ML = 5;
    public static final int XR_MARKER_ARUCO_DICT_5X5_250_ML = 6;
    public static final int XR_MARKER_ARUCO_DICT_5X5_1000_ML = 7;
    public static final int XR_MARKER_ARUCO_DICT_6X6_50_ML = 8;
    public static final int XR_MARKER_ARUCO_DICT_6X6_100_ML = 9;
    public static final int XR_MARKER_ARUCO_DICT_6X6_250_ML = 10;
    public static final int XR_MARKER_ARUCO_DICT_6X6_1000_ML = 11;
    public static final int XR_MARKER_ARUCO_DICT_7X7_50_ML = 12;
    public static final int XR_MARKER_ARUCO_DICT_7X7_100_ML = 13;
    public static final int XR_MARKER_ARUCO_DICT_7X7_250_ML = 14;
    public static final int XR_MARKER_ARUCO_DICT_7X7_1000_ML = 15;
    public static final int XR_MARKER_APRIL_TAG_DICT_16H5_ML = 0;
    public static final int XR_MARKER_APRIL_TAG_DICT_25H9_ML = 1;
    public static final int XR_MARKER_APRIL_TAG_DICT_36H10_ML = 2;
    public static final int XR_MARKER_APRIL_TAG_DICT_36H11_ML = 3;
    public static final int XR_MARKER_DETECTOR_FPS_LOW_ML = 0;
    public static final int XR_MARKER_DETECTOR_FPS_MEDIUM_ML = 1;
    public static final int XR_MARKER_DETECTOR_FPS_HIGH_ML = 2;
    public static final int XR_MARKER_DETECTOR_FPS_MAX_ML = 3;
    public static final int XR_MARKER_DETECTOR_RESOLUTION_LOW_ML = 0;
    public static final int XR_MARKER_DETECTOR_RESOLUTION_MEDIUM_ML = 1;
    public static final int XR_MARKER_DETECTOR_RESOLUTION_HIGH_ML = 2;
    public static final int XR_MARKER_DETECTOR_CAMERA_RGB_CAMERA_ML = 0;
    public static final int XR_MARKER_DETECTOR_CAMERA_WORLD_CAMERAS_ML = 1;
    public static final int XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_NONE_ML = 0;
    public static final int XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_SUBPIX_ML = 1;
    public static final int XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_CONTOUR_ML = 2;
    public static final int XR_MARKER_DETECTOR_CORNER_REFINE_METHOD_APRIL_TAG_ML = 3;
    public static final int XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MAX_ML = 0;
    public static final int XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_FAST_ML = 1;
    public static final int XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_MEDIUM_ML = 2;
    public static final int XR_MARKER_DETECTOR_FULL_ANALYSIS_INTERVAL_SLOW_ML = 3;
    public static final int XR_MARKER_DETECTOR_STATUS_PENDING_ML = 0;
    public static final int XR_MARKER_DETECTOR_STATUS_READY_ML = 1;
    public static final int XR_MARKER_DETECTOR_STATUS_ERROR_ML = 2;

    protected MLMarkerUnderstanding() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateMarkerDetectorML(XrSession session, long createInfo, long markerDetector) {
        long __functionAddress = session.getCapabilities().xrCreateMarkerDetectorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)markerDetector, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateMarkerDetectorML(XrSession session, @NativeType(value="XrMarkerDetectorCreateInfoML const *") XrMarkerDetectorCreateInfoML createInfo, @NativeType(value="XrMarkerDetectorML *") PointerBuffer markerDetector) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)markerDetector, (int)1);
        }
        return MLMarkerUnderstanding.nxrCreateMarkerDetectorML(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)markerDetector));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyMarkerDetectorML(XrMarkerDetectorML markerDetector) {
        long __functionAddress = markerDetector.getCapabilities().xrDestroyMarkerDetectorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)markerDetector.address(), (long)__functionAddress);
    }

    public static int nxrSnapshotMarkerDetectorML(XrMarkerDetectorML markerDetector, long snapshotInfo) {
        long __functionAddress = markerDetector.getCapabilities().xrSnapshotMarkerDetectorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)markerDetector.address(), (long)snapshotInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrSnapshotMarkerDetectorML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerDetectorSnapshotInfoML *") XrMarkerDetectorSnapshotInfoML snapshotInfo) {
        return MLMarkerUnderstanding.nxrSnapshotMarkerDetectorML(markerDetector, snapshotInfo.address());
    }

    public static int nxrGetMarkerDetectorStateML(XrMarkerDetectorML markerDetector, long state) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkerDetectorStateML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)markerDetector.address(), (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerDetectorStateML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerDetectorStateML *") XrMarkerDetectorStateML state) {
        return MLMarkerUnderstanding.nxrGetMarkerDetectorStateML(markerDetector, state.address());
    }

    public static int nxrGetMarkersML(XrMarkerDetectorML markerDetector, int markerCapacityInput, long markerCountOutput, long markers) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkersML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)markerDetector.address(), (int)markerCapacityInput, (long)markerCountOutput, (long)markers, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkersML(XrMarkerDetectorML markerDetector, @NativeType(value="uint32_t *") IntBuffer markerCountOutput, @Nullable @NativeType(value="XrMarkerML *") LongBuffer markers) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)markerCountOutput, (int)1);
        }
        return MLMarkerUnderstanding.nxrGetMarkersML(markerDetector, Checks.remainingSafe((Buffer)markers), MemoryUtil.memAddress((IntBuffer)markerCountOutput), MemoryUtil.memAddressSafe((LongBuffer)markers));
    }

    public static int nxrGetMarkerReprojectionErrorML(XrMarkerDetectorML markerDetector, long marker, long reprojectionErrorMeters) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkerReprojectionErrorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)markerDetector.address(), (long)marker, (long)reprojectionErrorMeters, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerReprojectionErrorML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerML") long marker, @NativeType(value="float *") FloatBuffer reprojectionErrorMeters) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)reprojectionErrorMeters, (int)1);
        }
        return MLMarkerUnderstanding.nxrGetMarkerReprojectionErrorML(markerDetector, marker, MemoryUtil.memAddress((FloatBuffer)reprojectionErrorMeters));
    }

    public static int nxrGetMarkerLengthML(XrMarkerDetectorML markerDetector, long marker, long meters) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkerLengthML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)markerDetector.address(), (long)marker, (long)meters, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerLengthML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerML") long marker, @NativeType(value="float *") FloatBuffer meters) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)meters, (int)1);
        }
        return MLMarkerUnderstanding.nxrGetMarkerLengthML(markerDetector, marker, MemoryUtil.memAddress((FloatBuffer)meters));
    }

    public static int nxrGetMarkerNumberML(XrMarkerDetectorML markerDetector, long marker, long number) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkerNumberML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)markerDetector.address(), (long)marker, (long)number, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerNumberML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerML") long marker, @NativeType(value="uint64_t *") LongBuffer number) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)number, (int)1);
        }
        return MLMarkerUnderstanding.nxrGetMarkerNumberML(markerDetector, marker, MemoryUtil.memAddress((LongBuffer)number));
    }

    public static int nxrGetMarkerStringML(XrMarkerDetectorML markerDetector, long marker, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = markerDetector.getCapabilities().xrGetMarkerStringML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)markerDetector.address(), (long)marker, (int)bufferCapacityInput, (long)bufferCountOutput, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetMarkerStringML(XrMarkerDetectorML markerDetector, @NativeType(value="XrMarkerML") long marker, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="char *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, (int)1);
        }
        return MLMarkerUnderstanding.nxrGetMarkerStringML(markerDetector, marker, Checks.remainingSafe((Buffer)buffer), MemoryUtil.memAddress((IntBuffer)bufferCountOutput), MemoryUtil.memAddressSafe((ByteBuffer)buffer));
    }

    public static int nxrCreateMarkerSpaceML(XrSession session, long createInfo, long space) {
        long __functionAddress = session.getCapabilities().xrCreateMarkerSpaceML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrMarkerSpaceCreateInfoML.validate(createInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)space, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateMarkerSpaceML(XrSession session, @NativeType(value="XrMarkerSpaceCreateInfoML const *") XrMarkerSpaceCreateInfoML createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)space, (int)1);
        }
        return MLMarkerUnderstanding.nxrCreateMarkerSpaceML(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)space));
    }
}

