/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSetCreateInfo
extends Struct<XrActionSetCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTIONSETNAME;
    public static final int LOCALIZEDACTIONSETNAME;
    public static final int PRIORITY;

    protected XrActionSetCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionSetCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionSetCreateInfo(address, container);
    }

    public XrActionSetCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionSetCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionSetCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionSetCreateInfo.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
    public ByteBuffer actionSetName() {
        return XrActionSetCreateInfo.nactionSetName(this.address());
    }

    @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
    public String actionSetNameString() {
        return XrActionSetCreateInfo.nactionSetNameString(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
    public ByteBuffer localizedActionSetName() {
        return XrActionSetCreateInfo.nlocalizedActionSetName(this.address());
    }

    @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
    public String localizedActionSetNameString() {
        return XrActionSetCreateInfo.nlocalizedActionSetNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int priority() {
        return XrActionSetCreateInfo.npriority(this.address());
    }

    public XrActionSetCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionSetCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo type$Default() {
        return this.type(28);
    }

    public XrActionSetCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionSetCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo actionSetName(@NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
        XrActionSetCreateInfo.nactionSetName(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo localizedActionSetName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
        XrActionSetCreateInfo.nlocalizedActionSetName(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo priority(@NativeType(value="uint32_t") int value) {
        XrActionSetCreateInfo.npriority(this.address(), value);
        return this;
    }

    public XrActionSetCreateInfo set(int type, long next, ByteBuffer actionSetName, ByteBuffer localizedActionSetName, int priority) {
        this.type(type);
        this.next(next);
        this.actionSetName(actionSetName);
        this.localizedActionSetName(localizedActionSetName);
        this.priority(priority);
        return this;
    }

    public XrActionSetCreateInfo set(XrActionSetCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionSetCreateInfo malloc() {
        return new XrActionSetCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionSetCreateInfo calloc() {
        return new XrActionSetCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionSetCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionSetCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionSetCreateInfo create(long address) {
        return new XrActionSetCreateInfo(address, null);
    }

    @Nullable
    public static XrActionSetCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrActionSetCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionSetCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSetCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionSetCreateInfo malloc(MemoryStack stack) {
        return new XrActionSetCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionSetCreateInfo calloc(MemoryStack stack) {
        return new XrActionSetCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nactionSetName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ACTIONSETNAME), (int)64);
    }

    public static String nactionSetNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)ACTIONSETNAME));
    }

    public static ByteBuffer nlocalizedActionSetName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LOCALIZEDACTIONSETNAME), (int)128);
    }

    public static String nlocalizedActionSetNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)LOCALIZEDACTIONSETNAME));
    }

    public static int npriority(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIORITY);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nactionSetName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)64);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)ACTIONSETNAME), (long)value.remaining());
    }

    public static void nlocalizedActionSetName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)128);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LOCALIZEDACTIONSETNAME), (long)value.remaining());
    }

    public static void npriority(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIORITY, value);
    }

    static {
        Struct.Layout layout = XrActionSetCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrActionSetCreateInfo.__member((int)4), XrActionSetCreateInfo.__member((int)POINTER_SIZE), XrActionSetCreateInfo.__array((int)1, (int)64), XrActionSetCreateInfo.__array((int)1, (int)128), XrActionSetCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTIONSETNAME = layout.offsetof(2);
        LOCALIZEDACTIONSETNAME = layout.offsetof(3);
        PRIORITY = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrActionSetCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionSetCreateInfo ELEMENT_FACTORY = XrActionSetCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionSetCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionSetCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionSetCreateInfo.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
        public ByteBuffer actionSetName() {
            return XrActionSetCreateInfo.nactionSetName(this.address());
        }

        @NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]")
        public String actionSetNameString() {
            return XrActionSetCreateInfo.nactionSetNameString(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
        public ByteBuffer localizedActionSetName() {
            return XrActionSetCreateInfo.nlocalizedActionSetName(this.address());
        }

        @NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]")
        public String localizedActionSetNameString() {
            return XrActionSetCreateInfo.nlocalizedActionSetNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int priority() {
            return XrActionSetCreateInfo.npriority(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionSetCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(28);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionSetCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer actionSetName(@NativeType(value="char[XR_MAX_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
            XrActionSetCreateInfo.nactionSetName(this.address(), value);
            return this;
        }

        public Buffer localizedActionSetName(@NativeType(value="char[XR_MAX_LOCALIZED_ACTION_SET_NAME_SIZE]") ByteBuffer value) {
            XrActionSetCreateInfo.nlocalizedActionSetName(this.address(), value);
            return this;
        }

        public Buffer priority(@NativeType(value="uint32_t") int value) {
            XrActionSetCreateInfo.npriority(this.address(), value);
            return this;
        }
    }
}

