/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionStateFloat
extends Struct<XrActionStateFloat>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CURRENTSTATE;
    public static final int CHANGEDSINCELASTSYNC;
    public static final int LASTCHANGETIME;
    public static final int ISACTIVE;

    protected XrActionStateFloat(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionStateFloat create(long address, @Nullable ByteBuffer container) {
        return new XrActionStateFloat(address, container);
    }

    public XrActionStateFloat(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionStateFloat.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionStateFloat.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrActionStateFloat.nnext(this.address());
    }

    public float currentState() {
        return XrActionStateFloat.ncurrentState(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean changedSinceLastSync() {
        return XrActionStateFloat.nchangedSinceLastSync(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrActionStateFloat.nlastChangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrActionStateFloat.nisActive(this.address()) != 0;
    }

    public XrActionStateFloat type(@NativeType(value="XrStructureType") int value) {
        XrActionStateFloat.ntype(this.address(), value);
        return this;
    }

    public XrActionStateFloat type$Default() {
        return this.type(24);
    }

    public XrActionStateFloat next(@NativeType(value="void *") long value) {
        XrActionStateFloat.nnext(this.address(), value);
        return this;
    }

    public XrActionStateFloat currentState(float value) {
        XrActionStateFloat.ncurrentState(this.address(), value);
        return this;
    }

    public XrActionStateFloat changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
        XrActionStateFloat.nchangedSinceLastSync(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateFloat lastChangeTime(@NativeType(value="XrTime") long value) {
        XrActionStateFloat.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrActionStateFloat isActive(@NativeType(value="XrBool32") boolean value) {
        XrActionStateFloat.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrActionStateFloat set(int type, long next, float currentState, boolean changedSinceLastSync, long lastChangeTime, boolean isActive) {
        this.type(type);
        this.next(next);
        this.currentState(currentState);
        this.changedSinceLastSync(changedSinceLastSync);
        this.lastChangeTime(lastChangeTime);
        this.isActive(isActive);
        return this;
    }

    public XrActionStateFloat set(XrActionStateFloat src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionStateFloat malloc() {
        return new XrActionStateFloat(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionStateFloat calloc() {
        return new XrActionStateFloat(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionStateFloat create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionStateFloat(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionStateFloat create(long address) {
        return new XrActionStateFloat(address, null);
    }

    @Nullable
    public static XrActionStateFloat createSafe(long address) {
        return address == 0L ? null : new XrActionStateFloat(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionStateFloat.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionStateFloat.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionStateFloat malloc(MemoryStack stack) {
        return new XrActionStateFloat(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionStateFloat calloc(MemoryStack stack) {
        return new XrActionStateFloat(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float ncurrentState(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CURRENTSTATE);
    }

    public static int nchangedSinceLastSync(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHANGEDSINCELASTSYNC);
    }

    public static long nlastChangeTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)LASTCHANGETIME);
    }

    public static int nisActive(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISACTIVE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncurrentState(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CURRENTSTATE, value);
    }

    public static void nchangedSinceLastSync(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHANGEDSINCELASTSYNC, value);
    }

    public static void nlastChangeTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LASTCHANGETIME, value);
    }

    public static void nisActive(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISACTIVE, value);
    }

    static {
        Struct.Layout layout = XrActionStateFloat.__struct((Struct.Member[])new Struct.Member[]{XrActionStateFloat.__member((int)4), XrActionStateFloat.__member((int)POINTER_SIZE), XrActionStateFloat.__member((int)4), XrActionStateFloat.__member((int)4), XrActionStateFloat.__member((int)8), XrActionStateFloat.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CURRENTSTATE = layout.offsetof(2);
        CHANGEDSINCELASTSYNC = layout.offsetof(3);
        LASTCHANGETIME = layout.offsetof(4);
        ISACTIVE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrActionStateFloat, Buffer>
    implements NativeResource {
        private static final XrActionStateFloat ELEMENT_FACTORY = XrActionStateFloat.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionStateFloat getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionStateFloat.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrActionStateFloat.nnext(this.address());
        }

        public float currentState() {
            return XrActionStateFloat.ncurrentState(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean changedSinceLastSync() {
            return XrActionStateFloat.nchangedSinceLastSync(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrActionStateFloat.nlastChangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrActionStateFloat.nisActive(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionStateFloat.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(24);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrActionStateFloat.nnext(this.address(), value);
            return this;
        }

        public Buffer currentState(float value) {
            XrActionStateFloat.ncurrentState(this.address(), value);
            return this;
        }

        public Buffer changedSinceLastSync(@NativeType(value="XrBool32") boolean value) {
            XrActionStateFloat.nchangedSinceLastSync(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrActionStateFloat.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrActionStateFloat.nisActive(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

