/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSuggestedBinding
extends Struct<XrActionSuggestedBinding>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTION;
    public static final int BINDING;

    protected XrActionSuggestedBinding(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionSuggestedBinding create(long address, @Nullable ByteBuffer container) {
        return new XrActionSuggestedBinding(address, container);
    }

    public XrActionSuggestedBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionSuggestedBinding.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrActionSuggestedBinding.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrActionSuggestedBinding.nbinding(this.address());
    }

    public XrActionSuggestedBinding action(XrAction value) {
        XrActionSuggestedBinding.naction(this.address(), value);
        return this;
    }

    public XrActionSuggestedBinding binding(@NativeType(value="XrPath") long value) {
        XrActionSuggestedBinding.nbinding(this.address(), value);
        return this;
    }

    public XrActionSuggestedBinding set(XrAction action, long binding) {
        this.action(action);
        this.binding(binding);
        return this;
    }

    public XrActionSuggestedBinding set(XrActionSuggestedBinding src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionSuggestedBinding malloc() {
        return new XrActionSuggestedBinding(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionSuggestedBinding calloc() {
        return new XrActionSuggestedBinding(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionSuggestedBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionSuggestedBinding(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionSuggestedBinding create(long address) {
        return new XrActionSuggestedBinding(address, null);
    }

    @Nullable
    public static XrActionSuggestedBinding createSafe(long address) {
        return address == 0L ? null : new XrActionSuggestedBinding(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionSuggestedBinding.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSuggestedBinding.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionSuggestedBinding malloc(MemoryStack stack) {
        return new XrActionSuggestedBinding(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionSuggestedBinding calloc(MemoryStack stack) {
        return new XrActionSuggestedBinding(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nbinding(long struct) {
        return UNSAFE.getLong(null, struct + (long)BINDING);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nbinding(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BINDING, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrActionSuggestedBinding.__struct((Struct.Member[])new Struct.Member[]{XrActionSuggestedBinding.__member((int)POINTER_SIZE), XrActionSuggestedBinding.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTION = layout.offsetof(0);
        BINDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActionSuggestedBinding, Buffer>
    implements NativeResource {
        private static final XrActionSuggestedBinding ELEMENT_FACTORY = XrActionSuggestedBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActionSuggestedBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrActionSuggestedBinding.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrActionSuggestedBinding.nbinding(this.address());
        }

        public Buffer action(XrAction value) {
            XrActionSuggestedBinding.naction(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrActionSuggestedBinding.nbinding(this.address(), value);
            return this;
        }
    }
}

