/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseInStructure
extends Struct<XrBaseInStructure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrBaseInStructure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBaseInStructure create(long address, @Nullable ByteBuffer container) {
        return new XrBaseInStructure(address, container);
    }

    public XrBaseInStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBaseInStructure.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseInStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseInStructure const *")
    public XrBaseInStructure next() {
        return XrBaseInStructure.nnext(this.address());
    }

    public XrBaseInStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseInStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseInStructure next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
        XrBaseInStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseInStructure set(int type, XrBaseInStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseInStructure set(XrBaseInStructure src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBaseInStructure malloc() {
        return new XrBaseInStructure(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBaseInStructure calloc() {
        return new XrBaseInStructure(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBaseInStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBaseInStructure(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBaseInStructure create(long address) {
        return new XrBaseInStructure(address, null);
    }

    @Nullable
    public static XrBaseInStructure createSafe(long address) {
        return address == 0L ? null : new XrBaseInStructure(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBaseInStructure.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseInStructure.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBaseInStructure malloc(MemoryStack stack) {
        return new XrBaseInStructure(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBaseInStructure calloc(MemoryStack stack) {
        return new XrBaseInStructure(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseInStructure nnext(long struct) {
        return XrBaseInStructure.create(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseInStructure value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = XrBaseInStructure.__struct((Struct.Member[])new Struct.Member[]{XrBaseInStructure.__member((int)4), XrBaseInStructure.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseInStructure, Buffer>
    implements NativeResource {
        private static final XrBaseInStructure ELEMENT_FACTORY = XrBaseInStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrBaseInStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseInStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseInStructure const *")
        public XrBaseInStructure next() {
            return XrBaseInStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseInStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
            XrBaseInStructure.nnext(this.address(), value);
            return this;
        }
    }
}

