/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBoxf;
import org.lwjgl.openxr.XrExtent3Df;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrBoxfKHR
extends XrBoxf {
    protected XrBoxfKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrBoxfKHR create(long address, @Nullable ByteBuffer container) {
        return new XrBoxfKHR(address, container);
    }

    public XrBoxfKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrBoxfKHR center(XrPosef value) {
        XrBoxfKHR.ncenter(this.address(), value);
        return this;
    }

    @Override
    public XrBoxfKHR center(Consumer<XrPosef> consumer) {
        consumer.accept(this.center());
        return this;
    }

    @Override
    public XrBoxfKHR extents(XrExtent3Df value) {
        XrBoxfKHR.nextents(this.address(), value);
        return this;
    }

    @Override
    public XrBoxfKHR extents(Consumer<XrExtent3Df> consumer) {
        consumer.accept(this.extents());
        return this;
    }

    @Override
    public XrBoxfKHR set(XrPosef center, XrExtent3Df extents) {
        this.center(center);
        this.extents(extents);
        return this;
    }

    public XrBoxfKHR set(XrBoxfKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBoxfKHR malloc() {
        return new XrBoxfKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBoxfKHR calloc() {
        return new XrBoxfKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBoxfKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBoxfKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBoxfKHR create(long address) {
        return new XrBoxfKHR(address, null);
    }

    @Nullable
    public static XrBoxfKHR createSafe(long address) {
        return address == 0L ? null : new XrBoxfKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBoxfKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoxfKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBoxfKHR malloc(MemoryStack stack) {
        return new XrBoxfKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBoxfKHR calloc(MemoryStack stack) {
        return new XrBoxfKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrBoxf.Buffer {
        private static final XrBoxfKHR ELEMENT_FACTORY = XrBoxfKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrBoxfKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer center(XrPosef value) {
            XrBoxfKHR.ncenter(this.address(), value);
            return this;
        }

        @Override
        public Buffer center(Consumer<XrPosef> consumer) {
            consumer.accept(this.center());
            return this;
        }

        @Override
        public Buffer extents(XrExtent3Df value) {
            XrBoxfKHR.nextents(this.address(), value);
            return this;
        }

        @Override
        public Buffer extents(Consumer<XrExtent3Df> consumer) {
            consumer.accept(this.extents());
            return this;
        }
    }
}

