/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrColor3f
extends Struct<XrColor3f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;

    protected XrColor3f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrColor3f create(long address, @Nullable ByteBuffer container) {
        return new XrColor3f(address, container);
    }

    public XrColor3f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrColor3f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return XrColor3f.nr(this.address());
    }

    public float g() {
        return XrColor3f.ng(this.address());
    }

    public float b() {
        return XrColor3f.nb(this.address());
    }

    public XrColor3f r(float value) {
        XrColor3f.nr(this.address(), value);
        return this;
    }

    public XrColor3f g(float value) {
        XrColor3f.ng(this.address(), value);
        return this;
    }

    public XrColor3f b(float value) {
        XrColor3f.nb(this.address(), value);
        return this;
    }

    public XrColor3f set(float r, float g, float b) {
        this.r(r);
        this.g(g);
        this.b(b);
        return this;
    }

    public XrColor3f set(XrColor3f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrColor3f malloc() {
        return new XrColor3f(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrColor3f calloc() {
        return new XrColor3f(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrColor3f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrColor3f(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrColor3f create(long address) {
        return new XrColor3f(address, null);
    }

    @Nullable
    public static XrColor3f createSafe(long address) {
        return address == 0L ? null : new XrColor3f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrColor3f.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrColor3f.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrColor3f malloc(MemoryStack stack) {
        return new XrColor3f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrColor3f calloc(MemoryStack stack) {
        return new XrColor3f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    static {
        Struct.Layout layout = XrColor3f.__struct((Struct.Member[])new Struct.Member[]{XrColor3f.__member((int)4), XrColor3f.__member((int)4), XrColor3f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrColor3f, Buffer>
    implements NativeResource {
        private static final XrColor3f ELEMENT_FACTORY = XrColor3f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrColor3f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return XrColor3f.nr(this.address());
        }

        public float g() {
            return XrColor3f.ng(this.address());
        }

        public float b() {
            return XrColor3f.nb(this.address());
        }

        public Buffer r(float value) {
            XrColor3f.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            XrColor3f.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            XrColor3f.nb(this.address(), value);
            return this;
        }
    }
}

