/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerDepthInfoKHR
extends Struct<XrCompositionLayerDepthInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUBIMAGE;
    public static final int MINDEPTH;
    public static final int MAXDEPTH;
    public static final int NEARZ;
    public static final int FARZ;

    protected XrCompositionLayerDepthInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrCompositionLayerDepthInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerDepthInfoKHR(address, container);
    }

    public XrCompositionLayerDepthInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerDepthInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerDepthInfoKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerDepthInfoKHR.nnext(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerDepthInfoKHR.nsubImage(this.address());
    }

    public float minDepth() {
        return XrCompositionLayerDepthInfoKHR.nminDepth(this.address());
    }

    public float maxDepth() {
        return XrCompositionLayerDepthInfoKHR.nmaxDepth(this.address());
    }

    public float nearZ() {
        return XrCompositionLayerDepthInfoKHR.nnearZ(this.address());
    }

    public float farZ() {
        return XrCompositionLayerDepthInfoKHR.nfarZ(this.address());
    }

    public XrCompositionLayerDepthInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerDepthInfoKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR type$Default() {
        return this.type(1000010000);
    }

    public XrCompositionLayerDepthInfoKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerDepthInfoKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR subImage(XrSwapchainSubImage value) {
        XrCompositionLayerDepthInfoKHR.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerDepthInfoKHR minDepth(float value) {
        XrCompositionLayerDepthInfoKHR.nminDepth(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR maxDepth(float value) {
        XrCompositionLayerDepthInfoKHR.nmaxDepth(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR nearZ(float value) {
        XrCompositionLayerDepthInfoKHR.nnearZ(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR farZ(float value) {
        XrCompositionLayerDepthInfoKHR.nfarZ(this.address(), value);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR set(int type, long next, XrSwapchainSubImage subImage, float minDepth, float maxDepth, float nearZ, float farZ) {
        this.type(type);
        this.next(next);
        this.subImage(subImage);
        this.minDepth(minDepth);
        this.maxDepth(maxDepth);
        this.nearZ(nearZ);
        this.farZ(farZ);
        return this;
    }

    public XrCompositionLayerDepthInfoKHR set(XrCompositionLayerDepthInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerDepthInfoKHR malloc() {
        return new XrCompositionLayerDepthInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrCompositionLayerDepthInfoKHR calloc() {
        return new XrCompositionLayerDepthInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrCompositionLayerDepthInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrCompositionLayerDepthInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrCompositionLayerDepthInfoKHR create(long address) {
        return new XrCompositionLayerDepthInfoKHR(address, null);
    }

    @Nullable
    public static XrCompositionLayerDepthInfoKHR createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerDepthInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrCompositionLayerDepthInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerDepthInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrCompositionLayerDepthInfoKHR malloc(MemoryStack stack) {
        return new XrCompositionLayerDepthInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerDepthInfoKHR calloc(MemoryStack stack) {
        return new XrCompositionLayerDepthInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static float nminDepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINDEPTH);
    }

    public static float nmaxDepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXDEPTH);
    }

    public static float nnearZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)NEARZ);
    }

    public static float nfarZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FARZ);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBIMAGE), (long)XrSwapchainSubImage.SIZEOF);
    }

    public static void nminDepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINDEPTH, value);
    }

    public static void nmaxDepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXDEPTH, value);
    }

    public static void nnearZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)NEARZ, value);
    }

    public static void nfarZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)FARZ, value);
    }

    public static void validate(long struct) {
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerDepthInfoKHR.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerDepthInfoKHR.__member((int)4), XrCompositionLayerDepthInfoKHR.__member((int)POINTER_SIZE), XrCompositionLayerDepthInfoKHR.__member((int)XrSwapchainSubImage.SIZEOF, (int)XrSwapchainSubImage.ALIGNOF), XrCompositionLayerDepthInfoKHR.__member((int)4), XrCompositionLayerDepthInfoKHR.__member((int)4), XrCompositionLayerDepthInfoKHR.__member((int)4), XrCompositionLayerDepthInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUBIMAGE = layout.offsetof(2);
        MINDEPTH = layout.offsetof(3);
        MAXDEPTH = layout.offsetof(4);
        NEARZ = layout.offsetof(5);
        FARZ = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerDepthInfoKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerDepthInfoKHR ELEMENT_FACTORY = XrCompositionLayerDepthInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerDepthInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerDepthInfoKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerDepthInfoKHR.nnext(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerDepthInfoKHR.nsubImage(this.address());
        }

        public float minDepth() {
            return XrCompositionLayerDepthInfoKHR.nminDepth(this.address());
        }

        public float maxDepth() {
            return XrCompositionLayerDepthInfoKHR.nmaxDepth(this.address());
        }

        public float nearZ() {
            return XrCompositionLayerDepthInfoKHR.nnearZ(this.address());
        }

        public float farZ() {
            return XrCompositionLayerDepthInfoKHR.nfarZ(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerDepthInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000010000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerDepthInfoKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerDepthInfoKHR.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer minDepth(float value) {
            XrCompositionLayerDepthInfoKHR.nminDepth(this.address(), value);
            return this;
        }

        public Buffer maxDepth(float value) {
            XrCompositionLayerDepthInfoKHR.nmaxDepth(this.address(), value);
            return this;
        }

        public Buffer nearZ(float value) {
            XrCompositionLayerDepthInfoKHR.nnearZ(this.address(), value);
            return this;
        }

        public Buffer farZ(float value) {
            XrCompositionLayerDepthInfoKHR.nfarZ(this.address(), value);
            return this;
        }
    }
}

