/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerEquirectKHR
extends Struct<XrCompositionLayerEquirectKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SUBIMAGE;
    public static final int POSE;
    public static final int RADIUS;
    public static final int SCALE;
    public static final int BIAS;

    protected XrCompositionLayerEquirectKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrCompositionLayerEquirectKHR create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerEquirectKHR(address, container);
    }

    public XrCompositionLayerEquirectKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerEquirectKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerEquirectKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerEquirectKHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerEquirectKHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerEquirectKHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerEquirectKHR.neyeVisibility(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerEquirectKHR.nsubImage(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerEquirectKHR.npose(this.address());
    }

    public float radius() {
        return XrCompositionLayerEquirectKHR.nradius(this.address());
    }

    public XrVector2f scale() {
        return XrCompositionLayerEquirectKHR.nscale(this.address());
    }

    public XrVector2f bias() {
        return XrCompositionLayerEquirectKHR.nbias(this.address());
    }

    public XrCompositionLayerEquirectKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerEquirectKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR type$Default() {
        return this.type(1000018000);
    }

    public XrCompositionLayerEquirectKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerEquirectKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerEquirectKHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR space(XrSpace value) {
        XrCompositionLayerEquirectKHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerEquirectKHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR subImage(XrSwapchainSubImage value) {
        XrCompositionLayerEquirectKHR.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerEquirectKHR pose(XrPosef value) {
        XrCompositionLayerEquirectKHR.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerEquirectKHR radius(float value) {
        XrCompositionLayerEquirectKHR.nradius(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR scale(XrVector2f value) {
        XrCompositionLayerEquirectKHR.nscale(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR scale(Consumer<XrVector2f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrCompositionLayerEquirectKHR bias(XrVector2f value) {
        XrCompositionLayerEquirectKHR.nbias(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR bias(Consumer<XrVector2f> consumer) {
        consumer.accept(this.bias());
        return this;
    }

    public XrCompositionLayerEquirectKHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchainSubImage subImage, XrPosef pose, float radius, XrVector2f scale, XrVector2f bias) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.subImage(subImage);
        this.pose(pose);
        this.radius(radius);
        this.scale(scale);
        this.bias(bias);
        return this;
    }

    public XrCompositionLayerEquirectKHR set(XrCompositionLayerEquirectKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerEquirectKHR malloc() {
        return new XrCompositionLayerEquirectKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrCompositionLayerEquirectKHR calloc() {
        return new XrCompositionLayerEquirectKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrCompositionLayerEquirectKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrCompositionLayerEquirectKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrCompositionLayerEquirectKHR create(long address) {
        return new XrCompositionLayerEquirectKHR(address, null);
    }

    @Nullable
    public static XrCompositionLayerEquirectKHR createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerEquirectKHR(address, null);
    }

    public static XrCompositionLayerEquirectKHR create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerEquirectKHR(value.address(), XrCompositionLayerEquirectKHR.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrCompositionLayerEquirectKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerEquirectKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerEquirectKHR.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerEquirectKHR malloc(MemoryStack stack) {
        return new XrCompositionLayerEquirectKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerEquirectKHR calloc(MemoryStack stack) {
        return new XrCompositionLayerEquirectKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int neyeVisibility(long struct) {
        return UNSAFE.getInt(null, struct + (long)EYEVISIBILITY);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static XrVector2f nscale(long struct) {
        return XrVector2f.create(struct + (long)SCALE);
    }

    public static XrVector2f nbias(long struct) {
        return XrVector2f.create(struct + (long)BIAS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EYEVISIBILITY, value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBIMAGE), (long)XrSwapchainSubImage.SIZEOF);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    public static void nscale(long struct, XrVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCALE), (long)XrVector2f.SIZEOF);
    }

    public static void nbias(long struct, XrVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BIAS), (long)XrVector2f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerEquirectKHR.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerEquirectKHR.__member((int)4), XrCompositionLayerEquirectKHR.__member((int)POINTER_SIZE), XrCompositionLayerEquirectKHR.__member((int)8), XrCompositionLayerEquirectKHR.__member((int)POINTER_SIZE), XrCompositionLayerEquirectKHR.__member((int)4), XrCompositionLayerEquirectKHR.__member((int)XrSwapchainSubImage.SIZEOF, (int)XrSwapchainSubImage.ALIGNOF), XrCompositionLayerEquirectKHR.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrCompositionLayerEquirectKHR.__member((int)4), XrCompositionLayerEquirectKHR.__member((int)XrVector2f.SIZEOF, (int)XrVector2f.ALIGNOF), XrCompositionLayerEquirectKHR.__member((int)XrVector2f.SIZEOF, (int)XrVector2f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SUBIMAGE = layout.offsetof(5);
        POSE = layout.offsetof(6);
        RADIUS = layout.offsetof(7);
        SCALE = layout.offsetof(8);
        BIAS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerEquirectKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerEquirectKHR ELEMENT_FACTORY = XrCompositionLayerEquirectKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerEquirectKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerEquirectKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerEquirectKHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerEquirectKHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerEquirectKHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerEquirectKHR.neyeVisibility(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerEquirectKHR.nsubImage(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerEquirectKHR.npose(this.address());
        }

        public float radius() {
            return XrCompositionLayerEquirectKHR.nradius(this.address());
        }

        public XrVector2f scale() {
            return XrCompositionLayerEquirectKHR.nscale(this.address());
        }

        public XrVector2f bias() {
            return XrCompositionLayerEquirectKHR.nbias(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerEquirectKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000018000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerEquirectKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerEquirectKHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerEquirectKHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerEquirectKHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerEquirectKHR.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerEquirectKHR.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrCompositionLayerEquirectKHR.nradius(this.address(), value);
            return this;
        }

        public Buffer scale(XrVector2f value) {
            XrCompositionLayerEquirectKHR.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector2f> consumer) {
            consumer.accept(this.scale());
            return this;
        }

        public Buffer bias(XrVector2f value) {
            XrCompositionLayerEquirectKHR.nbias(this.address(), value);
            return this;
        }

        public Buffer bias(Consumer<XrVector2f> consumer) {
            consumer.accept(this.bias());
            return this;
        }
    }
}

