/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackEXT;
import org.lwjgl.openxr.XrDebugUtilsMessengerCallbackEXTI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsMessengerCreateInfoEXT
extends Struct<XrDebugUtilsMessengerCreateInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MESSAGESEVERITIES;
    public static final int MESSAGETYPES;
    public static final int USERCALLBACK;
    public static final int USERDATA;

    protected XrDebugUtilsMessengerCreateInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrDebugUtilsMessengerCreateInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrDebugUtilsMessengerCreateInfoEXT(address, container);
    }

    public XrDebugUtilsMessengerCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrDebugUtilsMessengerCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsMessengerCreateInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsMessengerCreateInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrDebugUtilsMessageSeverityFlagsEXT")
    public long messageSeverities() {
        return XrDebugUtilsMessengerCreateInfoEXT.nmessageSeverities(this.address());
    }

    @NativeType(value="XrDebugUtilsMessageTypeFlagsEXT")
    public long messageTypes() {
        return XrDebugUtilsMessengerCreateInfoEXT.nmessageTypes(this.address());
    }

    @NativeType(value="PFN_xrDebugUtilsMessengerCallbackEXT")
    public XrDebugUtilsMessengerCallbackEXT userCallback() {
        return XrDebugUtilsMessengerCreateInfoEXT.nuserCallback(this.address());
    }

    @NativeType(value="void *")
    public long userData() {
        return XrDebugUtilsMessengerCreateInfoEXT.nuserData(this.address());
    }

    public XrDebugUtilsMessengerCreateInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsMessengerCreateInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT type$Default() {
        return this.type(1000019002);
    }

    public XrDebugUtilsMessengerCreateInfoEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsMessengerCreateInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT messageSeverities(@NativeType(value="XrDebugUtilsMessageSeverityFlagsEXT") long value) {
        XrDebugUtilsMessengerCreateInfoEXT.nmessageSeverities(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT messageTypes(@NativeType(value="XrDebugUtilsMessageTypeFlagsEXT") long value) {
        XrDebugUtilsMessengerCreateInfoEXT.nmessageTypes(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT userCallback(@NativeType(value="PFN_xrDebugUtilsMessengerCallbackEXT") XrDebugUtilsMessengerCallbackEXTI value) {
        XrDebugUtilsMessengerCreateInfoEXT.nuserCallback(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT userData(@NativeType(value="void *") long value) {
        XrDebugUtilsMessengerCreateInfoEXT.nuserData(this.address(), value);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT set(int type, long next, long messageSeverities, long messageTypes, XrDebugUtilsMessengerCallbackEXTI userCallback, long userData) {
        this.type(type);
        this.next(next);
        this.messageSeverities(messageSeverities);
        this.messageTypes(messageTypes);
        this.userCallback(userCallback);
        this.userData(userData);
        return this;
    }

    public XrDebugUtilsMessengerCreateInfoEXT set(XrDebugUtilsMessengerCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrDebugUtilsMessengerCreateInfoEXT malloc() {
        return new XrDebugUtilsMessengerCreateInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCreateInfoEXT calloc() {
        return new XrDebugUtilsMessengerCreateInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrDebugUtilsMessengerCreateInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrDebugUtilsMessengerCreateInfoEXT create(long address) {
        return new XrDebugUtilsMessengerCreateInfoEXT(address, null);
    }

    @Nullable
    public static XrDebugUtilsMessengerCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrDebugUtilsMessengerCreateInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrDebugUtilsMessengerCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsMessengerCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDebugUtilsMessengerCreateInfoEXT malloc(MemoryStack stack) {
        return new XrDebugUtilsMessengerCreateInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDebugUtilsMessengerCreateInfoEXT calloc(MemoryStack stack) {
        return new XrDebugUtilsMessengerCreateInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nmessageSeverities(long struct) {
        return UNSAFE.getLong(null, struct + (long)MESSAGESEVERITIES);
    }

    public static long nmessageTypes(long struct) {
        return UNSAFE.getLong(null, struct + (long)MESSAGETYPES);
    }

    public static XrDebugUtilsMessengerCallbackEXT nuserCallback(long struct) {
        return XrDebugUtilsMessengerCallbackEXT.create(MemoryUtil.memGetAddress((long)(struct + (long)USERCALLBACK)));
    }

    public static long nuserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nmessageSeverities(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MESSAGESEVERITIES, value);
    }

    public static void nmessageTypes(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MESSAGETYPES, value);
    }

    public static void nuserCallback(long struct, XrDebugUtilsMessengerCallbackEXTI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERCALLBACK), (long)value.address());
    }

    public static void nuserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)USERCALLBACK)));
    }

    static {
        Struct.Layout layout = XrDebugUtilsMessengerCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{XrDebugUtilsMessengerCreateInfoEXT.__member((int)4), XrDebugUtilsMessengerCreateInfoEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCreateInfoEXT.__member((int)8), XrDebugUtilsMessengerCreateInfoEXT.__member((int)8), XrDebugUtilsMessengerCreateInfoEXT.__member((int)POINTER_SIZE), XrDebugUtilsMessengerCreateInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MESSAGESEVERITIES = layout.offsetof(2);
        MESSAGETYPES = layout.offsetof(3);
        USERCALLBACK = layout.offsetof(4);
        USERDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsMessengerCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsMessengerCreateInfoEXT ELEMENT_FACTORY = XrDebugUtilsMessengerCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrDebugUtilsMessengerCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsMessengerCreateInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsMessengerCreateInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrDebugUtilsMessageSeverityFlagsEXT")
        public long messageSeverities() {
            return XrDebugUtilsMessengerCreateInfoEXT.nmessageSeverities(this.address());
        }

        @NativeType(value="XrDebugUtilsMessageTypeFlagsEXT")
        public long messageTypes() {
            return XrDebugUtilsMessengerCreateInfoEXT.nmessageTypes(this.address());
        }

        @NativeType(value="PFN_xrDebugUtilsMessengerCallbackEXT")
        public XrDebugUtilsMessengerCallbackEXT userCallback() {
            return XrDebugUtilsMessengerCreateInfoEXT.nuserCallback(this.address());
        }

        @NativeType(value="void *")
        public long userData() {
            return XrDebugUtilsMessengerCreateInfoEXT.nuserData(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsMessengerCreateInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsMessengerCreateInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer messageSeverities(@NativeType(value="XrDebugUtilsMessageSeverityFlagsEXT") long value) {
            XrDebugUtilsMessengerCreateInfoEXT.nmessageSeverities(this.address(), value);
            return this;
        }

        public Buffer messageTypes(@NativeType(value="XrDebugUtilsMessageTypeFlagsEXT") long value) {
            XrDebugUtilsMessengerCreateInfoEXT.nmessageTypes(this.address(), value);
            return this;
        }

        public Buffer userCallback(@NativeType(value="PFN_xrDebugUtilsMessengerCallbackEXT") XrDebugUtilsMessengerCallbackEXTI value) {
            XrDebugUtilsMessengerCreateInfoEXT.nuserCallback(this.address(), value);
            return this;
        }

        public Buffer userData(@NativeType(value="void *") long value) {
            XrDebugUtilsMessengerCreateInfoEXT.nuserData(this.address(), value);
            return this;
        }
    }
}

