/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEnvironmentDepthImageViewMETA;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEnvironmentDepthImageMETA
extends Struct<XrEnvironmentDepthImageMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SWAPCHAININDEX;
    public static final int NEARZ;
    public static final int FARZ;
    public static final int VIEWS;

    protected XrEnvironmentDepthImageMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrEnvironmentDepthImageMETA create(long address, @Nullable ByteBuffer container) {
        return new XrEnvironmentDepthImageMETA(address, container);
    }

    public XrEnvironmentDepthImageMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrEnvironmentDepthImageMETA.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEnvironmentDepthImageMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEnvironmentDepthImageMETA.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int swapchainIndex() {
        return XrEnvironmentDepthImageMETA.nswapchainIndex(this.address());
    }

    public float nearZ() {
        return XrEnvironmentDepthImageMETA.nnearZ(this.address());
    }

    public float farZ() {
        return XrEnvironmentDepthImageMETA.nfarZ(this.address());
    }

    @NativeType(value="XrEnvironmentDepthImageViewMETA[2]")
    public XrEnvironmentDepthImageViewMETA.Buffer views() {
        return XrEnvironmentDepthImageMETA.nviews(this.address());
    }

    public XrEnvironmentDepthImageViewMETA views(int index) {
        return XrEnvironmentDepthImageMETA.nviews(this.address(), index);
    }

    public XrEnvironmentDepthImageMETA type(@NativeType(value="XrStructureType") int value) {
        XrEnvironmentDepthImageMETA.ntype(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA type$Default() {
        return this.type(1000291005);
    }

    public XrEnvironmentDepthImageMETA next(@NativeType(value="void const *") long value) {
        XrEnvironmentDepthImageMETA.nnext(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA swapchainIndex(@NativeType(value="uint32_t") int value) {
        XrEnvironmentDepthImageMETA.nswapchainIndex(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA nearZ(float value) {
        XrEnvironmentDepthImageMETA.nnearZ(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA farZ(float value) {
        XrEnvironmentDepthImageMETA.nfarZ(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA views(@NativeType(value="XrEnvironmentDepthImageViewMETA[2]") XrEnvironmentDepthImageViewMETA.Buffer value) {
        XrEnvironmentDepthImageMETA.nviews(this.address(), value);
        return this;
    }

    public XrEnvironmentDepthImageMETA views(int index, XrEnvironmentDepthImageViewMETA value) {
        XrEnvironmentDepthImageMETA.nviews(this.address(), index, value);
        return this;
    }

    public XrEnvironmentDepthImageMETA views(Consumer<XrEnvironmentDepthImageViewMETA.Buffer> consumer) {
        consumer.accept(this.views());
        return this;
    }

    public XrEnvironmentDepthImageMETA views(int index, Consumer<XrEnvironmentDepthImageViewMETA> consumer) {
        consumer.accept(this.views(index));
        return this;
    }

    public XrEnvironmentDepthImageMETA set(int type, long next, int swapchainIndex, float nearZ, float farZ, XrEnvironmentDepthImageViewMETA.Buffer views) {
        this.type(type);
        this.next(next);
        this.swapchainIndex(swapchainIndex);
        this.nearZ(nearZ);
        this.farZ(farZ);
        this.views(views);
        return this;
    }

    public XrEnvironmentDepthImageMETA set(XrEnvironmentDepthImageMETA src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrEnvironmentDepthImageMETA malloc() {
        return new XrEnvironmentDepthImageMETA(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrEnvironmentDepthImageMETA calloc() {
        return new XrEnvironmentDepthImageMETA(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrEnvironmentDepthImageMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrEnvironmentDepthImageMETA(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrEnvironmentDepthImageMETA create(long address) {
        return new XrEnvironmentDepthImageMETA(address, null);
    }

    @Nullable
    public static XrEnvironmentDepthImageMETA createSafe(long address) {
        return address == 0L ? null : new XrEnvironmentDepthImageMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrEnvironmentDepthImageMETA.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEnvironmentDepthImageMETA.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEnvironmentDepthImageMETA malloc(MemoryStack stack) {
        return new XrEnvironmentDepthImageMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEnvironmentDepthImageMETA calloc(MemoryStack stack) {
        return new XrEnvironmentDepthImageMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nswapchainIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)SWAPCHAININDEX);
    }

    public static float nnearZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)NEARZ);
    }

    public static float nfarZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)FARZ);
    }

    public static XrEnvironmentDepthImageViewMETA.Buffer nviews(long struct) {
        return XrEnvironmentDepthImageViewMETA.create(struct + (long)VIEWS, 2);
    }

    public static XrEnvironmentDepthImageViewMETA nviews(long struct, int index) {
        return XrEnvironmentDepthImageViewMETA.create(struct + (long)VIEWS + Checks.check((int)index, (int)2) * (long)XrEnvironmentDepthImageViewMETA.SIZEOF);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nswapchainIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SWAPCHAININDEX, value);
    }

    public static void nnearZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)NEARZ, value);
    }

    public static void nfarZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)FARZ, value);
    }

    public static void nviews(long struct, XrEnvironmentDepthImageViewMETA.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWS), (long)(value.remaining() * XrEnvironmentDepthImageViewMETA.SIZEOF));
    }

    public static void nviews(long struct, int index, XrEnvironmentDepthImageViewMETA value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWS + Checks.check((int)index, (int)2) * (long)XrEnvironmentDepthImageViewMETA.SIZEOF), (long)XrEnvironmentDepthImageViewMETA.SIZEOF);
    }

    static {
        Struct.Layout layout = XrEnvironmentDepthImageMETA.__struct((Struct.Member[])new Struct.Member[]{XrEnvironmentDepthImageMETA.__member((int)4), XrEnvironmentDepthImageMETA.__member((int)POINTER_SIZE), XrEnvironmentDepthImageMETA.__member((int)4), XrEnvironmentDepthImageMETA.__member((int)4), XrEnvironmentDepthImageMETA.__member((int)4), XrEnvironmentDepthImageMETA.__array((int)XrEnvironmentDepthImageViewMETA.SIZEOF, (int)XrEnvironmentDepthImageViewMETA.ALIGNOF, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SWAPCHAININDEX = layout.offsetof(2);
        NEARZ = layout.offsetof(3);
        FARZ = layout.offsetof(4);
        VIEWS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrEnvironmentDepthImageMETA, Buffer>
    implements NativeResource {
        private static final XrEnvironmentDepthImageMETA ELEMENT_FACTORY = XrEnvironmentDepthImageMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrEnvironmentDepthImageMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEnvironmentDepthImageMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEnvironmentDepthImageMETA.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int swapchainIndex() {
            return XrEnvironmentDepthImageMETA.nswapchainIndex(this.address());
        }

        public float nearZ() {
            return XrEnvironmentDepthImageMETA.nnearZ(this.address());
        }

        public float farZ() {
            return XrEnvironmentDepthImageMETA.nfarZ(this.address());
        }

        @NativeType(value="XrEnvironmentDepthImageViewMETA[2]")
        public XrEnvironmentDepthImageViewMETA.Buffer views() {
            return XrEnvironmentDepthImageMETA.nviews(this.address());
        }

        public XrEnvironmentDepthImageViewMETA views(int index) {
            return XrEnvironmentDepthImageMETA.nviews(this.address(), index);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEnvironmentDepthImageMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000291005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEnvironmentDepthImageMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer swapchainIndex(@NativeType(value="uint32_t") int value) {
            XrEnvironmentDepthImageMETA.nswapchainIndex(this.address(), value);
            return this;
        }

        public Buffer nearZ(float value) {
            XrEnvironmentDepthImageMETA.nnearZ(this.address(), value);
            return this;
        }

        public Buffer farZ(float value) {
            XrEnvironmentDepthImageMETA.nfarZ(this.address(), value);
            return this;
        }

        public Buffer views(@NativeType(value="XrEnvironmentDepthImageViewMETA[2]") XrEnvironmentDepthImageViewMETA.Buffer value) {
            XrEnvironmentDepthImageMETA.nviews(this.address(), value);
            return this;
        }

        public Buffer views(int index, XrEnvironmentDepthImageViewMETA value) {
            XrEnvironmentDepthImageMETA.nviews(this.address(), index, value);
            return this;
        }

        public Buffer views(Consumer<XrEnvironmentDepthImageViewMETA.Buffer> consumer) {
            consumer.accept(this.views());
            return this;
        }

        public Buffer views(int index, Consumer<XrEnvironmentDepthImageViewMETA> consumer) {
            consumer.accept(this.views(index));
            return this;
        }
    }
}

