/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataBuffer
extends Struct<XrEventDataBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VARYING;

    protected XrEventDataBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrEventDataBuffer create(long address, @Nullable ByteBuffer container) {
        return new XrEventDataBuffer(address, container);
    }

    public XrEventDataBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrEventDataBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataBuffer.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataBuffer.nnext(this.address());
    }

    @NativeType(value="uint8_t[4000]")
    public ByteBuffer varying() {
        return XrEventDataBuffer.nvarying(this.address());
    }

    @NativeType(value="uint8_t")
    public byte varying(int index) {
        return XrEventDataBuffer.nvarying(this.address(), index);
    }

    public XrEventDataBuffer type(@NativeType(value="XrStructureType") int value) {
        XrEventDataBuffer.ntype(this.address(), value);
        return this;
    }

    public XrEventDataBuffer type$Default() {
        return this.type(16);
    }

    public XrEventDataBuffer next(@NativeType(value="void const *") long value) {
        XrEventDataBuffer.nnext(this.address(), value);
        return this;
    }

    public XrEventDataBuffer varying(@NativeType(value="uint8_t[4000]") ByteBuffer value) {
        XrEventDataBuffer.nvarying(this.address(), value);
        return this;
    }

    public XrEventDataBuffer varying(int index, @NativeType(value="uint8_t") byte value) {
        XrEventDataBuffer.nvarying(this.address(), index, value);
        return this;
    }

    public XrEventDataBuffer set(int type, long next, ByteBuffer varying) {
        this.type(type);
        this.next(next);
        this.varying(varying);
        return this;
    }

    public XrEventDataBuffer set(XrEventDataBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrEventDataBuffer malloc() {
        return new XrEventDataBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrEventDataBuffer calloc() {
        return new XrEventDataBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrEventDataBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrEventDataBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrEventDataBuffer create(long address) {
        return new XrEventDataBuffer(address, null);
    }

    @Nullable
    public static XrEventDataBuffer createSafe(long address) {
        return address == 0L ? null : new XrEventDataBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrEventDataBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrEventDataBuffer malloc(MemoryStack stack) {
        return new XrEventDataBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrEventDataBuffer calloc(MemoryStack stack) {
        return new XrEventDataBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nvarying(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)VARYING), (int)4000);
    }

    public static byte nvarying(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)VARYING + Checks.check((int)index, (int)4000) * 1L);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nvarying(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4000);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)VARYING), (long)(value.remaining() * 1));
    }

    public static void nvarying(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)VARYING + Checks.check((int)index, (int)4000) * 1L, value);
    }

    static {
        Struct.Layout layout = XrEventDataBuffer.__struct((Struct.Member[])new Struct.Member[]{XrEventDataBuffer.__member((int)4), XrEventDataBuffer.__member((int)POINTER_SIZE), XrEventDataBuffer.__array((int)1, (int)4000)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VARYING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataBuffer, Buffer>
    implements NativeResource {
        private static final XrEventDataBuffer ELEMENT_FACTORY = XrEventDataBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrEventDataBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataBuffer.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataBuffer.nnext(this.address());
        }

        @NativeType(value="uint8_t[4000]")
        public ByteBuffer varying() {
            return XrEventDataBuffer.nvarying(this.address());
        }

        @NativeType(value="uint8_t")
        public byte varying(int index) {
            return XrEventDataBuffer.nvarying(this.address(), index);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataBuffer.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(16);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataBuffer.nnext(this.address(), value);
            return this;
        }

        public Buffer varying(@NativeType(value="uint8_t[4000]") ByteBuffer value) {
            XrEventDataBuffer.nvarying(this.address(), value);
            return this;
        }

        public Buffer varying(int index, @NativeType(value="uint8_t") byte value) {
            XrEventDataBuffer.nvarying(this.address(), index, value);
            return this;
        }
    }
}

