/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent2Di
extends Struct<XrExtent2Di>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected XrExtent2Di(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExtent2Di create(long address, @Nullable ByteBuffer container) {
        return new XrExtent2Di(address, container);
    }

    public XrExtent2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent2Di.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int width() {
        return XrExtent2Di.nwidth(this.address());
    }

    @NativeType(value="int32_t")
    public int height() {
        return XrExtent2Di.nheight(this.address());
    }

    public XrExtent2Di width(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nwidth(this.address(), value);
        return this;
    }

    public XrExtent2Di height(@NativeType(value="int32_t") int value) {
        XrExtent2Di.nheight(this.address(), value);
        return this;
    }

    public XrExtent2Di set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public XrExtent2Di set(XrExtent2Di src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent2Di malloc() {
        return new XrExtent2Di(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExtent2Di calloc() {
        return new XrExtent2Di(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExtent2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExtent2Di(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExtent2Di create(long address) {
        return new XrExtent2Di(address, null);
    }

    @Nullable
    public static XrExtent2Di createSafe(long address) {
        return address == 0L ? null : new XrExtent2Di(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExtent2Di.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent2Di.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent2Di malloc(MemoryStack stack) {
        return new XrExtent2Di(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent2Di calloc(MemoryStack stack) {
        return new XrExtent2Di(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = XrExtent2Di.__struct((Struct.Member[])new Struct.Member[]{XrExtent2Di.__member((int)4), XrExtent2Di.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrExtent2Di, Buffer>
    implements NativeResource {
        private static final XrExtent2Di ELEMENT_FACTORY = XrExtent2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int width() {
            return XrExtent2Di.nwidth(this.address());
        }

        @NativeType(value="int32_t")
        public int height() {
            return XrExtent2Di.nheight(this.address());
        }

        public Buffer width(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="int32_t") int value) {
            XrExtent2Di.nheight(this.address(), value);
            return this;
        }
    }
}

