/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtent3Df
extends Struct<XrExtent3Df>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;

    protected XrExtent3Df(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExtent3Df create(long address, @Nullable ByteBuffer container) {
        return new XrExtent3Df(address, container);
    }

    public XrExtent3Df(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExtent3Df.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return XrExtent3Df.nwidth(this.address());
    }

    public float height() {
        return XrExtent3Df.nheight(this.address());
    }

    public float depth() {
        return XrExtent3Df.ndepth(this.address());
    }

    public XrExtent3Df width(float value) {
        XrExtent3Df.nwidth(this.address(), value);
        return this;
    }

    public XrExtent3Df height(float value) {
        XrExtent3Df.nheight(this.address(), value);
        return this;
    }

    public XrExtent3Df depth(float value) {
        XrExtent3Df.ndepth(this.address(), value);
        return this;
    }

    public XrExtent3Df set(float width, float height, float depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public XrExtent3Df set(XrExtent3Df src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent3Df malloc() {
        return new XrExtent3Df(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExtent3Df calloc() {
        return new XrExtent3Df(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExtent3Df create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExtent3Df(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExtent3Df create(long address) {
        return new XrExtent3Df(address, null);
    }

    @Nullable
    public static XrExtent3Df createSafe(long address) {
        return address == 0L ? null : new XrExtent3Df(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExtent3Df.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent3Df.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent3Df malloc(MemoryStack stack) {
        return new XrExtent3Df(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent3Df calloc(MemoryStack stack) {
        return new XrExtent3Df(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float ndepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DEPTH);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void ndepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = XrExtent3Df.__struct((Struct.Member[])new Struct.Member[]{XrExtent3Df.__member((int)4), XrExtent3Df.__member((int)4), XrExtent3Df.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        DEPTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrExtent3Df, Buffer>
    implements NativeResource {
        private static final XrExtent3Df ELEMENT_FACTORY = XrExtent3Df.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrExtent3Df getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return XrExtent3Df.nwidth(this.address());
        }

        public float height() {
            return XrExtent3Df.nheight(this.address());
        }

        public float depth() {
            return XrExtent3Df.ndepth(this.address());
        }

        public Buffer width(float value) {
            XrExtent3Df.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            XrExtent3Df.nheight(this.address(), value);
            return this;
        }

        public Buffer depth(float value) {
            XrExtent3Df.ndepth(this.address(), value);
            return this;
        }
    }
}

