/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFoveationConfigurationHTC
extends Struct<XrFoveationConfigurationHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEVEL;
    public static final int CLEARFOVDEGREE;
    public static final int FOCALCENTEROFFSET;

    protected XrFoveationConfigurationHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFoveationConfigurationHTC create(long address, @Nullable ByteBuffer container) {
        return new XrFoveationConfigurationHTC(address, container);
    }

    public XrFoveationConfigurationHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFoveationConfigurationHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrFoveationLevelHTC")
    public int level() {
        return XrFoveationConfigurationHTC.nlevel(this.address());
    }

    public float clearFovDegree() {
        return XrFoveationConfigurationHTC.nclearFovDegree(this.address());
    }

    public XrVector2f focalCenterOffset() {
        return XrFoveationConfigurationHTC.nfocalCenterOffset(this.address());
    }

    public XrFoveationConfigurationHTC level(@NativeType(value="XrFoveationLevelHTC") int value) {
        XrFoveationConfigurationHTC.nlevel(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC clearFovDegree(float value) {
        XrFoveationConfigurationHTC.nclearFovDegree(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC focalCenterOffset(XrVector2f value) {
        XrFoveationConfigurationHTC.nfocalCenterOffset(this.address(), value);
        return this;
    }

    public XrFoveationConfigurationHTC focalCenterOffset(Consumer<XrVector2f> consumer) {
        consumer.accept(this.focalCenterOffset());
        return this;
    }

    public XrFoveationConfigurationHTC set(int level, float clearFovDegree, XrVector2f focalCenterOffset) {
        this.level(level);
        this.clearFovDegree(clearFovDegree);
        this.focalCenterOffset(focalCenterOffset);
        return this;
    }

    public XrFoveationConfigurationHTC set(XrFoveationConfigurationHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFoveationConfigurationHTC malloc() {
        return new XrFoveationConfigurationHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFoveationConfigurationHTC calloc() {
        return new XrFoveationConfigurationHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFoveationConfigurationHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFoveationConfigurationHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFoveationConfigurationHTC create(long address) {
        return new XrFoveationConfigurationHTC(address, null);
    }

    @Nullable
    public static XrFoveationConfigurationHTC createSafe(long address) {
        return address == 0L ? null : new XrFoveationConfigurationHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFoveationConfigurationHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFoveationConfigurationHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFoveationConfigurationHTC malloc(MemoryStack stack) {
        return new XrFoveationConfigurationHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFoveationConfigurationHTC calloc(MemoryStack stack) {
        return new XrFoveationConfigurationHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVEL);
    }

    public static float nclearFovDegree(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CLEARFOVDEGREE);
    }

    public static XrVector2f nfocalCenterOffset(long struct) {
        return XrVector2f.create(struct + (long)FOCALCENTEROFFSET);
    }

    public static void nlevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVEL, value);
    }

    public static void nclearFovDegree(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)CLEARFOVDEGREE, value);
    }

    public static void nfocalCenterOffset(long struct, XrVector2f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOCALCENTEROFFSET), (long)XrVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrFoveationConfigurationHTC.__struct((Struct.Member[])new Struct.Member[]{XrFoveationConfigurationHTC.__member((int)4), XrFoveationConfigurationHTC.__member((int)4), XrFoveationConfigurationHTC.__member((int)XrVector2f.SIZEOF, (int)XrVector2f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LEVEL = layout.offsetof(0);
        CLEARFOVDEGREE = layout.offsetof(1);
        FOCALCENTEROFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFoveationConfigurationHTC, Buffer>
    implements NativeResource {
        private static final XrFoveationConfigurationHTC ELEMENT_FACTORY = XrFoveationConfigurationHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFoveationConfigurationHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrFoveationLevelHTC")
        public int level() {
            return XrFoveationConfigurationHTC.nlevel(this.address());
        }

        public float clearFovDegree() {
            return XrFoveationConfigurationHTC.nclearFovDegree(this.address());
        }

        public XrVector2f focalCenterOffset() {
            return XrFoveationConfigurationHTC.nfocalCenterOffset(this.address());
        }

        public Buffer level(@NativeType(value="XrFoveationLevelHTC") int value) {
            XrFoveationConfigurationHTC.nlevel(this.address(), value);
            return this;
        }

        public Buffer clearFovDegree(float value) {
            XrFoveationConfigurationHTC.nclearFovDegree(this.address(), value);
            return this;
        }

        public Buffer focalCenterOffset(XrVector2f value) {
            XrFoveationConfigurationHTC.nfocalCenterOffset(this.address(), value);
            return this;
        }

        public Buffer focalCenterOffset(Consumer<XrVector2f> consumer) {
            consumer.accept(this.focalCenterOffset());
            return this;
        }
    }
}

