/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFutureCompletionBaseHeaderEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFutureCompletionEXT
extends Struct<XrFutureCompletionEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FUTURERESULT;

    protected XrFutureCompletionEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFutureCompletionEXT create(long address, @Nullable ByteBuffer container) {
        return new XrFutureCompletionEXT(address, container);
    }

    public XrFutureCompletionEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFutureCompletionEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFutureCompletionEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrFutureCompletionEXT.nnext(this.address());
    }

    @NativeType(value="XrResult")
    public int futureResult() {
        return XrFutureCompletionEXT.nfutureResult(this.address());
    }

    public XrFutureCompletionEXT type(@NativeType(value="XrStructureType") int value) {
        XrFutureCompletionEXT.ntype(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT type$Default() {
        return this.type(1000469002);
    }

    public XrFutureCompletionEXT next(@NativeType(value="void *") long value) {
        XrFutureCompletionEXT.nnext(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT futureResult(@NativeType(value="XrResult") int value) {
        XrFutureCompletionEXT.nfutureResult(this.address(), value);
        return this;
    }

    public XrFutureCompletionEXT set(int type, long next, int futureResult) {
        this.type(type);
        this.next(next);
        this.futureResult(futureResult);
        return this;
    }

    public XrFutureCompletionEXT set(XrFutureCompletionEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFutureCompletionEXT malloc() {
        return new XrFutureCompletionEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFutureCompletionEXT calloc() {
        return new XrFutureCompletionEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFutureCompletionEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFutureCompletionEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFutureCompletionEXT create(long address) {
        return new XrFutureCompletionEXT(address, null);
    }

    @Nullable
    public static XrFutureCompletionEXT createSafe(long address) {
        return address == 0L ? null : new XrFutureCompletionEXT(address, null);
    }

    public static XrFutureCompletionEXT create(XrFutureCompletionBaseHeaderEXT value) {
        return new XrFutureCompletionEXT(value.address(), XrFutureCompletionEXT.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFutureCompletionEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFutureCompletionEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrFutureCompletionBaseHeaderEXT.Buffer value) {
        return new Buffer(value.address(), XrFutureCompletionEXT.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrFutureCompletionEXT malloc(MemoryStack stack) {
        return new XrFutureCompletionEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFutureCompletionEXT calloc(MemoryStack stack) {
        return new XrFutureCompletionEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nfutureResult(long struct) {
        return UNSAFE.getInt(null, struct + (long)FUTURERESULT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nfutureResult(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FUTURERESULT, value);
    }

    static {
        Struct.Layout layout = XrFutureCompletionEXT.__struct((Struct.Member[])new Struct.Member[]{XrFutureCompletionEXT.__member((int)4), XrFutureCompletionEXT.__member((int)POINTER_SIZE), XrFutureCompletionEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FUTURERESULT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFutureCompletionEXT, Buffer>
    implements NativeResource {
        private static final XrFutureCompletionEXT ELEMENT_FACTORY = XrFutureCompletionEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrFutureCompletionEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFutureCompletionEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrFutureCompletionEXT.nnext(this.address());
        }

        @NativeType(value="XrResult")
        public int futureResult() {
            return XrFutureCompletionEXT.nfutureResult(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFutureCompletionEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000469002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrFutureCompletionEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer futureResult(@NativeType(value="XrResult") int value) {
            XrFutureCompletionEXT.nfutureResult(this.address(), value);
            return this;
        }
    }
}

